/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.rest;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.tapestry5.annotations.RequestParameter;
import org.apache.tapestry5.annotations.RestInfo;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.rest.MappedEntityManager;
import org.apache.tapestry5.services.rest.OpenApiTypeDescriber;

public class DefaultOpenApiTypeDescriber
implements OpenApiTypeDescriber {
    final Set<Class<?>> mappedEntities;
    private static final String ARRAY_TYPE = "array";
    private static final String OBJECT_TYPE = "object";
    private static final String STRING_TYPE = "string";
    private static final Function<Class<?>, String> TO_INTEGER = c -> "integer";
    private static final Function<Class<?>, String> TO_BOOLEAN = c -> "boolean";
    private static final Function<Class<?>, String> TO_NUMBER = c -> "number";
    private static final List<Handler> MAPPERS = Arrays.asList(new Handler(Integer.TYPE, TO_INTEGER), new Handler(Integer.class, TO_INTEGER), new Handler(Byte.TYPE, TO_INTEGER), new Handler(Byte.class, TO_INTEGER), new Handler(Short.TYPE, TO_INTEGER), new Handler(Short.class, TO_INTEGER), new Handler(Long.TYPE, TO_INTEGER), new Handler(Long.class, TO_INTEGER), new Handler(Float.TYPE, TO_NUMBER), new Handler(Float.class, TO_NUMBER), new Handler(Double.TYPE, TO_NUMBER), new Handler(Double.class, TO_NUMBER), new Handler(Boolean.TYPE, TO_BOOLEAN), new Handler(Boolean.class, TO_BOOLEAN), new Handler(String.class, c -> "string"), new Handler(Character.TYPE, c -> "string"), new Handler(Character.class, c -> "string"), new Handler(JSONObject.class, c -> "object"), new Handler(JSONArray.class, c -> "array"));

    public DefaultOpenApiTypeDescriber(MappedEntityManager mappedEntityManager) {
        this.mappedEntities = mappedEntityManager.getEntities();
    }

    @Override
    public void describe(JSONObject description, Parameter parameter) {
        this.describeType(description, parameter.getType());
        RequestParameter requestParameter = parameter.getAnnotation(RequestParameter.class);
        if (requestParameter == null || requestParameter != null && !requestParameter.allowBlank()) {
            description.put("required", (Object)true);
        }
    }

    @Override
    public void describeReturnType(JSONObject description, Method method) {
        RestInfo restInfo = method.getAnnotation(RestInfo.class);
        Class<?> returnedType = restInfo != null ? restInfo.returnType() : method.getReturnType();
        this.describeType(description, returnedType);
    }

    private JSONObject describeType(JSONObject description, Class<?> type) {
        JSONObject schema = description.getJSONObjectOrDefault("schema", null);
        if (schema == null) {
            Optional<String> schemaType = this.getOpenApiType(type);
            if (schemaType.isPresent()) {
                schema = description.put("schema", (Object)new JSONObject(new Object[]{"type", schemaType.get()}));
            } else if (this.mappedEntities.contains(type)) {
                schema = description.put("schema", (Object)new JSONObject(new Object[]{"$ref", this.getSchemaReference(type)}));
            }
        }
        return schema;
    }

    private Optional<String> getOpenApiType(Class<?> type) {
        Optional<String> schemaType = MAPPERS.stream().filter(h -> ((Handler)h).type.equals(type)).map(h -> h.getMapper().apply(type)).findFirst();
        return schemaType;
    }

    @Override
    public void describeSchema(Class<?> entity, JSONObject schemas) {
        String name = this.getSchemaName(entity);
        if (!schemas.containsKey((Object)name)) {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo;
            JSONObject schema = new JSONObject();
            JSONObject properties = new JSONObject();
            try {
                beanInfo = Introspector.getBeanInfo(entity, Object.class);
            }
            catch (IntrospectionException e) {
                throw new RuntimeException(e);
            }
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String propertyName = propertyDescriptor.getName();
                Class<?> type = propertyDescriptor.getPropertyType();
                Optional<String> schemaType = this.getOpenApiType(type);
                if (!schemaType.isPresent()) continue;
                JSONObject propertyDescription = new JSONObject();
                propertyDescription.put("type", (Object)schemaType.get());
                properties.put(propertyName, (Object)propertyDescription);
            }
            schema.put("properties", (Object)properties);
            schemas.put(name, (Object)schema);
        }
    }

    private String getSchemaName(Class<?> entity) {
        return entity.getSimpleName();
    }

    private String getSchemaReference(Class<?> entity) {
        return "#/components/schemas/" + this.getSchemaName(entity);
    }

    private static final class Handler {
        private final Class<?> type;
        private final Function<Class<?>, String> mapper;

        public Handler(Class<?> type, Function<Class<?>, String> mapper) {
            this.type = type;
            this.mapper = mapper;
        }

        public Function<Class<?>, String> getMapper() {
            return this.mapper;
        }
    }
}

