/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer;

import java.io.Serializable;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;

public final class KeyValue<K, V>
implements Serializable {
    private final K key;
    private final V value;
    private static final String EMPTY_STRING = "";
    private static final String TAB = "\t";
    private static final String NULL = "null";

    public KeyValue(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public String toString() {
        if (this.key instanceof MapReduce.NullObject && this.value instanceof MapReduce.NullObject) {
            return EMPTY_STRING;
        }
        if (this.key instanceof MapReduce.NullObject) {
            return KeyValue.makeString(this.value);
        }
        if (this.value instanceof MapReduce.NullObject) {
            return KeyValue.makeString(this.key);
        }
        return KeyValue.makeString(this.key) + TAB + KeyValue.makeString(this.value);
    }

    private static final String makeString(Object object) {
        return null == object ? NULL : object.toString();
    }
}

