/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.language.translator;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParser;
import org.apache.tinkerpop.gremlin.language.translator.TranslateVisitor;

public class AnonymizedTranslatorVisitor
extends TranslateVisitor {
    private final Map<String, Map<Object, String>> simpleNameToObjectCache = new HashMap<String, Map<Object, String>>();

    public AnonymizedTranslatorVisitor() {
        this("g");
    }

    public AnonymizedTranslatorVisitor(String graphTraversalSourceName) {
        super(graphTraversalSourceName);
    }

    protected Void anonymize(ParserRuleContext ctx, Class<?> clazz) {
        String text = ctx.getText();
        String type = clazz.getSimpleName();
        Map<Object, String> objectToAnonymizedString = this.simpleNameToObjectCache.get(type);
        if (objectToAnonymizedString != null) {
            String innerValue = objectToAnonymizedString.get(text);
            if (innerValue != null) {
                this.sb.append(innerValue);
            } else {
                String anonymizedValue = type.toLowerCase() + objectToAnonymizedString.size();
                objectToAnonymizedString.put(text, anonymizedValue);
                this.sb.append(anonymizedValue);
            }
        } else {
            objectToAnonymizedString = new HashMap<Object, String>();
            this.simpleNameToObjectCache.put(type, objectToAnonymizedString);
            String anonymizedValue = type.toLowerCase() + objectToAnonymizedString.size();
            objectToAnonymizedString.put(text, anonymizedValue);
            this.sb.append(anonymizedValue);
        }
        return null;
    }

    @Override
    public Void visitGenericLiteralSet(GremlinParser.GenericLiteralSetContext ctx) {
        return this.anonymize((ParserRuleContext)ctx, Set.class);
    }

    @Override
    public Void visitGenericLiteralCollection(GremlinParser.GenericLiteralCollectionContext ctx) {
        return this.anonymize((ParserRuleContext)ctx, List.class);
    }

    @Override
    public Void visitGenericLiteralMap(GremlinParser.GenericLiteralMapContext ctx) {
        return this.anonymize((ParserRuleContext)ctx, Map.class);
    }

    @Override
    public Void visitGenericLiteralMapNullableArgument(GremlinParser.GenericLiteralMapNullableArgumentContext ctx) {
        return this.anonymize((ParserRuleContext)ctx, Map.class);
    }

    @Override
    public Void visitStringLiteral(GremlinParser.StringLiteralContext ctx) {
        return this.anonymize((ParserRuleContext)ctx, String.class);
    }

    @Override
    public Void visitStringNullableLiteral(GremlinParser.StringNullableLiteralContext ctx) {
        return this.anonymize((ParserRuleContext)ctx, String.class);
    }

    @Override
    public Void visitIntegerLiteral(GremlinParser.IntegerLiteralContext ctx) {
        String integerLiteral = ctx.getText().toLowerCase();
        int lastCharIndex = integerLiteral.length() - 1;
        char lastCharacter = integerLiteral.charAt(lastCharIndex);
        switch (lastCharacter) {
            case 'b': {
                this.anonymize((ParserRuleContext)ctx, Byte.class);
                break;
            }
            case 's': {
                this.anonymize((ParserRuleContext)ctx, Short.class);
                break;
            }
            case 'i': {
                this.anonymize((ParserRuleContext)ctx, Integer.class);
                break;
            }
            case 'l': {
                this.anonymize((ParserRuleContext)ctx, Long.class);
                break;
            }
            case 'n': {
                this.anonymize((ParserRuleContext)ctx, BigInteger.class);
                break;
            }
            default: {
                this.anonymize((ParserRuleContext)ctx, Number.class);
            }
        }
        return null;
    }

    @Override
    public Void visitFloatLiteral(GremlinParser.FloatLiteralContext ctx) {
        String floatLiteral = ctx.getText().toLowerCase();
        int lastCharIndex = floatLiteral.length() - 1;
        char lastCharacter = floatLiteral.charAt(lastCharIndex);
        switch (lastCharacter) {
            case 'f': {
                this.anonymize((ParserRuleContext)ctx, Float.class);
                break;
            }
            case 'd': {
                this.anonymize((ParserRuleContext)ctx, Double.class);
                break;
            }
            case 'm': {
                this.anonymize((ParserRuleContext)ctx, BigDecimal.class);
                break;
            }
            default: {
                this.anonymize((ParserRuleContext)ctx, Number.class);
            }
        }
        return null;
    }

    @Override
    public Void visitBooleanLiteral(GremlinParser.BooleanLiteralContext ctx) {
        return this.anonymize((ParserRuleContext)ctx, Boolean.class);
    }

    @Override
    public Void visitDateLiteral(GremlinParser.DateLiteralContext ctx) {
        return this.anonymize((ParserRuleContext)ctx, Date.class);
    }

    @Override
    public Void visitNullLiteral(GremlinParser.NullLiteralContext ctx) {
        return this.anonymize((ParserRuleContext)ctx, Object.class);
    }

    @Override
    public Void visitNanLiteral(GremlinParser.NanLiteralContext ctx) {
        return this.anonymize((ParserRuleContext)ctx, Number.class);
    }

    @Override
    public Void visitInfLiteral(GremlinParser.InfLiteralContext ctx) {
        return this.anonymize((ParserRuleContext)ctx, Number.class);
    }
}

