/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.traversal.strategy.optimization.GraphFilterStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.Contains;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.GType;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValue;
import org.apache.tinkerpop.gremlin.process.traversal.step.LambdaHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.AndStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.DedupGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.DropStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.OrStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.TraversalFilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MatchStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.AdjacentToIncidentStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.FilterRankingStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.IdentityRemovalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.MatchPredicateStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.PathRetractionStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.T;

public final class InlineFilterStrategy
extends AbstractTraversalStrategy<TraversalStrategy.OptimizationStrategy>
implements TraversalStrategy.OptimizationStrategy {
    private static final InlineFilterStrategy INSTANCE = new InlineFilterStrategy();
    private static final Set<Class<? extends TraversalStrategy.OptimizationStrategy>> POSTS = new HashSet<Class>(Arrays.asList(GraphFilterStrategy.class, AdjacentToIncidentStrategy.class, PathRetractionStrategy.class));
    private static final Set<Class<? extends TraversalStrategy.OptimizationStrategy>> PRIORS = new HashSet<Class>(Arrays.asList(FilterRankingStrategy.class, IdentityRemovalStrategy.class, MatchPredicateStrategy.class));

    private InlineFilterStrategy() {
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        boolean changed = true;
        while (changed) {
            changed = false;
            Iterator<FilterStep> filterStepIterator = TraversalHelper.getStepsOfAssignableClass(FilterStep.class, traversal).iterator();
            while (!changed && filterStepIterator.hasNext()) {
                FilterStep step = filterStepIterator.next();
                changed = step instanceof HasStep && InlineFilterStrategy.processHasStep((HasStep)step, traversal) || step instanceof TraversalFilterStep && InlineFilterStrategy.processTraversalFilterStep((TraversalFilterStep)step, traversal) || step instanceof OrStep && InlineFilterStrategy.processOrStep((OrStep)step, traversal) || step instanceof AndStep && InlineFilterStrategy.processAndStep((AndStep)step, traversal);
            }
            if (changed || !traversal.isRoot()) continue;
            Iterator<MatchStep> matchStepIterator = TraversalHelper.getStepsOfClass(MatchStep.class, traversal).iterator();
            while (!changed && matchStepIterator.hasNext()) {
                if (!InlineFilterStrategy.processMatchStep(matchStepIterator.next(), traversal)) continue;
                changed = true;
            }
        }
    }

    private static boolean processHasStep(HasStep<?> step, Traversal.Admin<?, ?> traversal) {
        if (step.getPreviousStep() instanceof HasStep) {
            HasStep previousStep = (HasStep)step.getPreviousStep();
            ArrayList<HasContainer> hasContainers = new ArrayList<HasContainer>(step.getHasContainers());
            for (HasContainer hasContainer : hasContainers) {
                previousStep.addHasContainer(hasContainer);
            }
            TraversalHelper.copyLabels(step, previousStep, false);
            traversal.removeStep(step);
            return true;
        }
        if (step.getPreviousStep() instanceof VertexStep && ((VertexStep)step.getPreviousStep()).returnsEdge() && 0 == ((VertexStep)step.getPreviousStep()).getEdgeLabels().length) {
            VertexStep previousStep = (VertexStep)step.getPreviousStep();
            ArrayList<Object> edgeLabels = new ArrayList<Object>();
            for (HasContainer hasContainer : new ArrayList<HasContainer>(step.getHasContainers())) {
                if (!hasContainer.getKey().equals(T.label.getAccessor())) continue;
                if (hasContainer.getBiPredicate() == Compare.eq && GValue.instanceOf(hasContainer.getValue(), GType.STRING) && edgeLabels.isEmpty()) {
                    edgeLabels.add(hasContainer.getValue());
                    step.removeHasContainer(hasContainer);
                    continue;
                }
                if (hasContainer.getBiPredicate() == Contains.within && hasContainer.getValue() instanceof Collection && ((Collection)hasContainer.getValue()).containsAll(edgeLabels)) {
                    edgeLabels.addAll((Collection)hasContainer.getValue());
                    step.removeHasContainer(hasContainer);
                    continue;
                }
                if (!(hasContainer.getPredicate() instanceof OrP) || !edgeLabels.isEmpty()) continue;
                boolean removeContainer = true;
                List orps = ((OrP)hasContainer.getPredicate()).getPredicates();
                ArrayList newEdges = new ArrayList();
                for (int i = 0; i < orps.size(); ++i) {
                    if (orps.get(i).getBiPredicate() != Compare.eq || !GValue.instanceOf(orps.get(i).getValue(), GType.STRING)) {
                        removeContainer = false;
                        break;
                    }
                    newEdges.add(orps.get(i).getValue());
                }
                if (!removeContainer) continue;
                edgeLabels.addAll(newEdges);
                step.removeHasContainer(hasContainer);
            }
            if (!edgeLabels.isEmpty()) {
                VertexStep<Edge> newVertexStep = new VertexStep<Edge>(traversal, Edge.class, previousStep.getDirection(), GValue.ensureGValues(edgeLabels.toArray()));
                TraversalHelper.replaceStep(previousStep, newVertexStep, traversal);
                TraversalHelper.copyLabels(previousStep, newVertexStep, false);
                if (step.getHasContainers().isEmpty()) {
                    TraversalHelper.copyLabels(step, newVertexStep, false);
                    traversal.removeStep(step);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private static final boolean processTraversalFilterStep(TraversalFilterStep<?> step, Traversal.Admin<?, ?> traversal) {
        Traversal.Admin<?, ?> childTraversal = step.getLocalChildren().get(0);
        if (TraversalHelper.hasAllStepsOfClass(childTraversal, FilterStep.class) && !TraversalHelper.hasStepOfClass(childTraversal, DropStep.class, RangeGlobalStep.class, DedupGlobalStep.class, LambdaHolder.class)) {
            Step<?, ?> finalStep = childTraversal.getEndStep();
            TraversalHelper.insertTraversal(step, childTraversal, traversal);
            TraversalHelper.copyLabels(step, finalStep, false);
            traversal.removeStep(step);
            return true;
        }
        return false;
    }

    private static final boolean processOrStep(OrStep<?> step, Traversal.Admin<?, ?> traversal) {
        boolean process = true;
        String key = null;
        P<?> predicate = null;
        ArrayList<String> labels = new ArrayList<String>();
        for (Traversal.Admin childTraversal : step.getLocalChildren()) {
            InlineFilterStrategy.instance().apply(childTraversal);
            for (Step childStep : childTraversal.getSteps()) {
                if (childStep instanceof HasStep) {
                    P<?> p = null;
                    for (HasContainer hasContainer : ((HasStep)childStep).getHasContainers()) {
                        if (null == key) {
                            key = hasContainer.getKey();
                        } else if (!hasContainer.getKey().equals(key)) {
                            process = false;
                            break;
                        }
                        p = null == p ? hasContainer.getPredicate() : p.and(hasContainer.getPredicate());
                    }
                    if (process) {
                        predicate = null == predicate ? p : predicate.or(p);
                    }
                    labels.addAll(childStep.getLabels());
                    continue;
                }
                process = false;
                break;
            }
            if (process) continue;
            break;
        }
        if (process) {
            HasStep hasStep = new HasStep(traversal, new HasContainer(key, predicate));
            TraversalHelper.replaceStep(step, hasStep, traversal);
            TraversalHelper.copyLabels(step, hasStep, false);
            for (String label : labels) {
                hasStep.addLabel(label);
            }
            return true;
        }
        return false;
    }

    private static final boolean processAndStep(AndStep<?> step, Traversal.Admin<?, ?> traversal) {
        boolean process = true;
        for (Traversal.Admin childTraversal : step.getLocalChildren()) {
            if (TraversalHelper.hasAllStepsOfClass(childTraversal, FilterStep.class) && !TraversalHelper.hasStepOfClass(childTraversal, DropStep.class, RangeGlobalStep.class, DedupGlobalStep.class, LambdaHolder.class)) continue;
            process = false;
            break;
        }
        if (process) {
            List childTraversals = step.getLocalChildren();
            Step<?, ?> finalStep = null;
            for (int i = childTraversals.size() - 1; i >= 0; --i) {
                Traversal.Admin childTraversal = childTraversals.get(i);
                if (null == finalStep) {
                    finalStep = childTraversal.getEndStep();
                }
                TraversalHelper.insertTraversal(step, childTraversals.get(i), traversal);
            }
            if (null != finalStep) {
                TraversalHelper.copyLabels(step, finalStep, false);
            }
            traversal.removeStep(step);
            return true;
        }
        return false;
    }

    private static final boolean processMatchStep(MatchStep<?, ?> step, Traversal.Admin<?, ?> traversal) {
        if (step.getPreviousStep() instanceof EmptyStep) {
            return false;
        }
        boolean changed = false;
        String startLabel = MatchStep.Helper.computeStartLabel(step.getGlobalChildren());
        for (Traversal.Admin<Object, Object> matchTraversal : new ArrayList<Traversal.Admin<Object, Object>>(step.getGlobalChildren())) {
            if (!TraversalHelper.hasAllStepsOfClass(matchTraversal, HasStep.class, MatchStep.MatchStartStep.class, MatchStep.MatchEndStep.class) || !(matchTraversal.getStartStep() instanceof MatchStep.MatchStartStep) || !startLabel.equals(((MatchStep.MatchStartStep)matchTraversal.getStartStep()).getSelectKey().orElse(null))) continue;
            changed = true;
            step.removeGlobalChild(matchTraversal);
            String endLabel = ((MatchStep.MatchEndStep)matchTraversal.getEndStep()).getMatchKey().orElse(null);
            matchTraversal.removeStep(0);
            matchTraversal.removeStep(matchTraversal.getSteps().size() - 1);
            matchTraversal.getEndStep().addLabel(startLabel);
            if (null != endLabel) {
                matchTraversal.getEndStep().addLabel(endLabel);
            }
            TraversalHelper.insertTraversal(step.getPreviousStep(), matchTraversal, traversal);
        }
        if (step.getGlobalChildren().isEmpty()) {
            traversal.removeStep(step);
        }
        return changed;
    }

    @Override
    public Set<Class<? extends TraversalStrategy.OptimizationStrategy>> applyPost() {
        return POSTS;
    }

    @Override
    public Set<Class<? extends TraversalStrategy.OptimizationStrategy>> applyPrior() {
        return PRIORS;
    }

    public static InlineFilterStrategy instance() {
        return INSTANCE;
    }
}

