/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class MapSerializer
extends SimpleTypeSerializer<Map> {
    public MapSerializer() {
        super(DataType.MAP);
    }

    @Override
    public Map readValue(Buffer buffer, GraphBinaryReader context, boolean nullable) throws IOException {
        if (nullable) {
            byte valueFlag = buffer.readByte();
            if ((valueFlag & 1) == 1) {
                return null;
            }
            if ((valueFlag & 2) == 2) {
                return this.readValue(buffer, context);
            }
        }
        return this.readMap(buffer, context);
    }

    @Override
    protected Map readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        int length = buffer.readInt();
        LinkedHashMap result = new LinkedHashMap(length);
        for (int i = 0; i < length; ++i) {
            result.put(context.read(buffer), context.read(buffer));
        }
        return result;
    }

    private Map readMap(Buffer buffer, GraphBinaryReader context) throws IOException {
        int length = buffer.readInt();
        HashMap result = new HashMap(length);
        for (int i = 0; i < length; ++i) {
            result.put(context.read(buffer), context.read(buffer));
        }
        return result;
    }

    @Override
    protected void writeValue(Map value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        buffer.writeInt(value.size());
        for (Map.Entry entry : value.entrySet()) {
            context.write(entry.getKey(), buffer);
            context.write(entry.getValue(), buffer);
        }
    }
}

