/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceVertex;

public class VertexSerializer
extends SimpleTypeSerializer<Vertex> {
    public VertexSerializer() {
        super(DataType.VERTEX);
    }

    @Override
    protected Vertex readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        Object id = context.read(buffer);
        String label = (String)context.readValue(buffer, List.class, false).get(0);
        List properties = (List)context.read(buffer);
        DetachedVertex.Builder builder = DetachedVertex.build().setId(id).setLabel(label);
        if (properties != null) {
            for (DetachedVertexProperty vp : properties) {
                builder.addProperty(vp);
            }
        }
        return builder.create();
    }

    @Override
    protected void writeValue(Vertex value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        context.write(value.id(), buffer);
        if (value.label() == null) {
            throw new IOException("Unexpected null value when nullable is false");
        }
        context.writeValue(Collections.singletonList(value.label()), buffer, false);
        if (value instanceof ReferenceVertex) {
            context.write(null, buffer);
        } else {
            List asList = IteratorUtils.toList(value.properties(new String[0]));
            context.write(asList, buffer);
        }
    }
}

