/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.EnumSet;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.util.message.RequestMessage;
import org.apache.tinkerpop.gremlin.util.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.util.ser.SerializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface MessageSerializer<M> {
    public static final Logger logger = LoggerFactory.getLogger(MessageSerializer.class);

    public M getMapper();

    public ByteBuf serializeResponseAsBinary(ResponseMessage var1, ByteBufAllocator var2) throws SerializationException;

    public ByteBuf serializeRequestAsBinary(RequestMessage var1, ByteBufAllocator var2) throws SerializationException;

    public RequestMessage deserializeBinaryRequest(ByteBuf var1) throws SerializationException;

    public ResponseMessage deserializeBinaryResponse(ByteBuf var1) throws SerializationException;

    public String[] mimeTypesSupported();

    default public void configure(Map<String, Object> config, Map<String, Graph> graphs) {
    }

    public ByteBuf writeHeader(ResponseMessage var1, ByteBufAllocator var2) throws SerializationException;

    public ByteBuf writeChunk(Object var1, ByteBufAllocator var2) throws SerializationException;

    public ByteBuf writeFooter(ResponseMessage var1, ByteBufAllocator var2) throws SerializationException;

    public ByteBuf writeErrorFooter(ResponseMessage var1, ByteBufAllocator var2) throws SerializationException;

    public ResponseMessage readChunk(ByteBuf var1, boolean var2) throws SerializationException;

    public static enum MessageParts {
        HEADER,
        DATA,
        FOOTER;

        public static final EnumSet<MessageParts> ALL;
        public static final EnumSet<MessageParts> START;
        public static final EnumSet<MessageParts> CHUNK;
        public static final EnumSet<MessageParts> END;
        public static final EnumSet<MessageParts> ERROR;

        static {
            ALL = EnumSet.of(HEADER, DATA, FOOTER);
            START = EnumSet.of(HEADER, DATA);
            CHUNK = EnumSet.of(DATA);
            END = EnumSet.of(DATA, FOOTER);
            ERROR = EnumSet.of(FOOTER);
        }
    }
}

