/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import com.codahale.metrics.MetricRegistry;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.util.AttributeKey;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUserAgentHandler
extends ChannelInboundHandlerAdapter {
    private static final int MAX_USER_AGENT_METRICS = 10000;
    private static final Logger logger = LoggerFactory.getLogger(HttpUserAgentHandler.class);
    static final String USER_AGENT_HEADER_NAME = "User-Agent";
    public static final AttributeKey<String> USER_AGENT_ATTR_KEY = AttributeKey.valueOf((String)"User-Agent");

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof FullHttpMessage) {
            FullHttpMessage request = (FullHttpMessage)msg;
            if (request.headers().contains(USER_AGENT_HEADER_NAME)) {
                String userAgent = request.headers().get(USER_AGENT_HEADER_NAME);
                ctx.channel().attr(USER_AGENT_ATTR_KEY).set((Object)userAgent);
                logger.debug("New Connection on channel [{}] with user agent [{}]", (Object)ctx.channel().id().asShortText(), (Object)userAgent);
                String metricName = MetricRegistry.name(GremlinServer.class, (String[])new String[]{"user-agent", userAgent});
                if (MetricManager.INSTANCE.getCounterSize() > 10000 && !MetricManager.INSTANCE.contains(metricName)) {
                    metricName = MetricRegistry.name(GremlinServer.class, (String[])new String[]{"user-agent", "other"});
                }
                MetricManager.INSTANCE.getCounter(metricName).inc();
            } else {
                logger.debug("New Connection on channel [{}] with no user agent provided", (Object)ctx.channel().id().asShortText());
            }
        }
        ctx.fireChannelRead(msg);
    }
}

