/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.util;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Set;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParserException;
import org.apache.tinkerpop.gremlin.process.traversal.Failure;
import org.apache.tinkerpop.gremlin.util.ExceptionHelper;
import org.apache.tinkerpop.gremlin.util.message.RequestMessage;

public class GremlinError {
    private final HttpResponseStatus code;
    private final String message;
    private final String exception;

    private GremlinError(HttpResponseStatus code, String message, String exception) {
        this.code = code;
        this.message = message;
        this.exception = exception;
    }

    public HttpResponseStatus getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getException() {
        return this.exception;
    }

    public static GremlinError invalidGremlinType(RequestMessage requestMessage) {
        String message = String.format("Message could not be parsed. Check the format of the request. [%s]", requestMessage);
        return new GremlinError(HttpResponseStatus.BAD_REQUEST, message, "InvalidRequestException");
    }

    public static GremlinError binding() {
        String message = String.format("The message is using one or more invalid binding keys - they must be of type String and cannot be null", new Object[0]);
        return new GremlinError(HttpResponseStatus.BAD_REQUEST, message, "InvalidRequestException");
    }

    public static GremlinError binding(Set<String> badBindings) {
        String message = String.format("The message supplies one or more invalid parameters key of [%s] - these are reserved names.", badBindings);
        return new GremlinError(HttpResponseStatus.BAD_REQUEST, message, "InvalidRequestException");
    }

    public static GremlinError binding(int bindingsCount, int allowedSize) {
        String message = String.format("The message contains %s bindings which is more than is allowed by the server %s configuration", bindingsCount, allowedSize);
        return new GremlinError(HttpResponseStatus.BAD_REQUEST, message, "InvalidRequestException");
    }

    public static GremlinError binding(String aliased) {
        String message = String.format("Could not alias [%s] to [%s] as [%s] not in the Graph or TraversalSource global bindings", "g", aliased, aliased);
        return new GremlinError(HttpResponseStatus.BAD_REQUEST, message, "InvalidRequestException");
    }

    public static GremlinError parsing(GremlinParserException error) {
        return new GremlinError(HttpResponseStatus.BAD_REQUEST, error.getMessage(), "MalformedQueryException");
    }

    public static GremlinError timeout(RequestMessage requestMessage) {
        String message = String.format("A timeout occurred during traversal evaluation of [%s] - consider increasing the limit given to evaluationTimeout", requestMessage);
        return new GremlinError(HttpResponseStatus.INTERNAL_SERVER_ERROR, message, "ServerTimeoutExceededException");
    }

    public static GremlinError timedInterruptTimeout() {
        return new GremlinError(HttpResponseStatus.INTERNAL_SERVER_ERROR, "Timeout during script evaluation triggered by TimedInterruptCustomizerProvider", "ServerTimeoutExceededException");
    }

    public static GremlinError rateLimiting() {
        return new GremlinError(HttpResponseStatus.TOO_MANY_REQUESTS, "Too many requests have been sent in a given amount of time.", "TooManyRequestsException");
    }

    public static GremlinError serialization(Exception ex) {
        String message = String.format("Error during serialization: %s", ExceptionHelper.getMessageFromExceptionOrCause((Throwable)ex));
        return new GremlinError(HttpResponseStatus.INTERNAL_SERVER_ERROR, message, "ServerSerializationException");
    }

    public static GremlinError wrongSerializer(Exception ex) {
        String message = String.format("Error during serialization: %s", ExceptionHelper.getMessageFromExceptionOrCause((Throwable)ex));
        return new GremlinError(HttpResponseStatus.INTERNAL_SERVER_ERROR, message, "ServerSerializationException");
    }

    public static GremlinError longFrame(Throwable t) {
        String message = t.getMessage() + " - increase the maxRequestContentLength";
        return new GremlinError(HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, message, "RequestEntityTooLargeException");
    }

    public static GremlinError longRequest(RequestMessage requestMessage) {
        String message = String.format("The Gremlin statement that was submitted exceeds the maximum compilation size allowed by the JVM, please split it into multiple smaller statements - %s", requestMessage.trimMessage(1021));
        return new GremlinError(HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, message, "RequestEntityTooLargeException");
    }

    public static GremlinError temporary(Throwable t) {
        return new GremlinError(HttpResponseStatus.INTERNAL_SERVER_ERROR, t.getMessage(), "ServerEvaluationException");
    }

    public static GremlinError failStep(Failure failure) {
        return new GremlinError(HttpResponseStatus.INTERNAL_SERVER_ERROR, failure.getMessage(), "ServerFailStepException");
    }

    public static GremlinError general(Throwable t) {
        String message = t.getMessage() == null ? t.toString() : t.getMessage();
        return new GremlinError(HttpResponseStatus.INTERNAL_SERVER_ERROR, message, "ServerErrorException");
    }
}

