/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ide;

import org.apache.uima.caseditor.CasEditorPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class TypeSystemLocationPropertyPage
extends PropertyPage {
    public static final String TYPE_SYSTEM_PROPERTY = "UimaCasEditorTypeSystemPath";
    private static final String DEFAULT_TYPE_SYSTEM_PATH = "TypeSystem.xml";
    private Text typeSystemText;

    IProject getProject() {
        return (IProject)this.getElement().getAdapter(IProject.class);
    }

    String getDefaultTypeSystemLocation() {
        IProject project = this.getProject();
        if (project != null) {
            return project.getFile(DEFAULT_TYPE_SYSTEM_PATH).getFullPath().toString();
        }
        return "";
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        Label instructions = new Label(composite, 64);
        instructions.setText("Select the default type system which is used to open CASes:");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        instructions.setLayoutData((Object)gd);
        this.typeSystemText = new Text(composite, 2048);
        gd = new GridData(768);
        this.typeSystemText.setLayoutData((Object)gd);
        this.typeSystemText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                TypeSystemLocationPropertyPage.this.updateApplyButton();
            }
        });
        try {
            String typeSystemPath = ((IResource)this.getElement()).getPersistentProperty(new QualifiedName("", TYPE_SYSTEM_PROPERTY));
            this.typeSystemText.setText(typeSystemPath != null ? typeSystemPath : this.getDefaultTypeSystemLocation());
        }
        catch (CoreException e) {
            this.typeSystemText.setText(DEFAULT_TYPE_SYSTEM_PATH);
        }
        Button browseButton = new Button(composite, 8);
        browseButton.setText("Browse ...");
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IResource resource;
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(TypeSystemLocationPropertyPage.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle("Select descriptor");
                dialog.setMessage("Select descriptor");
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.setInitialSelection((Object)ResourcesPlugin.getWorkspace().getRoot().findMember(TypeSystemLocationPropertyPage.this.typeSystemText.getText()));
                if (dialog.open() == 0 && (resource = (IResource)dialog.getFirstResult()) != null) {
                    String fileLoc = resource.getFullPath().toString();
                    TypeSystemLocationPropertyPage.this.typeSystemText.setText(fileLoc);
                }
            }
        });
        return composite;
    }

    protected void performDefaults() {
        this.typeSystemText.setText(this.getDefaultTypeSystemLocation());
    }

    public boolean performOk() {
        try {
            ((IResource)this.getElement()).setPersistentProperty(new QualifiedName("", TYPE_SYSTEM_PROPERTY), this.typeSystemText.getText());
        }
        catch (CoreException e) {
            return false;
        }
        return true;
    }

    public static IFile getTypeSystemLocation(IProject project) {
        String typeSystemLocation;
        IFile defaultTypeSystemFile = project.getFile(DEFAULT_TYPE_SYSTEM_PATH);
        try {
            typeSystemLocation = project.getPersistentProperty(new QualifiedName("", TYPE_SYSTEM_PROPERTY));
        }
        catch (CoreException e) {
            typeSystemLocation = null;
        }
        IFile typeSystemFile = null;
        if (typeSystemLocation != null) {
            if (typeSystemLocation.length() > 0) {
                IResource potentialTypeSystemResource = ResourcesPlugin.getWorkspace().getRoot().findMember(typeSystemLocation);
                if (potentialTypeSystemResource instanceof IFile) {
                    typeSystemFile = (IFile)potentialTypeSystemResource;
                }
            } else {
                return null;
            }
        }
        if (typeSystemFile == null) {
            typeSystemFile = defaultTypeSystemFile;
        }
        return typeSystemFile;
    }

    public static void setTypeSystemLocation(IProject project, String typeSystemLocation) {
        try {
            project.setPersistentProperty(new QualifiedName("", TYPE_SYSTEM_PROPERTY), typeSystemLocation);
        }
        catch (CoreException e) {
            CasEditorPlugin.log((Throwable)e);
        }
    }
}

