/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaEnvironment;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.TerminalRutaCondition;
import org.apache.uima.ruta.expression.bool.BooleanExpression;
import org.apache.uima.ruta.expression.bool.SimpleBooleanExpression;
import org.apache.uima.ruta.expression.string.StringExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class RegExpCondition
extends TerminalRutaCondition {
    private final StringExpression pattern;
    private final BooleanExpression ignoreCase;
    private String variable;

    public RegExpCondition(StringExpression pattern, BooleanExpression ignoreCase) {
        this.pattern = pattern;
        this.ignoreCase = ignoreCase == null ? new SimpleBooleanExpression(false) : ignoreCase;
    }

    public RegExpCondition(String variable, StringExpression pattern, BooleanExpression ignoreCase) {
        this(pattern, ignoreCase);
        this.variable = variable;
    }

    public EvaluatedCondition eval(AnnotationFS annotation, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        Matcher matcher = null;
        boolean ignore = this.ignoreCase == null ? false : this.ignoreCase.getBooleanValue(element.getParent());
        String stringValue = this.pattern.getStringValue(element.getParent());
        if (this.variable == null) {
            String coveredText = annotation.getCoveredText();
            Pattern regularExpPattern = null;
            regularExpPattern = ignore ? Pattern.compile(stringValue, 2) : Pattern.compile(stringValue);
            matcher = regularExpPattern.matcher(coveredText);
        } else {
            RutaEnvironment environment = element.getParent().getEnvironment();
            String variableValue = environment.getVariableValue(this.variable, String.class);
            Pattern regularExpPattern = null;
            regularExpPattern = ignore ? Pattern.compile(stringValue, 2) : Pattern.compile(stringValue);
            matcher = regularExpPattern.matcher(variableValue);
        }
        boolean matches = matcher.matches();
        return new EvaluatedCondition(this, matches);
    }

    public StringExpression getPattern() {
        return this.pattern;
    }

    public String getVariable() {
        return this.variable;
    }

    public BooleanExpression getIgnoreCase() {
        return this.ignoreCase;
    }
}

