/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.expression.list.ListExpression;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.number.SimpleNumberExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SizeCondition
extends AbstractRutaCondition {
    private ListExpression<?> listExpr;
    private NumberExpression minExpr;
    private NumberExpression maxExpr;
    private String varExpr;

    public SizeCondition(ListExpression<?> list, NumberExpression min, NumberExpression max, String string) {
        this.listExpr = list;
        this.minExpr = min == null ? new SimpleNumberExpression(Integer.MIN_VALUE) : min;
        this.maxExpr = max == null ? new SimpleNumberExpression(Integer.MAX_VALUE) : max;
        this.varExpr = string;
    }

    @Override
    public EvaluatedCondition eval(AnnotationFS annotation, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        boolean value;
        int count = this.listExpr.getList(element.getParent()).size();
        boolean bl = value = count >= this.minExpr.getIntegerValue(element.getParent()) && count <= this.maxExpr.getIntegerValue(element.getParent());
        if (this.varExpr != null) {
            element.getParent().getEnvironment().setVariableValue(this.varExpr, count);
        }
        return new EvaluatedCondition(this, value);
    }

    public ListExpression<?> getListExpr() {
        return this.listExpr;
    }

    public NumberExpression getMinExpr() {
        return this.minExpr;
    }

    public NumberExpression getMaxExpr() {
        return this.maxExpr;
    }

    public String getVarExpr() {
        return this.varExpr;
    }
}

