/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.seed;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.ruta.seed.RutaAnnotationSeeder;
import org.apache.uima.ruta.seed.SeedLexer;
import org.apache.uima.ruta.type.MARKUP;
import org.apache.uima.ruta.type.TokenSeed;

public class DefaultSeeder
implements RutaAnnotationSeeder {
    public static final String seedType = "org.apache.uima.ruta.type.TokenSeed";
    private final Pattern markupPattern = Pattern.compile("</?\\w+((\\s+\\w+(\\s*=\\s*(?:\".*?\"|'.*?'|[^'\">\\s]+))?)+\\s*|\\s*)/?>");

    public Type seed(String text, CAS cas) {
        Type result = null;
        JCas jCas = null;
        int size = 0;
        try {
            jCas = cas.getJCas();
            size = jCas.getAnnotationIndex(TokenSeed.type).size();
            result = jCas.getTypeSystem().getType(seedType);
        }
        catch (CASException e1) {
            // empty catch block
        }
        if (jCas == null || size != 0 || text == null) {
            return result;
        }
        BufferedReader reader = new BufferedReader(new StringReader(text));
        SeedLexer sourceLexer = new SeedLexer(reader);
        sourceLexer.setJCas(jCas);
        AnnotationFS a = null;
        try {
            a = sourceLexer.yylex();
        }
        catch (Exception e) {
            // empty catch block
        }
        while (a != null) {
            cas.addFsToIndexes((FeatureStructure)a);
            try {
                a = sourceLexer.yylex();
            }
            catch (Exception e) {}
        }
        Matcher matcher = this.markupPattern.matcher(text);
        LinkedList<AnnotationFS> toRemove = new LinkedList<AnnotationFS>();
        while (matcher.find()) {
            int begin = matcher.start();
            int end = matcher.end();
            MARKUP markup = new MARKUP(jCas, begin, end);
            markup.addToIndexes();
            FSIterator subiterator = cas.getAnnotationIndex(result).subiterator((AnnotationFS)markup);
            while (subiterator.isValid()) {
                AnnotationFS fs = (AnnotationFS)subiterator.get();
                toRemove.add(fs);
                subiterator.moveToNext();
            }
        }
        for (AnnotationFS each : toRemove) {
            cas.removeFsFromIndexes((FeatureStructure)each);
        }
        return result;
    }
}

