/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.lp2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.textruler.core.TextRulerAnnotation;
import org.apache.uima.ruta.textruler.core.TextRulerExample;
import org.apache.uima.ruta.textruler.core.TextRulerRule;
import org.apache.uima.ruta.textruler.core.TextRulerRuleList;
import org.apache.uima.ruta.textruler.core.TextRulerStatisticsCollector;
import org.apache.uima.ruta.textruler.core.TextRulerTarget;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;
import org.apache.uima.ruta.textruler.extension.TextRulerLearner;
import org.apache.uima.ruta.textruler.extension.TextRulerLearnerDelegate;
import org.apache.uima.ruta.textruler.learner.lp2.BasicLP2;
import org.apache.uima.ruta.textruler.learner.lp2.LP2Rule;
import org.apache.uima.ruta.textruler.learner.lp2.LP2RuleItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimizedLP2
extends BasicLP2 {
    public static final boolean SAVE_DEBUG_INFO_IN_TEMPFOLDER = false;
    private Map<String, TextRulerStatisticsCollector> cachedTestedStartRuleStatistics = new HashMap<String, TextRulerStatisticsCollector>();
    private long cachedTestedStartRuleStatisticsHitCounter = 0L;

    public OptimizedLP2(String inputDir, String prePropTMFile, String tmpDir, String[] slotNames, Set<String> filterSet, TextRulerLearnerDelegate delegate) {
        super(inputDir, prePropTMFile, tmpDir, slotNames, filterSet, delegate);
    }

    @Override
    protected TextRulerRuleList learnTaggingRules(TextRulerTarget target, TextRulerRuleList contextualRules) {
        this.cachedTestedStartRuleStatisticsHitCounter = 0L;
        this.cachedTestedStartRuleStatistics.clear();
        TextRulerRuleList result = super.learnTaggingRules(target, contextualRules);
        TextRulerToolkit.log("[OptimizedLP2.learnTaggingRules] saved rule testings due to start rule results cache: " + this.cachedTestedStartRuleStatisticsHitCounter);
        TextRulerToolkit.log("[OptimizedLP2.learnTaggingRules] cacheSize at end of induction: " + this.cachedTestedStartRuleStatistics.size());
        this.cachedTestedStartRuleStatistics.clear();
        return result;
    }

    @Override
    protected void induceRulesFromExample(TextRulerExample e, int roundNumber) {
        List<LP2Rule> startRules = this.createStartRulesForExample(e);
        if (startRules.size() < 1) {
            return;
        }
        List<Object> ctxStartRules = new ArrayList();
        if (!e.getTarget().isLeftCorrection() && !e.getTarget().isRightCorrection()) {
            ctxStartRules = this.createContextStartRulesForStartRule(startRules.get(0));
        }
        ArrayList<LP2Rule> rulesToTest = new ArrayList<LP2Rule>(ctxStartRules.size() + startRules.size());
        rulesToTest.addAll(startRules);
        rulesToTest.addAll(ctxStartRules);
        this.sendStatusUpdateToDelegate("Round " + roundNumber + " - Testing " + rulesToTest.size() + " start rules... " + " - uncovered examples: " + (this.examples.size() - this.coveredExamples.size()) + " / " + this.examples.size() + " cs: " + this.cachedTestedStartRuleStatistics.size(), TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
        this.testStartRulesIfNotCached(rulesToTest);
        if (this.shouldAbort()) {
            return;
        }
        Comparator<LP2Rule> cmp = new Comparator<LP2Rule>(){

            @Override
            public int compare(LP2Rule o1, LP2Rule o2) {
                return o1.getCoveringStatistics().getCoveredPositivesCount() - o2.getCoveringStatistics().getCoveredPositivesCount();
            }
        };
        Collections.sort(startRules, cmp);
        Collections.sort(ctxStartRules, cmp);
        while (startRules.size() > 0 && startRules.get(0).getCoveringStatistics().getCoveredPositivesCount() < this.minCoveredPositives) {
            startRules.remove(0);
        }
        while (ctxStartRules.size() > 0 && ((LP2Rule)ctxStartRules.get(0)).getCoveringStatistics().getCoveredPositivesCount() < this.minCoveredPositives) {
            ctxStartRules.remove(0);
        }
        this.sendStatusUpdateToDelegate("Round " + roundNumber + " - Creating all generalizations..." + "     - uncovered examples: " + (this.examples.size() - this.coveredExamples.size()) + " / " + this.examples.size(), TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
        List<LP2Rule> debugRuleCollector = null;
        if (!this.recursiveCreateAllRuleCombinations(startRules, ctxStartRules, 0, new ArrayList<LP2Rule>(), null, debugRuleCollector)) {
            return;
        }
    }

    protected void testStartRulesIfNotCached(List<LP2Rule> startRules) {
        String key;
        ArrayList<LP2Rule> rulesToTest = new ArrayList<LP2Rule>();
        for (LP2Rule lP2Rule : startRules) {
            key = lP2Rule.getRuleString();
            if (this.cachedTestedStartRuleStatistics.containsKey(key)) {
                lP2Rule.setCoveringStatistics(this.cachedTestedStartRuleStatistics.get(key).copy());
                ++this.cachedTestedStartRuleStatisticsHitCounter;
                continue;
            }
            rulesToTest.add(lP2Rule);
        }
        if (rulesToTest.size() > 0) {
            this.testRulesOnDocumentSet(rulesToTest, this.exampleDocuments);
            if (this.shouldAbort()) {
                return;
            }
            for (TextRulerRule textRulerRule : rulesToTest) {
                key = textRulerRule.getRuleString();
                this.cachedTestedStartRuleStatistics.put(key, textRulerRule.getCoveringStatistics().copy());
            }
        }
    }

    protected LP2Rule combineRulesToOneRule(List<LP2Rule> ruleList, TextRulerStatisticsCollector covering) {
        LP2RuleItem rItem;
        LP2RuleItem newItem;
        int i;
        LP2Rule rule = new LP2Rule(this, ruleList.get(0).getTarget());
        int maxPreCount = 0;
        int maxPostCount = 0;
        for (LP2Rule r : ruleList) {
            if (r.getPreFillerPattern().size() > maxPreCount) {
                maxPreCount = r.getPreFillerPattern().size();
            }
            if (r.getPostFillerPattern().size() <= maxPostCount) continue;
            maxPostCount = r.getPostFillerPattern().size();
        }
        for (i = 0; i < maxPreCount; ++i) {
            newItem = new LP2RuleItem();
            for (LP2Rule r : ruleList) {
                if (i >= r.getPreFillerPattern().size()) continue;
                rItem = (LP2RuleItem)r.getPreFillerPattern().get(r.getPreFillerPattern().size() - i - 1);
                if (rItem.getWordConstraint() != null) {
                    newItem.setWordConstraint(rItem.getWordConstraint().copy());
                }
                if (rItem.getContextConstraint() != null) {
                    newItem.setContextConstraint(rItem.getContextConstraint().copy());
                }
                for (LP2RuleItem.MLLP2OtherConstraint c : rItem.getOtherConstraints()) {
                    newItem.addOtherConstraint(c.copy());
                }
            }
            rule.addPreFillerItem(newItem);
        }
        for (i = 0; i < maxPostCount; ++i) {
            newItem = new LP2RuleItem();
            for (LP2Rule r : ruleList) {
                if (i >= r.getPostFillerPattern().size()) continue;
                rItem = (LP2RuleItem)r.getPostFillerPattern().get(i);
                if (rItem.getWordConstraint() != null) {
                    newItem.setWordConstraint(rItem.getWordConstraint().copy());
                }
                if (rItem.getContextConstraint() != null) {
                    newItem.setContextConstraint(rItem.getContextConstraint().copy());
                }
                for (LP2RuleItem.MLLP2OtherConstraint c : rItem.getOtherConstraints()) {
                    newItem.addOtherConstraint(c.copy());
                }
            }
            rule.addPostFillerItem(newItem);
        }
        rule.setCoveringStatistics(covering.copy());
        return rule;
    }

    protected boolean recursiveCreateAllRuleCombinations(List<LP2Rule> startRules, List<LP2Rule> ctxStartRules, int index, List<LP2Rule> currentRuleTuple, TextRulerStatisticsCollector currentCovering, List<LP2Rule> debugRuleCollector) {
        if (index > startRules.size() - 1) {
            if (this.shouldAbort()) {
                return false;
            }
            if (currentRuleTuple.size() > 0) {
                LP2Rule newRule = this.createAndCheckRuleFromStartRules(currentRuleTuple, currentCovering, ctxStartRules);
                if (debugRuleCollector != null) {
                    debugRuleCollector.add(newRule);
                }
            }
        } else {
            TextRulerStatisticsCollector newCovering;
            if (!this.recursiveCreateAllRuleCombinations(startRules, ctxStartRules, index + 1, currentRuleTuple, currentCovering, debugRuleCollector)) {
                return false;
            }
            LP2Rule candidateRule = startRules.get(index);
            boolean isPre = candidateRule.isPreFillerStartRule();
            boolean containsWordConstraint = false;
            for (LP2Rule r : currentRuleTuple) {
                if (r.isPreFillerStartRule() != isPre) continue;
                if (isPre) {
                    containsWordConstraint = r.getPreFillerPattern().size() == candidateRule.getPreFillerPattern().size();
                } else {
                    boolean bl = containsWordConstraint = r.getPostFillerPattern().size() == candidateRule.getPostFillerPattern().size();
                }
                if (!containsWordConstraint) continue;
                break;
            }
            if (!containsWordConstraint && (newCovering = currentCovering != null ? this.getCoveringIntersection(currentCovering, candidateRule.getCoveringStatistics()) : candidateRule.getCoveringStatistics()).getCoveredPositivesCount() >= this.minCoveredPositives) {
                currentRuleTuple.add(candidateRule);
                if (!this.recursiveCreateAllRuleCombinations(startRules, ctxStartRules, index + 1, currentRuleTuple, newCovering, debugRuleCollector)) {
                    return false;
                }
                currentRuleTuple.remove(currentRuleTuple.size() - 1);
            }
        }
        return true;
    }

    protected TextRulerStatisticsCollector getCoveringIntersection(TextRulerStatisticsCollector c1, TextRulerStatisticsCollector c2) {
        TextRulerStatisticsCollector resultC = new TextRulerStatisticsCollector(c1);
        resultC.getCoveredPositiveExamples().retainAll(c2.getCoveredPositiveExamples());
        resultC.getCoveredNegativeExamples().retainAll(c2.getCoveredNegativeExamples());
        resultC.reflectCountsFromCoveredExamples();
        return resultC;
    }

    protected LP2Rule createAndCheckRuleFromStartRules(List<LP2Rule> startRules, TextRulerStatisticsCollector covering, List<LP2Rule> ctxStartRules) {
        boolean isBestRule;
        LP2Rule newRule = this.combineRulesToOneRule(startRules, covering);
        boolean tooFewPositives = newRule.getCoveringStatistics().getCoveredPositivesCount() < this.minCoveredPositives;
        boolean tooManyErrors = newRule.getErrorRate() > this.maxErrorThreshold;
        boolean bl = isBestRule = !tooFewPositives && !tooManyErrors;
        if (isBestRule) {
            this.currentBestRules.add(newRule);
            this.currentBestRules.removeSubsumedRules();
            this.currentBestRules.cutToMaxSize();
        } else if (!tooFewPositives && ctxStartRules.size() > 0) {
            for (LP2Rule ctxStartRule : ctxStartRules) {
                LP2RuleItem.MLLP2ContextConstraint ctxConstraint = ctxStartRule.getMarkingRuleItem().getContextConstraint();
                LP2Rule newCTXRule = newRule.copy();
                newCTXRule.setIsContextualRule(true);
                newCTXRule.getMarkingRuleItem().setContextConstraint(ctxConstraint.copy());
                newCTXRule.setNeedsCompile(true);
                newCTXRule.compileRuleString();
                newCTXRule.setCoveringStatistics(this.getCoveringIntersection(newRule.getCoveringStatistics(), ctxStartRule.getCoveringStatistics()));
                boolean ctxTooFewPositives = newCTXRule.getCoveringStatistics().getCoveredPositivesCount() < this.minCoveredPositives;
                boolean ctxTooManyErrors = newCTXRule.getErrorRate() > this.maxErrorThreshold;
                boolean isGoodCTXRule = !ctxTooFewPositives && !ctxTooManyErrors;
                if (!isGoodCTXRule) continue;
                this.currentContextualRules.add(newCTXRule);
                this.currentContextualRules.removeSubsumedRules();
                this.currentContextualRules.cutToMaxSize();
            }
        }
        return newRule;
    }

    protected LP2Rule createStartRuleForConstraint(TextRulerTarget target, int contextSize, boolean isLeftContext, LP2RuleItem constraintItem) {
        LP2Rule newRule = new LP2Rule(this, target);
        for (int j = 0; j < contextSize - 1; ++j) {
            if (isLeftContext) {
                newRule.addPreFillerItem(new LP2RuleItem());
                continue;
            }
            newRule.addPostFillerItem(new LP2RuleItem());
        }
        if (isLeftContext) {
            newRule.addPreFillerItem(constraintItem);
        } else {
            newRule.addPostFillerItem(constraintItem);
        }
        if (isLeftContext && (target.type == TextRulerTarget.MLTargetType.SINGLE_LEFT_BOUNDARY || target.type == TextRulerTarget.MLTargetType.SINGLE_LEFT_CORRECTION)) {
            newRule.addPostFillerItem(new LP2RuleItem());
        } else if (!(isLeftContext || target.type != TextRulerTarget.MLTargetType.SINGLE_RIGHT_BOUNDARY && target.type != TextRulerTarget.MLTargetType.SINGLE_RIGHT_CORRECTION)) {
            newRule.addPreFillerItem(new LP2RuleItem());
        }
        newRule.setIsPreFillerStartRule(isLeftContext);
        return newRule;
    }

    protected List<LP2Rule> createContextStartRulesForStartRule(LP2Rule aStartRule) {
        ArrayList<LP2Rule> result = new ArrayList<LP2Rule>();
        LP2RuleItem ctxItem = new LP2RuleItem();
        LP2RuleItem.MLLP2ContextConstraint ctxConstraint = new LP2RuleItem.MLLP2ContextConstraint((Integer)this.slotMaximumTokenCountMap.get(aStartRule.getTarget().getSingleSlotRawTypeName()), aStartRule);
        ctxItem.setContextConstraint(ctxConstraint);
        LP2Rule ctxStartRule = new LP2Rule(this, aStartRule.getTarget());
        ctxStartRule.setIsContextualRule(true);
        if (aStartRule.getTarget().type == TextRulerTarget.MLTargetType.SINGLE_LEFT_BOUNDARY) {
            ctxStartRule.addPostFillerItem(ctxItem);
        } else {
            ctxStartRule.addPreFillerItem(ctxItem);
        }
        result.add(ctxStartRule);
        return result;
    }

    protected List<LP2Rule> createStartRulesForExample(TextRulerExample example) {
        List<AnnotationFS> rightContext;
        TextRulerTarget target = example.getTarget();
        ArrayList<LP2Rule> result = new ArrayList<LP2Rule>();
        CAS docCas = example.getDocumentCAS();
        TextRulerAnnotation exampleAnnotation = example.getAnnotation();
        TypeSystem ts = docCas.getTypeSystem();
        Type tokensRootType = ts.getType("org.apache.uima.ruta.type.ANY");
        boolean isLeftBoundary = target.type == TextRulerTarget.MLTargetType.SINGLE_LEFT_BOUNDARY || target.type == TextRulerTarget.MLTargetType.SINGLE_LEFT_CORRECTION;
        int thePosition = isLeftBoundary ? exampleAnnotation.getBegin() : exampleAnnotation.getEnd();
        List<AnnotationFS> leftContext = TextRulerToolkit.getAnnotationsBeforePosition(docCas, thePosition, this.windowSize, TextRulerToolkit.getFilterSetWithSlotNames(this.slotNames, this.filterSet), tokensRootType);
        if (target.type == TextRulerTarget.MLTargetType.SINGLE_LEFT_CORRECTION || target.type == TextRulerTarget.MLTargetType.SINGLE_RIGHT_CORRECTION) {
            rightContext = TextRulerToolkit.getAnnotationsAfterPosition(docCas, thePosition, this.windowSize + 1, TextRulerToolkit.getFilterSetWithSlotNames(this.slotNames, this.filterSet), tokensRootType);
            rightContext.remove(0);
        } else {
            rightContext = TextRulerToolkit.getAnnotationsAfterPosition(docCas, thePosition, this.windowSize, TextRulerToolkit.getFilterSetWithSlotNames(this.slotNames, this.filterSet), tokensRootType);
        }
        int totalCount = leftContext.size() + rightContext.size();
        for (int index = 0; index < totalCount; ++index) {
            boolean isPre = index < leftContext.size();
            int prePostIndex = isPre ? index : index - leftContext.size();
            AnnotationFS tokenAFS = isPre ? leftContext.get(leftContext.size() - 1 - prePostIndex) : rightContext.get(prePostIndex);
            TextRulerAnnotation tokenAnnotation = new TextRulerAnnotation(tokenAFS, example.getDocument());
            LP2RuleItem wordItem = new LP2RuleItem();
            wordItem.setWordConstraint(tokenAnnotation);
            result.add(this.createStartRuleForConstraint(example.getTarget(), prePostIndex + 1, isPre, wordItem));
            if (wordItem.getWordConstraint().isRegExpConstraint()) {
                LP2RuleItem basicItem = new LP2RuleItem();
                basicItem.addOtherConstraint(new LP2RuleItem.MLLP2OtherConstraint(tokenAnnotation, tokenAnnotation));
                result.add(this.createStartRuleForConstraint(example.getTarget(), prePostIndex + 1, isPre, basicItem));
            }
            List<AnnotationFS> featureAnnotations = TextRulerToolkit.getNonTMAnnoationsOverToken(docCas, tokenAFS, this.filterSetWithSlotNames);
            for (AnnotationFS featA : featureAnnotations) {
                TextRulerAnnotation featureAnnot = new TextRulerAnnotation(featA, example.getDocument());
                LP2RuleItem basicItem = new LP2RuleItem();
                basicItem.addOtherConstraint(new LP2RuleItem.MLLP2OtherConstraint(tokenAnnotation, featureAnnot));
                result.add(this.createStartRuleForConstraint(example.getTarget(), prePostIndex + 1, isPre, basicItem));
            }
        }
        return result;
    }

    @Override
    public boolean collectNegativeCoveredInstancesWhenTesting() {
        return true;
    }
}

