/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
*/

package org.apache.uima.ruta.testing.ui.views.evalDataTable;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class EvalTableLabelProvider implements ITableLabelProvider {

  public Image getColumnImage(Object element, int columnIndex) {
    // TODO Auto-generated method stub
    return null;
  }

  public String getColumnText(Object element, int columnIndex) {
    TypeEvalData entry = (TypeEvalData) element;
    
    switch(columnIndex) {
    
      case 0:
        return entry.getTypeName();
      case 1:
        return String.valueOf(entry.getTruePositives());
      case 2:
        return String.valueOf(entry.getFalsePositives());
      case 3:
        return String.valueOf(entry.getFalseNegatives());
      case 4:
        return String.valueOf(entry.getPrecision());
      case 5:
        return String.valueOf(entry.getRecall());
      case 6:
        return String.valueOf(entry.getFOne());
    }
     
    
    
    return null;
  }

  public void addListener(ILabelProviderListener listener) {
    // TODO Auto-generated method stub

  }

  public void dispose() {
    // TODO Auto-generated method stub

  }

  public boolean isLabelProperty(Object element, String property) {
    // TODO Auto-generated method stub
    return false;
  }

  public void removeListener(ILabelProviderListener listener) {
    // TODO Auto-generated method stub

  }

}
