/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression.feature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.expression.ExpressionFactory;
import org.apache.uima.ruta.expression.annotation.IAnnotationExpression;
import org.apache.uima.ruta.expression.annotation.IAnnotationListExpression;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.bool.IBooleanListExpression;
import org.apache.uima.ruta.expression.feature.FeatureExpression;
import org.apache.uima.ruta.expression.list.ListExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.number.INumberListExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.expression.string.IStringListExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.MatchContext;

public class GenericFeatureExpression
extends ListExpression<Object>
implements INumberExpression,
IBooleanExpression,
IStringExpression,
IAnnotationExpression,
IAnnotationListExpression,
IBooleanListExpression,
INumberListExpression,
IStringListExpression,
ITypeExpression {
    private FeatureExpression featureExpression;
    private ITypeExpression typeExpression;
    private INumberExpression numberExpression;
    private IStringExpression stringExpression;
    private IBooleanExpression booleanExpression;
    private IAnnotationExpression annotationExpression;
    private INumberListExpression numberListExpression;
    private IStringListExpression stringListExpression;
    private IBooleanListExpression booleanListExpression;
    private IAnnotationListExpression annotationListExpression;
    private ExpressionFactory expressionFactory;

    public GenericFeatureExpression(FeatureExpression fe) {
        this.featureExpression = fe;
        this.expressionFactory = new ExpressionFactory();
    }

    @Override
    public String getStringValue(MatchContext context, RutaStream stream) {
        if (this.stringExpression == null) {
            this.stringExpression = this.expressionFactory.createStringFeatureExpression(this.featureExpression);
        }
        return this.stringExpression.getStringValue(context, stream);
    }

    @Override
    public boolean getBooleanValue(MatchContext context, RutaStream stream) {
        if (this.booleanExpression == null) {
            this.booleanExpression = this.expressionFactory.createBooleanFeatureExpression(this.featureExpression);
        }
        return this.booleanExpression.getBooleanValue(context, stream);
    }

    @Override
    public int getIntegerValue(MatchContext context, RutaStream stream) {
        if (this.numberExpression == null) {
            this.numberExpression = this.expressionFactory.createNumberFeatureExpression(this.featureExpression);
        }
        return this.numberExpression.getIntegerValue(context, stream);
    }

    @Override
    public double getDoubleValue(MatchContext context, RutaStream stream) {
        if (this.numberExpression == null) {
            this.numberExpression = this.expressionFactory.createNumberFeatureExpression(this.featureExpression);
        }
        return this.numberExpression.getDoubleValue(context, stream);
    }

    @Override
    public float getFloatValue(MatchContext context, RutaStream stream) {
        if (this.numberExpression == null) {
            this.numberExpression = this.expressionFactory.createNumberFeatureExpression(this.featureExpression);
        }
        return this.numberExpression.getFloatValue(context, stream);
    }

    @Override
    public AnnotationFS getAnnotation(MatchContext context, RutaStream stream) {
        if (this.annotationExpression == null) {
            this.annotationExpression = this.expressionFactory.createAnnotationFeatureExpression(this.featureExpression);
        }
        return this.annotationExpression.getAnnotation(context, stream);
    }

    @Override
    public FeatureStructure getFeatureStructure(MatchContext context, RutaStream stream) {
        if (this.annotationExpression == null) {
            this.annotationExpression = this.expressionFactory.createAnnotationFeatureExpression(this.featureExpression);
        }
        return this.annotationExpression.getFeatureStructure(context, stream);
    }

    @Override
    public Type getType(MatchContext context, RutaStream stream) {
        if (this.typeExpression == null) {
            this.typeExpression = this.expressionFactory.createTypeFeatureExpression(this.featureExpression);
        }
        if (this.typeExpression != null) {
            return this.typeExpression.getType(context, stream);
        }
        return this.featureExpression.getInitialType(context, stream);
    }

    public FeatureExpression getFeatureExpression() {
        return this.featureExpression;
    }

    public void setFeatureExpression(FeatureExpression featureExpression) {
        this.featureExpression = featureExpression;
    }

    @Override
    public List<String> getStringList(MatchContext context, RutaStream stream) {
        if (this.stringListExpression == null) {
            this.stringListExpression = this.expressionFactory.createStringListFeatureExpression(this.featureExpression);
        }
        return this.stringListExpression.getStringList(context, stream);
    }

    @Override
    public List<Number> getNumberList(MatchContext context, RutaStream stream) {
        if (this.numberListExpression == null) {
            this.numberListExpression = this.expressionFactory.createNumberListFeatureExpression(this.featureExpression);
        }
        return this.numberListExpression.getNumberList(context, stream);
    }

    @Override
    public List<Boolean> getBooleanList(MatchContext context, RutaStream stream) {
        if (this.booleanListExpression == null) {
            this.booleanListExpression = this.expressionFactory.createBooleanListFeatureExpression(this.featureExpression);
        }
        return this.booleanListExpression.getBooleanList(context, stream);
    }

    @Override
    public List<AnnotationFS> getAnnotationList(MatchContext context, RutaStream stream) {
        if (this.annotationListExpression == null) {
            this.annotationListExpression = this.expressionFactory.createAnnotationListFeatureExpression(this.featureExpression);
        }
        return this.annotationListExpression.getAnnotationList(context, stream);
    }

    @Override
    public List<Object> getList(MatchContext context, RutaStream stream) {
        Feature feature = this.featureExpression.getFeature(context, stream);
        Type range = feature.getRange();
        if (!range.isArray()) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        if (StringUtils.equals((CharSequence)range.getName(), (CharSequence)"uima.cas.FSArray")) {
            result.addAll(this.getAnnotationList(context, stream));
        } else if (StringUtils.equals((CharSequence)range.getName(), (CharSequence)"uima.cas.BooleanArray")) {
            result.addAll(this.getBooleanList(context, stream));
        } else if (StringUtils.equals((CharSequence)range.getName(), (CharSequence)"uima.cas.StringArray")) {
            result.addAll(this.getStringList(context, stream));
        } else if (StringUtils.equals((CharSequence)range.getName(), (CharSequence)"uima.cas.IntegerArray") || StringUtils.equals((CharSequence)range.getName(), (CharSequence)"uima.cas.DoubleArray") || StringUtils.equals((CharSequence)range.getName(), (CharSequence)"uima.cas.FloatArray")) {
            result.addAll(this.getNumberList(context, stream));
        }
        return result;
    }
}

