/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.jms.activemq;

import java.lang.reflect.Method;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.InputChannel;
import org.apache.uima.aae.UimaAsPriorityBasedThreadFactory;
import org.apache.uima.aae.UimaAsThreadFactory;
import org.apache.uima.aae.controller.AggregateAnalysisEngineController;
import org.apache.uima.aae.controller.AnalysisEngineController;
import org.apache.uima.aae.controller.BaseAnalysisEngineController;
import org.apache.uima.aae.controller.Endpoint;
import org.apache.uima.aae.controller.PrimitiveAnalysisEngineController;
import org.apache.uima.aae.delegate.Delegate;
import org.apache.uima.aae.error.ErrorHandler;
import org.apache.uima.aae.error.Threshold;
import org.apache.uima.aae.error.handler.GetMetaErrorHandler;
import org.apache.uima.aae.message.MessageWrapper;
import org.apache.uima.adapter.jms.activemq.ConcurrentMessageListener;
import org.apache.uima.adapter.jms.activemq.ConnectionFactoryIniter;
import org.apache.uima.adapter.jms.activemq.JmsInputChannel;
import org.apache.uima.adapter.jms.activemq.ModifiableListener;
import org.apache.uima.adapter.jms.activemq.PriorityMessageHandler;
import org.apache.uima.adapter.jms.activemq.TempDestinationResolver;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.JmsException;
import org.springframework.jms.listener.AbstractJmsListeningContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.listener.SessionAwareMessageListener;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class UimaDefaultMessageListenerContainer
extends DefaultMessageListenerContainer
implements ExceptionListener {
    private static final Class<?> CLASS_NAME = UimaDefaultMessageListenerContainer.class;
    public static final String PROCESS_SELECTOR_SUFFIX = "(Command=2000 OR Command=2002)";
    public static final String CM_PROCESS_SELECTOR_SUFFIX = "(Command=2000 OR Command=2002 OR Command=2005)";
    public static final String GETMETA_SELECTOR_SUFFIX = "(Command=2001)";
    public static final int HIGH_PRIORITY = 9;
    private String destinationName = "";
    private Endpoint endpoint;
    private volatile boolean freeCasQueueListener;
    private AnalysisEngineController controller;
    private volatile boolean failed = false;
    private Object mux = new Object();
    private final UimaDefaultMessageListenerContainer __listenerRef;
    private TaskExecutor taskExecutor = null;
    private ConnectionFactory connectionFactory = null;
    private Object mux2 = new Object();
    private ThreadGroup threadGroup = null;
    private ThreadFactory tf = null;
    private int cc = 0;
    private Object ml = null;
    private ConcurrentMessageListener concurrentListener = null;
    private volatile boolean awaitingShutdown = false;
    public static volatile boolean terminating;
    private ThreadPoolExecutor threadPoolExecutor = null;
    private boolean pluginThreadPool;
    private CountDownLatch latchToCountNumberOfTerminatedThreads;
    private volatile boolean logListenerFailure = true;
    private static CountDownLatch recoveryLatch;
    private boolean targetedListener = false;

    public UimaDefaultMessageListenerContainer() {
        terminating = false;
        UIMAFramework.getLogger(CLASS_NAME).setLevel(Level.WARNING);
        this.__listenerRef = this;
        this.setRecoveryInterval(400L);
        this.setAcceptMessagesWhileStopping(true);
        this.setExceptionListener(this);
        this.threadGroup = new ThreadGroup("ListenerThreadGroup_" + Thread.currentThread().getThreadGroup().getName());
    }

    public UimaDefaultMessageListenerContainer(boolean freeCasQueueListener) {
        this();
        this.freeCasQueueListener = freeCasQueueListener;
    }

    public void setTargetedListener() {
        this.targetedListener = true;
    }

    private static boolean connectionClosedOrFailed(ActiveMQConnection connection) {
        return connection == null || connection.isClosed() || connection.isClosing() || connection.isTransportFailed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshConnectionUntilSuccessful() {
        boolean doLogFailureMsg = true;
        try {
            Class<UimaDefaultMessageListenerContainer> clazz = UimaDefaultMessageListenerContainer.class;
            synchronized (UimaDefaultMessageListenerContainer.class) {
                ActiveMQConnection c = null;
                try {
                    c = (ActiveMQConnection)super.getSharedConnection();
                }
                catch (AbstractJmsListeningContainer.SharedConnectionNotInitializedException sharedConnectionNotInitializedException) {
                    // empty catch block
                }
                if (!UimaDefaultMessageListenerContainer.connectionClosedOrFailed(c)) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                while (this.isRunning() && !terminating) {
                    Connection tcon = null;
                    try {
                        if (this.sharedConnectionEnabled()) {
                            this.refreshSharedConnection();
                        } else {
                            tcon = this.createConnection();
                            JmsUtils.closeConnection((Connection)tcon);
                        }
                        String ctrlName = "";
                        if (this.controller != null) {
                            ctrlName = "Controller: " + this.controller.getComponentName();
                        }
                        if (super.getMessageSelector() != null) {
                            this.logger.info((Object)(ctrlName + " Successfully refreshed JMS Connection - Selector " + super.getMessageSelector() + " Instance hashcode:" + ((Object)((Object)this)).hashCode()));
                        } else {
                            this.logger.info((Object)(ctrlName + " Successfully refreshed JMS Connection "));
                        }
                        if (this.getDestination() == null || !((ActiveMQDestination)this.getDestination()).isTemporary()) break;
                        this.destroy();
                        this.logger.info((Object)("Controller:" + this.controller.getComponentName() + "... Destroyed Listener on a temp queue:" + this.getDestination()));
                        if (!this.freeCasQueueListener) break;
                        this.logger.info((Object)("Controller:" + this.controller.getComponentName() + " ------------------- Creating new listener for the FreeCas temp queue"));
                        try {
                            ((JmsInputChannel)this.getMessageListener()).createListenerOnTempQueue(this.getConnectionFactory(), true);
                            this.logger.info((Object)("Controller:" + this.controller.getComponentName() + "------------------- New listener on FreeCas temp queue is ready"));
                        }
                        catch (Exception e) {
                            if (!UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) break;
                            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleTempQueueFailure", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
                        }
                        break;
                    }
                    catch (Exception ex) {
                        if (tcon != null) {
                            try {
                                tcon.close();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        if (!doLogFailureMsg) continue;
                        StringBuilder msg = new StringBuilder();
                        msg.append("Could not refresh JMS Connection for destination '");
                        msg.append(this.getDestinationDescription()).append("' - silently retrying in ");
                        msg.append(5).append(" ms. Cause: ");
                        msg.append(ex instanceof JMSException ? JmsUtils.buildExceptionMessage((JMSException)((JMSException)((Object)ex))) : ex.getMessage());
                        this.logger.warn((Object)msg);
                        doLogFailureMsg = false;
                    }
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        {
            return;
        }
    }

    protected void recoverAfterListenerSetupFailure() {
        if (!terminating) {
            super.recoverAfterListenerSetupFailure();
        }
    }

    public void setTerminating() {
        terminating = true;
    }

    public void setController(AnalysisEngineController aController) {
        this.controller = aController;
    }

    private boolean disableListener(Throwable t) {
        return t.toString().indexOf("SharedConnectionNotInitializedException") > 0 || t instanceof JMSException && t.getCause() != null && t.getCause() instanceof ConnectException;
    }

    private void handleListenerFailure() {
        block8: {
            if (this.awaitingShutdown) {
                return;
            }
            try {
                if (this.controller instanceof AggregateAnalysisEngineController) {
                    String delegateKey = ((AggregateAnalysisEngineController)this.controller).lookUpDelegateKey(this.endpoint.getEndpoint());
                    InputChannel iC = null;
                    String queueName = null;
                    queueName = this.endpoint.getDestination() != null ? this.endpoint.getDestination().toString() : this.endpoint.getEndpoint();
                    iC = ((AggregateAnalysisEngineController)this.controller).getInputChannel(queueName);
                    if (iC != null) {
                        iC.destroyListener(queueName, delegateKey);
                    } else if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.INFO)) {
                        UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "handleListenerFailure", "uimaee_messages", "UIMAJMS_unable_to_lookup_input_channel__INFO", (Object)queueName);
                    }
                }
            }
            catch (Exception e) {
                if (!UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) break block8;
                if (this.controller != null) {
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleListenerFailure", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.controller.getComponentName());
                }
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleListenerFailure", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
            }
        }
    }

    private void handleTempQueueFailure(Throwable t) {
        if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) {
            if (this.controller != null) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleTempQueueFailure", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.controller.getComponentName());
            }
            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, ((Object)((Object)this)).getClass().getName(), "handleTempQueueFailure", "jms_adapter_messages", "UIMAJMS_jms_listener_failed_WARNING", new Object[]{this.getDestination(), this.getBrokerUrl(), t});
        }
        ActiveMQConnection conn = null;
        try {
            conn = (ActiveMQConnection)this.getSharedConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (t instanceof InvalidDestinationException) {
            this.destroy();
            if (this.getMessageListener() instanceof JmsInputChannel) {
                // empty if block
            }
            return;
        }
        if (conn != null && conn.isTransportFailed() || t instanceof javax.jms.IllegalStateException && t.getMessage().equals("The Consumer is closed")) {
            if (this.controller != null && this.controller instanceof AggregateAnalysisEngineController) {
                if (this.endpoint == null) {
                    this.destroy();
                    return;
                }
                String delegateKey = ((AggregateAnalysisEngineController)this.controller).lookUpDelegateKey(this.endpoint.getEndpoint());
                try {
                    if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.INFO)) {
                        UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, ((Object)((Object)this)).getClass().getName(), "handleTempQueueFailure", "jms_adapter_messages", "UIMAJMS_stopping_listener_INFO", new Object[]{this.controller.getComponentName(), this.endpoint.getDestination(), delegateKey});
                    }
                    this.handleListenerFailure();
                    if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.INFO) && this.controller != null) {
                        UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, ((Object)((Object)this)).getClass().getName(), "handleTempQueueFailure", "jms_adapter_messages", "UIMAJMS_stopped_listener_INFO", new Object[]{this.controller.getComponentName(), this.endpoint.getDestination()});
                    }
                }
                catch (Exception e) {
                    if (this.controller != null) {
                        UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleTempQueueFailure", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.controller.getComponentName());
                    }
                    if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) {
                        UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleTempQueueFailure", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
                    }
                }
            }
        } else if (this.disableListener(t)) {
            this.handleQueueFailure(t);
        }
    }

    private ErrorHandler fetchGetMetaErrorHandler() {
        ErrorHandler handler2 = null;
        for (ErrorHandler handler2 : this.controller.getErrorHandlerChain()) {
            if (!(handler2 instanceof GetMetaErrorHandler)) continue;
            return handler2;
        }
        return null;
    }

    private void handleQueueFailure(Throwable t) {
        String endpointName;
        String string = endpointName = this.getDestination() == null ? "" : ((ActiveMQDestination)this.getDestination()).getPhysicalName();
        if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) {
            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, ((Object)((Object)this)).getClass().getName(), "handleQueueFailure", "jms_adapter_messages", "UIMAJMS_jms_listener_failed_WARNING", new Object[]{endpointName, this.getBrokerUrl(), t});
        }
        boolean terminate = true;
        if (this.disableListener(t)) {
            this.endpoint.setReplyDestinationFailed();
            if (this.controller != null && this.controller instanceof AggregateAnalysisEngineController) {
                Threshold threshold;
                ErrorHandler handler = this.fetchGetMetaErrorHandler();
                Map thresholds = handler.getEndpointThresholdMap();
                String delegateKey = ((AggregateAnalysisEngineController)this.controller).lookUpDelegateKey(this.endpoint.getEndpoint());
                if (delegateKey != null && thresholds.containsKey(delegateKey) && (threshold = (Threshold)thresholds.get(delegateKey)).getAction().equalsIgnoreCase("Disable")) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(delegateKey);
                    try {
                        if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.INFO)) {
                            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, ((Object)((Object)this)).getClass().getName(), "handleQueueFailure", "uimaee_messages", "UIMAEE_disabled_delegate_bad_broker__INFO", new Object[]{this.controller.getComponentName(), delegateKey, this.getBrokerUrl()});
                        }
                        ((AggregateAnalysisEngineController)this.controller).disableDelegates(list);
                        terminate = false;
                    }
                    catch (Exception e) {
                        if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) {
                            if (this.controller != null) {
                                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleQueueFailure", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.controller.getComponentName());
                            }
                            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleQueueFailure", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
                        }
                        terminate = true;
                    }
                }
            }
        }
        if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) {
            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, ((Object)((Object)this)).getClass().getName(), "handleQueueFailure", "jms_adapter_messages", "UIMAJMS_closing_channel__WARNING", new Object[]{this.getBrokerUrl(), this.endpoint.getEndpoint()});
        }
        this.setRecoveryInterval(1L);
        new Thread(){

            @Override
            public void run() {
                block4: {
                    try {
                        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "handleQueueFailure.run", "jms_adapter_messages", "UIMAJMS_disable_listener__WARNING", new Object[]{endpointName, UimaDefaultMessageListenerContainer.this.getBrokerUrl()});
                        }
                        UimaDefaultMessageListenerContainer.this.shutdown();
                    }
                    catch (Exception e) {
                        if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block4;
                        if (UimaDefaultMessageListenerContainer.this.controller != null) {
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleQueueFailure.run", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)UimaDefaultMessageListenerContainer.this.controller.getComponentName());
                        }
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleQueueFailure.run", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
                    }
                }
            }
        }.start();
        if (terminate) {
            this.terminate(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleListenerSetupFailure(Throwable t, boolean alreadyHandled) {
        if (t.getCause() instanceof InterruptedException) {
            return;
        }
        if (this.awaitingShutdown || terminating || this.controller != null && this.controller.isStopped()) {
            return;
        }
        if (this.controller != null) {
            this.controller.changeState(BaseAnalysisEngineController.ServiceState.FAILED);
        }
        if (this.endpoint == null) {
            super.handleListenerSetupFailure(t, true);
            String controllerId = "";
            if (this.controller != null) {
                controllerId = "Uima AS Service:" + this.controller.getComponentName();
            }
            if (this.logListenerFailure) {
                this.logListenerFailure = false;
                if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) {
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, ((Object)((Object)this)).getClass().getName(), "handleListenerSetupFailure", "jms_adapter_messages", "UIMAJMS_listener_connection_failure__WARNING", new Object[]{controllerId, this.getBrokerUrl()});
                }
            }
            this.refreshConnectionUntilSuccessful();
            if (this.controller != null) {
                this.controller.changeState(BaseAnalysisEngineController.ServiceState.RUNNING);
            }
            this.logListenerFailure = true;
            if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, ((Object)((Object)this)).getClass().getName(), "handleListenerSetupFailure", "jms_adapter_messages", "UIMAJMS_listener_connection_recovered__WARNING", new Object[]{controllerId, this.getBrokerUrl()});
            }
            return;
        }
        if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) {
            if (this.controller != null) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleListenerSetupFailure", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.controller.getComponentName());
            }
            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleListenerSetupFailure", "jms_adapter_messages", "UIMAJMS_exception__WARNING", t);
        }
        Object object = this.mux;
        synchronized (object) {
            if (!this.failed) {
                if (this.endpoint.isTempReplyDestination()) {
                    this.handleTempQueueFailure(t);
                } else {
                    this.handleQueueFailure(t);
                }
            }
            this.failed = true;
        }
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    private void terminate(Throwable t) {
        if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) {
            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, ((Object)((Object)this)).getClass().getName(), "terminate", "jms_adapter_messages", "UIMAJMS_terminate_service_dueto_bad_broker__WARNING", new Object[]{this.controller.getComponentName(), this.getBrokerUrl()});
        }
        this.controller.notifyListenersWithInitializationStatus((Exception)((Object)new ResourceInitializationException(t)));
        if (!this.controller.isStopped() && !this.controller.isAwaitingCacheCallbackNotification()) {
            this.controller.stop();
        }
    }

    protected void handleListenerException(Throwable t) {
        if (this.awaitingShutdown) {
            return;
        }
        super.handleListenerException(t);
    }

    private void allPropertiesSet() {
        super.afterPropertiesSet();
    }

    private void injectConnectionFactory() {
        while (this.connectionFactory == null) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
        super.setConnectionFactory(this.connectionFactory);
    }

    public boolean isGetMetaListener() {
        return this.getMessageSelector() != null && this.__listenerRef.getMessageSelector().endsWith(GETMETA_SELECTOR_SUFFIX);
    }

    private boolean isActiveMQDestination() {
        return this.getDestination() != null && this.getDestination() instanceof ActiveMQDestination;
    }

    public void initializeContainer() {
        block3: {
            try {
                this.injectConnectionFactory();
                super.initialize();
            }
            catch (Exception e) {
                if (!UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) break block3;
                if (this.controller != null) {
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "initializeContainer", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.controller.getComponentName());
                }
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "initializeContainer", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
            }
        }
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.cc = concurrentConsumers;
        if (this.freeCasQueueListener) {
            super.setConcurrentConsumers(concurrentConsumers);
        }
    }

    public void setMessageListener(Object messageListener) {
        this.ml = messageListener;
        if (this.freeCasQueueListener || this.targetedListener) {
            super.setMessageListener(messageListener);
        } else if (this.endpoint != null && this.endpoint.isTempReplyDestination()) {
            super.setMessageListener(messageListener);
        }
    }

    public void afterPropertiesSet() {
        this.afterPropertiesSet(true);
    }

    public void afterPropertiesSet(final boolean propagate) {
        if (this.endpoint != null) {
            if (this.cc > 1 && this.endpoint.isTempReplyDestination() && this.connectionFactory instanceof ActiveMQConnectionFactory) {
                ((ActiveMQConnectionFactory)this.connectionFactory).getPrefetchPolicy().setQueuePrefetch(this.cc);
            }
            super.setConcurrentConsumers(1);
            if (this.cc > 1) {
                try {
                    String prefix = this.endpoint.getDelegateKey() + " Reply Thread";
                    this.concurrentListener = new ConcurrentMessageListener(this.cc, this.ml, this.getDestinationName(), this.threadGroup, prefix);
                    super.setMessageListener((Object)this.concurrentListener);
                }
                catch (Exception e) {
                    if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) {
                        if (this.controller != null) {
                            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "afterPropertiesSet", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.controller.getComponentName());
                        }
                        UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "afterPropertiesSet", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
                    }
                    return;
                }
            } else {
                this.pluginThreadPool = true;
            }
        } else {
            super.setConcurrentConsumers(1);
            this.pluginThreadPool = true;
        }
        Thread t = new Thread(this.threadGroup, new Runnable(){

            @Override
            public void run() {
                Destination destination = UimaDefaultMessageListenerContainer.this.__listenerRef.getDestination();
                try {
                    Delegate delegate;
                    while (UimaDefaultMessageListenerContainer.this.connectionFactory == null) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    System.setProperty("BrokerURI", ((ActiveMQConnectionFactory)UimaDefaultMessageListenerContainer.this.connectionFactory).getBrokerURL());
                    boolean done = false;
                    if (UimaDefaultMessageListenerContainer.this.isActiveMQDestination() && !UimaDefaultMessageListenerContainer.this.isGetMetaListener() && !((ActiveMQDestination)destination).isTemporary()) {
                        UimaDefaultMessageListenerContainer.this.connectWithInputChannel();
                        done = true;
                        while (UimaDefaultMessageListenerContainer.this.controller == null) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    UimaDefaultMessageListenerContainer.this.__listenerRef.injectConnectionFactory();
                    if (UimaDefaultMessageListenerContainer.this.pluginThreadPool) {
                        UimaDefaultMessageListenerContainer.this.setUimaASThreadPoolExecutor(UimaDefaultMessageListenerContainer.this.cc);
                    }
                    if (!UimaDefaultMessageListenerContainer.this.isGetMetaListener()) {
                        UimaDefaultMessageListenerContainer.this.initializeTaskExecutor(UimaDefaultMessageListenerContainer.this.cc);
                    }
                    if (propagate) {
                        UimaDefaultMessageListenerContainer.this.__listenerRef.allPropertiesSet();
                    }
                    if (UimaDefaultMessageListenerContainer.this.isActiveMQDestination() && destination != null) {
                        UimaDefaultMessageListenerContainer.this.destinationName = ((ActiveMQDestination)destination).getPhysicalName();
                    }
                    if (!done) {
                        UimaDefaultMessageListenerContainer.this.connectWithInputChannel();
                        done = true;
                    }
                    if (UimaDefaultMessageListenerContainer.this.concurrentListener != null) {
                        UimaDefaultMessageListenerContainer.this.concurrentListener.setAnalysisEngineController(UimaDefaultMessageListenerContainer.this.controller);
                    }
                    if (UimaDefaultMessageListenerContainer.this.endpoint != null && UimaDefaultMessageListenerContainer.this.controller instanceof AggregateAnalysisEngineController && (delegate = ((AggregateAnalysisEngineController)UimaDefaultMessageListenerContainer.this.controller).lookupDelegate(UimaDefaultMessageListenerContainer.this.endpoint.getDelegateKey())) != null) {
                        delegate.getEndpoint().setConcurrentReplyConsumers(UimaDefaultMessageListenerContainer.this.cc);
                    }
                    if (UimaDefaultMessageListenerContainer.this.__listenerRef.getMessageListener() == null && UimaDefaultMessageListenerContainer.this.getDestination() != null) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, this.getClass().getName(), "afterPropertiesSet", "jms_adapter_messages", "UIMAJMS_listener_ready__INFO", new Object[]{UimaDefaultMessageListenerContainer.this.controller.getComponentName(), UimaDefaultMessageListenerContainer.this.getBrokerUrl(), UimaDefaultMessageListenerContainer.this.getDestination()});
                    }
                }
                catch (Exception e) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "afterPropertiesSet", "jms_adapter_messages", "UIMAJMS_jms_listener_failed_WARNING", new Object[]{destination, UimaDefaultMessageListenerContainer.this.getBrokerUrl(), e});
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "afterPropertiesSet", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
                }
            }
        });
        t.start();
    }

    private void connectWithInputChannel() throws Exception {
        Object pojoListener = this.getPojoListener();
        if (pojoListener instanceof JmsInputChannel) {
            while (((JmsInputChannel)pojoListener).getController() == null) {
                try {
                    Thread.currentThread().wait(50L);
                }
                catch (Exception exception) {}
            }
            ((JmsInputChannel)pojoListener).setListenerContainer(this.__listenerRef);
        } else if (pojoListener instanceof ModifiableListener) {
            ((ModifiableListener)pojoListener).setListener(this.__listenerRef);
        }
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public String getEndpointName() {
        if (this.getDestination() != null) {
            return ((ActiveMQDestination)this.getDestination()).getPhysicalName();
        }
        return null;
    }

    public String getBrokerUrl() {
        return ((ActiveMQConnectionFactory)this.connectionFactory).getBrokerURL();
    }

    public void setConnectionFactory(ConnectionFactory aConnectionFactory) {
        this.connectionFactory = aConnectionFactory;
        ConnectionFactoryIniter cfIniter = new ConnectionFactoryIniter((ActiveMQConnectionFactory)this.connectionFactory);
        cfIniter.whiteListPackages();
        ((ActiveMQConnectionFactory)this.connectionFactory).setTrustAllPackages(true);
        super.setConnectionFactory(this.connectionFactory);
    }

    public void setDestinationResolver(DestinationResolver resolver) {
        ((TempDestinationResolver)resolver).setListener(this);
        super.setDestinationResolver(resolver);
    }

    public void closeConnection() throws Exception {
        block7: {
            try {
                ActiveMQConnection amqc;
                if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.FINEST)) {
                    String msg = ".................... closeConnection() Called";
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "closeConnection", "jms_adapter_messages", "UIMAJMS_debug_msg__FINEST", new Object[]{msg});
                }
                this.setRecoveryInterval(1L);
                this.setAutoStartup(false);
                if (this.getSharedConnection() != null && (amqc = (ActiveMQConnection)this.getSharedConnection()) != null && amqc.isStarted() && !amqc.isClosed() && !amqc.isClosing() && !amqc.isTransportFailed()) {
                    this.getSharedConnection().close();
                    if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.FINEST)) {
                        String msg = ".................... - Stopped Shared Connection";
                        UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "closeConnection", "jms_adapter_messages", "UIMAJMS_debug_msg__FINEST", new Object[]{msg});
                    }
                }
            }
            catch (AbstractJmsListeningContainer.SharedConnectionNotInitializedException amqc) {
            }
            catch (Exception e) {
                if (!UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) break block7;
                if (this.controller != null) {
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "closeConnection", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.controller.getComponentName());
                }
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, ((Object)((Object)this)).getClass().getName(), "closeConnection", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
            }
        }
    }

    public void setDestination(Destination aDestination) {
        super.setDestination(aDestination);
        if (this.endpoint != null) {
            this.endpoint.setDestination((Object)aDestination);
            int prefetchSize = ((ActiveMQConnectionFactory)this.connectionFactory).getPrefetchPolicy().getQueuePrefetch();
            if (aDestination instanceof TemporaryQueue) {
                if (prefetchSize > 1 && UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "setDestination", "uimaee_messages", "UIMAJMS_replyq_prefetch_override__INFO", new Object[]{aDestination, prefetchSize});
                }
                this.endpoint.setTempReplyDestination(true);
                Object pojoListener = this.getPojoListener();
                if (pojoListener != null && pojoListener instanceof InputChannel) {
                    ((JmsInputChannel)pojoListener).setListenerContainer(this);
                }
            }
            this.endpoint.setServerURI(this.getBrokerUrl());
        }
    }

    private Object getPojoListener() {
        Object pojoListener = null;
        if (this.ml != null) {
            pojoListener = this.ml;
        } else if (this.getMessageListener() != null) {
            pojoListener = this.getMessageListener();
        }
        return pojoListener;
    }

    public Destination getListenerEndpoint() {
        return this.getDestination();
    }

    public void onException(JMSException arg0) {
        String endpointName;
        if (this.awaitingShutdown) {
            return;
        }
        String string = endpointName = this.getDestination() == null ? "" : ((ActiveMQDestination)this.getDestination()).getPhysicalName();
        if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) {
            if (this.controller != null) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "onException", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.controller.getComponentName());
            }
            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, ((Object)((Object)this)).getClass().getName(), "onException", "jms_adapter_messages", "UIMAJMS_jms_listener_failed_WARNING", new Object[]{endpointName, this.getBrokerUrl(), arg0});
        }
        if (this.getDestination() != null && ((ActiveMQDestination)this.getDestination()).isTemporary()) {
            this.handleTempQueueFailure(arg0);
        }
    }

    public void setTargetEndpoint(Endpoint anEndpoint) {
        this.endpoint = anEndpoint;
    }

    public boolean isFreeCasQueueListener() {
        return this.freeCasQueueListener;
    }

    protected void setModifiedTaskExecutor(TaskExecutor taskExecutor) {
        super.setTaskExecutor((Executor)taskExecutor);
    }

    public void doDestroy() {
        super.destroy();
    }

    public void setMessageSelector(String messageSelector) {
        if (!messageSelector.startsWith("TargetServiceId")) {
            messageSelector = "TargetServiceId is NULL AND(" + messageSelector + ")";
        }
        super.setMessageSelector(messageSelector);
        this.setAutoStartup(false);
    }

    private boolean isProcessListener() {
        return this.getMessageSelector().endsWith(PROCESS_SELECTOR_SUFFIX);
    }

    protected void doInvokeListener(SessionAwareMessageListener l, Session s, Message m) {
        try {
            if (this.targetedListener) {
                m.setJMSPriority(9);
                m.setJMSType("TargetMessage");
                if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "doInvokeListener", "jms_adapter_messages", "UIMAJMS_MSG_INTERCEPTOR__FINEST", new Object[]{this.controller.getComponentName(), m.getJMSPriority(), this.getMessageSelector()});
                }
            }
            l.onMessage(m, s);
        }
        catch (Throwable t) {
            t.printStackTrace();
            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, ((Object)((Object)this)).getClass().getName(), "destroy", "jms_adapter_messages", "UIMAJMS_exception__WARNING", t);
        }
    }

    public void shutdownTaskExecutor(ThreadPoolExecutor tpe, boolean stopImmediate) throws InterruptedException {
        tpe.awaitTermination(50L, TimeUnit.MILLISECONDS);
        if (stopImmediate) {
            tpe.setKeepAliveTime(50L, TimeUnit.MILLISECONDS);
            tpe.allowCoreThreadTimeOut(true);
            tpe.purge();
            tpe.shutdownNow();
        } else {
            tpe.shutdown();
        }
    }

    public void destroy() {
        this.destroy(true);
    }

    public void destroy(final boolean stopImmediate) {
        if (this.awaitingShutdown) {
            return;
        }
        Thread threadGroupDestroyer = new Thread(this.threadGroup.getParent().getParent(), "threadGroupDestroyer"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String msg;
                    if (!UimaDefaultMessageListenerContainer.this.__listenerRef.awaitingShutdown) {
                        ActiveMQConnection amqc = (ActiveMQConnection)UimaDefaultMessageListenerContainer.this.getSharedConnection();
                        if (amqc != null) {
                            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                                msg = "......... Stopping Client ID:" + amqc.getConnectionInfo().getClientId();
                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "destroy.run", "jms_adapter_messages", "UIMAJMS_debug_msg__FINEST", new Object[]{msg});
                            }
                            amqc.stop();
                        }
                        UimaDefaultMessageListenerContainer.this.awaitingShutdown = true;
                        if (UimaDefaultMessageListenerContainer.this.getMessageListener() instanceof PriorityMessageHandler) {
                            ((PriorityMessageHandler)UimaDefaultMessageListenerContainer.this.getMessageListener()).getQueue().put(new MessageWrapper(null, null, null, 9));
                        }
                        if (UimaDefaultMessageListenerContainer.this.taskExecutor != null && UimaDefaultMessageListenerContainer.this.taskExecutor instanceof ThreadPoolTaskExecutor) {
                            try {
                                Method m = ((ThreadPoolTaskExecutor)UimaDefaultMessageListenerContainer.this.taskExecutor).getThreadPoolExecutor().getClass().getMethod("allowCoreThreadTimeOut", Boolean.TYPE);
                                m.invoke((Object)((ThreadPoolTaskExecutor)UimaDefaultMessageListenerContainer.this.taskExecutor).getThreadPoolExecutor(), true);
                            }
                            catch (NoSuchMethodException e) {
                                ((ThreadPoolTaskExecutor)UimaDefaultMessageListenerContainer.this.taskExecutor).getThreadPoolExecutor().setCorePoolSize(0);
                            }
                            ((ThreadPoolTaskExecutor)UimaDefaultMessageListenerContainer.this.taskExecutor).getThreadPoolExecutor().setKeepAliveTime(1000L, TimeUnit.MILLISECONDS);
                            ((ThreadPoolTaskExecutor)UimaDefaultMessageListenerContainer.this.taskExecutor).setWaitForTasksToCompleteOnShutdown(true);
                            ((ThreadPoolTaskExecutor)UimaDefaultMessageListenerContainer.this.taskExecutor).shutdown();
                            ((ThreadPoolTaskExecutor)UimaDefaultMessageListenerContainer.this.taskExecutor).destroy();
                            ((ThreadPoolTaskExecutor)UimaDefaultMessageListenerContainer.this.taskExecutor).getThreadPoolExecutor().shutdownNow();
                        } else if (UimaDefaultMessageListenerContainer.this.concurrentListener != null) {
                            UimaDefaultMessageListenerContainer.this.shutdownTaskExecutor(UimaDefaultMessageListenerContainer.this.concurrentListener.getTaskExecutor(), stopImmediate);
                            UimaDefaultMessageListenerContainer.this.concurrentListener.stop();
                        } else if (UimaDefaultMessageListenerContainer.this.threadPoolExecutor != null) {
                            UimaDefaultMessageListenerContainer.this.shutdownTaskExecutor(UimaDefaultMessageListenerContainer.this.threadPoolExecutor, true);
                        }
                    }
                    if (UimaDefaultMessageListenerContainer.this.getTaskExecutor() != null && UimaDefaultMessageListenerContainer.this.getTaskExecutor() instanceof ThreadPoolTaskExecutor) {
                        ((ThreadPoolTaskExecutor)UimaDefaultMessageListenerContainer.this.getTaskExecutor()).shutdown();
                    }
                    String controllerName = UimaDefaultMessageListenerContainer.this.__listenerRef.controller == null ? "" : UimaDefaultMessageListenerContainer.this.__listenerRef.controller.getComponentName();
                    UimaDefaultMessageListenerContainer.this.__listenerRef.shutdown();
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                        msg = "................... Listener shutdown() - Called - Listener:" + UimaDefaultMessageListenerContainer.this.getDestinationName();
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "destroy.run", "jms_adapter_messages", "UIMAJMS_debug_msg__FINEST", new Object[]{msg});
                    }
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "destroy.run()", "uimaee_messages", "UIMAJMS_listener_shutdown__INFO", new Object[]{controllerName, UimaDefaultMessageListenerContainer.this.__listenerRef.getMessageSelector(), UimaDefaultMessageListenerContainer.this.__listenerRef.getBrokerUrl()});
                    }
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "destroy.run()", "uimaee_messages", "UIMAJMS_listener_jms_connection_closed__INFO", new Object[]{controllerName, UimaDefaultMessageListenerContainer.this.__listenerRef.getMessageSelector()});
                    }
                }
                catch (Exception e) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "destroy", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)e);
                }
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                    UimaDefaultMessageListenerContainer.this.threadGroup.getParent().list();
                }
                try {
                    ThreadGroup e = UimaDefaultMessageListenerContainer.this.threadGroup;
                    synchronized (e) {
                        if (!UimaDefaultMessageListenerContainer.this.threadGroup.isDestroyed()) {
                            UimaDefaultMessageListenerContainer.this.threadGroup.destroy();
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (UimaDefaultMessageListenerContainer.this.latchToCountNumberOfTerminatedThreads != null && UimaDefaultMessageListenerContainer.this.cc > 1) {
                        UimaDefaultMessageListenerContainer.this.latchToCountNumberOfTerminatedThreads.await();
                    }
                }
                catch (Exception ex) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "destroy", "jms_adapter_messages", "UIMAJMS_exception__WARNING", (Throwable)ex);
                }
            }
        };
        threadGroupDestroyer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setUimaASThreadPoolExecutor(int consumerCount) throws Exception {
        block19: {
            block22: {
                block21: {
                    block20: {
                        block18: {
                            if (!this.isGetMetaListener()) break block18;
                            super.setMessageListener(this.ml);
                            break block19;
                        }
                        if (!this.isFreeCasQueueListener()) break block20;
                        super.setMessageListener(this.ml);
                        break block19;
                    }
                    if (this.endpoint == null || !this.endpoint.isTempReplyDestination()) break block21;
                    super.setMessageListener(this.ml);
                    break block19;
                }
                if (!this.isProcessListener()) break block22;
                if (!this.targetedListener && !this.isFreeCasQueueListener()) {
                    PriorityMessageHandler h = new PriorityMessageHandler(this.cc);
                    super.setMessageListener((Object)h);
                    try {
                        while (this.controller.getInputChannel() == null) {
                            PriorityMessageHandler priorityMessageHandler = h;
                            synchronized (priorityMessageHandler) {
                                h.wait(100L);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.latchToCountNumberOfTerminatedThreads = new CountDownLatch(consumerCount);
                    this.tf = new UimaAsPriorityBasedThreadFactory(this.threadGroup, this.controller, this.latchToCountNumberOfTerminatedThreads);
                    ((UimaAsPriorityBasedThreadFactory)this.tf).withQueue(h.getQueue()).withChannel(this.controller.getInputChannel());
                    ((UimaAsPriorityBasedThreadFactory)this.tf).setDaemon(true);
                    if (this.taskExecutor == null) {
                        this.taskExecutor = new ThreadPoolTaskExecutor();
                    }
                    ((ThreadPoolTaskExecutor)this.taskExecutor).setThreadFactory(this.tf);
                    ((ThreadPoolTaskExecutor)this.taskExecutor).initialize();
                    ((ThreadPoolTaskExecutor)this.taskExecutor).getThreadPoolExecutor().prestartAllCoreThreads();
                }
                break block19;
            }
            if (this.controller.getInputChannel() == null || this.controller.getInputChannel() instanceof MessageListener || !(this.controller.getInputChannel() instanceof SessionAwareMessageListener)) {
                // empty if block
            }
            super.setMessageListener((Object)this.controller.getInputChannel());
        }
        if (!this.targetedListener && this.taskExecutor == null) {
            UimaAsThreadFactory utf = new UimaAsThreadFactory(this.threadGroup);
            utf.setDaemon(false);
            if (this.isFreeCasQueueListener()) {
                utf.setThreadNamePrefix(this.controller.getComponentName() + " - FreeCASRequest Thread");
            } else if (this.isGetMetaListener()) {
                utf.setThreadNamePrefix(super.getBeanName() + " - Thread");
            } else if (this.getDestination() != null && this.getMessageSelector() != null) {
                utf.setThreadNamePrefix(this.controller.getComponentName() + " Process Thread");
            } else if (this.endpoint != null && this.endpoint.isTempReplyDestination()) {
                utf.setThreadNamePrefix(super.getBeanName() + " - Thread");
            } else {
                throw new Exception("Unknown Context Detected in setUimaASThreadPoolExecutor()");
            }
            ExecutorService es = Executors.newFixedThreadPool(consumerCount, (ThreadFactory)utf);
            if (es instanceof ThreadPoolExecutor) {
                this.threadPoolExecutor = (ThreadPoolExecutor)es;
                super.setTaskExecutor((Executor)es);
            }
        }
    }

    private boolean isPrimitiveService() {
        return this.controller != null && this.controller instanceof PrimitiveAnalysisEngineController && this.controller.getInputChannel() != null;
    }

    public void setTaskExecutor(TaskExecutor aTaskExecutor) {
        this.taskExecutor = aTaskExecutor;
    }

    public TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeTaskExecutor(int consumers) throws Exception {
        if (this.controller instanceof PrimitiveAnalysisEngineController && !this.targetedListener && !this.isFreeCasQueueListener()) {
            Object object = this.mux2;
            synchronized (object) {
                while (this.taskExecutor == null) {
                    this.mux2.wait(20L);
                }
            }
        }
        if (this.threadPoolExecutor != null) {
            this.threadPoolExecutor.prestartAllCoreThreads();
        }
    }

    public void delegateStop() {
        super.stop();
    }

    public void stop() throws JmsException {
        this.destroy();
    }

    static {
        recoveryLatch = new CountDownLatch(4);
    }
}

