/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.error;

import java.util.Arrays;

public class Threshold {
    private int threshold;
    private String action;
    private int window;
    private int maxRetries;
    private boolean continueOnRetryFailure;
    private long errorCount;
    private long[] errorSequences;

    public Threshold() {
    }

    private Threshold(Threshold t) {
        this.window = t.window;
        this.threshold = t.threshold;
        this.action = t.action;
        this.maxRetries = t.maxRetries;
        this.continueOnRetryFailure = t.continueOnRetryFailure;
        if (this.window >= this.threshold && this.threshold > 1) {
            this.errorSequences = new long[this.threshold - 1];
            Arrays.fill(this.errorSequences, (long)(-this.window));
        }
    }

    public long getWindow() {
        return this.window;
    }

    public void setWindow(long aWindow) {
        this.window = (int)aWindow;
    }

    public long getThreshold() {
        return this.threshold;
    }

    public void setThreshold(long aCount) {
        this.threshold = (int)aCount;
    }

    public Threshold initialize() {
        if (this.window >= this.threshold && this.threshold > 1) {
            if (this.errorSequences == null) {
                this.errorSequences = new long[this.threshold - 1];
                Arrays.fill(this.errorSequences, (long)(-this.window));
                return this;
            }
            return new Threshold(this);
        }
        return this;
    }

    public boolean exceeded(long value) {
        if (this.threshold == 0) {
            return false;
        }
        return value >= (long)(this.threshold - 1);
    }

    public boolean exceededWindow(long casCount) {
        if (this.threshold == 0) {
            return false;
        }
        ++this.errorCount;
        if (this.errorSequences == null) {
            return this.errorCount >= (long)this.threshold;
        }
        int i = this.threshold - 1;
        while (--i >= 0) {
            if (this.errorSequences[i] > casCount - (long)this.window) continue;
            this.errorSequences[i] = casCount;
            return false;
        }
        return true;
    }

    public boolean maxRetriesExceeded(long value) {
        return value >= (long)this.maxRetries;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public boolean getContinueOnRetryFailure() {
        return this.continueOnRetryFailure;
    }

    public void setContinueOnRetryFailure(boolean continueOnRetryFailure) {
        this.continueOnRetryFailure = continueOnRetryFailure;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }
}

