/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.testing.junit;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.uima.UIMAException;
import org.apache.uima.cas.CAS;
import org.apache.uima.fit.factory.CasFactory;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public final class ManagedCas
extends TestWatcher {
    private final ThreadLocal<CAS> casHolder;
    private static final Set<CAS> managedCases = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));

    public ManagedCas() {
        this.casHolder = ThreadLocal.withInitial(() -> {
            try {
                CAS cas = CasFactory.createCas();
                managedCases.add(cas);
                return cas;
            }
            catch (UIMAException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public ManagedCas(TypeSystemDescription aTypeSystemDescription) {
        this.casHolder = ThreadLocal.withInitial(() -> {
            try {
                CAS cas = CasFactory.createCas((TypeSystemDescription)aTypeSystemDescription);
                managedCases.add(cas);
                return cas;
            }
            catch (UIMAException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public CAS get() {
        return this.casHolder.get();
    }

    protected void starting(Description description) {
        managedCases.forEach(cas -> cas.reset());
    }
}

