/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.components;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.impl.XCASSerializer;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.examples.SourceDocumentInformation;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.CasToInlineXml;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.Level;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLSerializer;
import org.xml.sax.SAXException;

public class InlineXmlCasConsumer
extends CasConsumer_ImplBase {
    public static final String PARAM_OUTPUTDIR = "OutputDirectory";
    public static final String PARAM_XCAS = "XCAS";
    private File mOutputDir;
    private CasToInlineXml cas2xml;
    private int mDocNum;
    private String mXCAS;
    private boolean mTEXT;

    public void initialize() throws ResourceInitializationException {
        this.mDocNum = 0;
        this.mOutputDir = new File(((String)this.getConfigParameterValue(PARAM_OUTPUTDIR)).trim());
        if (!this.mOutputDir.exists()) {
            this.mOutputDir.mkdirs();
        }
        this.cas2xml = new CasToInlineXml();
        this.mXCAS = (String)this.getConfigParameterValue(PARAM_XCAS);
        this.mTEXT = !"xcas".equalsIgnoreCase(this.mXCAS) && !"xmi".equalsIgnoreCase(this.mXCAS);
    }

    public void processCas(CAS aCAS) throws ResourceProcessException {
        JCas jcas;
        try {
            jcas = aCAS.getJCas();
        }
        catch (CASException e) {
            throw new ResourceProcessException((Throwable)e);
        }
        File outFile = null;
        boolean hasDefaultView = false;
        if (this.mTEXT) {
            try {
                jcas = aCAS.getView("_InitialView").getJCas();
                hasDefaultView = true;
                FSIterator it = jcas.getAnnotationIndex(SourceDocumentInformation.type).iterator();
                if (it.hasNext()) {
                    SourceDocumentInformation fileLoc = (SourceDocumentInformation)it.next();
                    File inFile = new File(new URL(fileLoc.getUri()).getPath());
                    outFile = new File(this.mOutputDir, inFile.getName());
                }
            }
            catch (CASRuntimeException it) {
            }
            catch (CASException it) {
            }
            catch (MalformedURLException it) {
                // empty catch block
            }
        }
        if (outFile == null) {
            outFile = new File(this.mOutputDir, "doc" + this.mDocNum++);
        }
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(outFile);
            if (hasDefaultView) {
                String xmlAnnotations = this.cas2xml.generateXML(aCAS);
                outStream.write(xmlAnnotations.getBytes(StandardCharsets.UTF_8));
            } else {
                XCASSerializer ser;
                XMLSerializer xmlSer = new XMLSerializer((OutputStream)outStream, false);
                if (this.mXCAS.equalsIgnoreCase("xcas")) {
                    ser = new XCASSerializer(aCAS.getTypeSystem());
                    ser.serialize(aCAS, xmlSer.getContentHandler());
                } else {
                    ser = new XmiCasSerializer(aCAS.getTypeSystem());
                    ser.serialize(aCAS, xmlSer.getContentHandler());
                }
            }
        }
        catch (CASException e) {
            throw new ResourceProcessException((Throwable)e);
        }
        catch (IOException e) {
            throw new ResourceProcessException((Throwable)e);
        }
        catch (SAXException e) {
            throw new ResourceProcessException((Throwable)e);
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    this.getLogger().log(Level.WARNING, e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static CasConsumerDescription getDescription() throws InvalidXMLException {
        InputStream descStream = InlineXmlCasConsumer.class.getResourceAsStream("InlineXmlCasConsumer.xml");
        return UIMAFramework.getXMLParser().parseCasConsumerDescription(new XMLInputSource(descStream, null));
    }

    public static URL getDescriptorURL() {
        return InlineXmlCasConsumer.class.getResource("InlineXmlCasConsumer.xml");
    }
}

