/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Processor;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CollectionStringBuffer;

@Metadata(label="eip,routing,circuitbreaker")
@XmlRootElement(name="onFallback")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OnFallbackDefinition
extends OutputDefinition<OnFallbackDefinition> {
    @XmlAttribute
    @Metadata(label="command", defaultValue="false")
    private Boolean fallbackViaNetwork;

    @Override
    public String toString() {
        if (this.fallbackViaNetwork != null && this.fallbackViaNetwork.booleanValue()) {
            return "OnFallbackViaNetwork[" + this.getOutputs() + "]";
        }
        return "OnFallback[" + this.getOutputs() + "]";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        return this.createChildProcessor(routeContext, false);
    }

    @Override
    public String getLabel() {
        String name = this.fallbackViaNetwork != null && this.fallbackViaNetwork != false ? "onFallbackViaNetwork" : "onFallback";
        CollectionStringBuffer buffer = new CollectionStringBuffer(name);
        buffer.append("[");
        List<ProcessorDefinition<?>> list = this.getOutputs();
        for (ProcessorDefinition<?> type : list) {
            buffer.append(type.getLabel());
        }
        buffer.append("]");
        return buffer.toString();
    }

    public Boolean getFallbackViaNetwork() {
        return this.fallbackViaNetwork;
    }

    public void setFallbackViaNetwork(Boolean fallbackViaNetwork) {
        this.fallbackViaNetwork = fallbackViaNetwork;
    }

    public boolean isFallbackViaNetwork() {
        return this.fallbackViaNetwork != null && this.fallbackViaNetwork != false;
    }
}

