/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.processor.CamelInternalProcessorAdvice;
import org.apache.camel.processor.MarshalProcessor;
import org.apache.camel.processor.UnmarshalProcessor;
import org.apache.camel.processor.binding.BindingException;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeAware;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;

public class RestBindingAdvice
implements CamelInternalProcessorAdvice<Map<String, Object>> {
    private static final String STATE_KEY_DO_MARSHAL = "doMarshal";
    private static final String STATE_KEY_ACCEPT = "accept";
    private static final String STATE_JSON = "json";
    private static final String STATE_XML = "xml";
    private final AsyncProcessor jsonUnmarshal;
    private final AsyncProcessor xmlUnmarshal;
    private final AsyncProcessor jsonMarshal;
    private final AsyncProcessor xmlMarshal;
    private final String consumes;
    private final String produces;
    private final String bindingMode;
    private final boolean skipBindingOnErrorCode;
    private final boolean enableCORS;
    private final Map<String, String> corsHeaders;
    private final Map<String, String> queryDefaultValues;

    public RestBindingAdvice(CamelContext camelContext, DataFormat jsonDataFormat, DataFormat xmlDataFormat, DataFormat outJsonDataFormat, DataFormat outXmlDataFormat, String consumes, String produces, String bindingMode, boolean skipBindingOnErrorCode, boolean enableCORS, Map<String, String> corsHeaders, Map<String, String> queryDefaultValues) throws Exception {
        this.jsonUnmarshal = jsonDataFormat != null ? new UnmarshalProcessor(jsonDataFormat) : null;
        this.jsonMarshal = outJsonDataFormat != null ? new MarshalProcessor(outJsonDataFormat) : (jsonDataFormat != null ? new MarshalProcessor(jsonDataFormat) : null);
        this.xmlUnmarshal = xmlDataFormat != null ? new UnmarshalProcessor(xmlDataFormat) : null;
        this.xmlMarshal = outXmlDataFormat != null ? new MarshalProcessor(outXmlDataFormat) : (xmlDataFormat != null ? new MarshalProcessor(xmlDataFormat) : null);
        if (this.jsonMarshal != null) {
            camelContext.addService(this.jsonMarshal, true);
        }
        if (this.jsonUnmarshal != null) {
            camelContext.addService(this.jsonUnmarshal, true);
        }
        if (this.xmlMarshal instanceof CamelContextAware) {
            camelContext.addService(this.xmlMarshal, true);
        }
        if (this.xmlUnmarshal instanceof CamelContextAware) {
            camelContext.addService(this.xmlUnmarshal, true);
        }
        this.consumes = consumes;
        this.produces = produces;
        this.bindingMode = bindingMode;
        this.skipBindingOnErrorCode = skipBindingOnErrorCode;
        this.enableCORS = enableCORS;
        this.corsHeaders = corsHeaders;
        this.queryDefaultValues = queryDefaultValues;
    }

    @Override
    public Map<String, Object> before(Exchange exchange) throws Exception {
        HashMap<String, Object> state = new HashMap<String, Object>();
        if (this.isOptionsMethod(exchange, state)) {
            return state;
        }
        this.unmarshal(exchange, state);
        return state;
    }

    @Override
    public void after(Exchange exchange, Map<String, Object> state) throws Exception {
        if (this.enableCORS) {
            this.setCORSHeaders(exchange, state);
        }
        if (state.get(STATE_KEY_DO_MARSHAL) != null) {
            this.marshal(exchange, state);
        }
    }

    private boolean isOptionsMethod(Exchange exchange, Map<String, Object> state) {
        String method = exchange.getIn().getHeader("CamelHttpMethod", String.class);
        if ("OPTIONS".equalsIgnoreCase(method)) {
            exchange.setProperty("CamelRouteStop", true);
            return true;
        }
        return false;
    }

    private void unmarshal(Exchange exchange, Map<String, Object> state) throws Exception {
        boolean isXml = false;
        boolean isJson = false;
        String contentType = ExchangeHelper.getContentType(exchange);
        if (contentType != null) {
            isXml = contentType.toLowerCase(Locale.ENGLISH).contains(STATE_XML);
            isJson = contentType.toLowerCase(Locale.ENGLISH).contains(STATE_JSON);
        }
        if (!isXml && !isJson) {
            isXml = this.consumes != null && this.consumes.toLowerCase(Locale.ENGLISH).contains(STATE_XML);
            boolean bl = isJson = this.consumes != null && this.consumes.toLowerCase(Locale.ENGLISH).contains(STATE_JSON);
        }
        if (exchange.getContext().isUseDataType().booleanValue() && exchange.getIn() instanceof DataTypeAware && (isJson || isXml)) {
            ((DataTypeAware)((Object)exchange.getIn())).setDataType(new DataType(isJson ? STATE_JSON : STATE_XML));
        }
        if (!(isJson &= this.bindingMode.equals("auto") || this.bindingMode.contains(STATE_JSON)) && !(isXml &= this.bindingMode.equals("auto") || this.bindingMode.contains(STATE_XML))) {
            isXml = this.bindingMode.equals("auto") || this.bindingMode.contains(STATE_XML);
            isJson = this.bindingMode.equals("auto") || this.bindingMode.contains(STATE_JSON);
        }
        state.put(STATE_KEY_ACCEPT, exchange.getIn().getHeader("Accept", String.class));
        String body = null;
        if (exchange.getIn().getBody() != null && (isXml || isJson) && (body = MessageHelper.extractBodyAsString(exchange.getIn())) != null) {
            if (exchange.getIn() instanceof DataTypeAware) {
                ((DataTypeAware)((Object)exchange.getIn())).setBody(body, new DataType(isJson ? STATE_JSON : STATE_XML));
            } else {
                exchange.getIn().setBody(body);
            }
            if (isXml && isJson) {
                isXml = body.startsWith("<");
                boolean bl = isJson = !isXml;
            }
        }
        if (this.queryDefaultValues != null) {
            for (Map.Entry<String, String> entry : this.queryDefaultValues.entrySet()) {
                if (exchange.getIn().getHeader(entry.getKey()) != null) continue;
                exchange.getIn().setHeader(entry.getKey(), entry.getValue());
            }
        }
        if (isJson && this.jsonUnmarshal != null) {
            state.put(STATE_KEY_DO_MARSHAL, STATE_JSON);
            if (ObjectHelper.isNotEmpty(body)) {
                this.jsonUnmarshal.process(exchange);
                ExchangeHelper.prepareOutToIn(exchange);
            }
            return;
        }
        if (isXml && this.xmlUnmarshal != null) {
            state.put(STATE_KEY_DO_MARSHAL, STATE_XML);
            if (ObjectHelper.isNotEmpty(body)) {
                this.xmlUnmarshal.process(exchange);
                ExchangeHelper.prepareOutToIn(exchange);
            }
            return;
        }
        if ("off".equals(this.bindingMode) || this.bindingMode.equals("auto")) {
            state.put(STATE_KEY_DO_MARSHAL, STATE_JSON);
        } else if (this.bindingMode.contains(STATE_XML)) {
            exchange.setException(new BindingException("Cannot bind to xml as message body is not xml compatible", exchange));
        } else {
            exchange.setException(new BindingException("Cannot bind to json as message body is not json compatible", exchange));
        }
    }

    private void marshal(Exchange exchange, Map<String, Object> state) {
        String contentType;
        if (exchange.getException() != null) {
            return;
        }
        if (this.skipBindingOnErrorCode) {
            Integer code;
            Integer n = code = exchange.hasOut() ? exchange.getOut().getHeader("CamelHttpResponseCode", Integer.class) : exchange.getIn().getHeader("CamelHttpResponseCode", Integer.class);
            if (code != null && code >= 300) {
                return;
            }
        }
        boolean isXml = false;
        boolean isJson = false;
        String accept = (String)state.get(STATE_KEY_ACCEPT);
        if (accept != null) {
            isXml = accept.toLowerCase(Locale.ENGLISH).contains(STATE_XML);
            isJson = accept.toLowerCase(Locale.ENGLISH).contains(STATE_JSON);
        }
        if (!isXml && !isJson && (contentType = ExchangeHelper.getContentType(exchange)) != null) {
            isXml = contentType.toLowerCase(Locale.ENGLISH).contains(STATE_XML);
            isJson = contentType.toLowerCase(Locale.ENGLISH).contains(STATE_JSON);
        }
        if (!isXml && !isJson) {
            isXml = this.produces != null && this.produces.toLowerCase(Locale.ENGLISH).contains(STATE_XML);
            boolean bl = isJson = this.produces != null && this.produces.toLowerCase(Locale.ENGLISH).contains(STATE_JSON);
        }
        if (this.bindingMode != null && !(isJson &= this.bindingMode.equals("off") || this.bindingMode.equals("auto") || this.bindingMode.contains(STATE_JSON)) && !(isXml &= this.bindingMode.equals("off") || this.bindingMode.equals("auto") || this.bindingMode.contains(STATE_XML))) {
            isXml = this.bindingMode.equals("auto") || this.bindingMode.contains(STATE_XML);
            boolean bl = isJson = this.bindingMode.equals("auto") || this.bindingMode.contains(STATE_JSON);
        }
        if (isXml && isJson) {
            isXml = state.get(STATE_KEY_DO_MARSHAL).equals(STATE_XML);
            isJson = !isXml;
        }
        ExchangeHelper.prepareOutToIn(exchange);
        this.ensureHeaderContentType(this.produces, isXml, isJson, exchange);
        if (this.bindingMode == null || "off".equals(this.bindingMode)) {
            return;
        }
        if (this.jsonMarshal == null && this.xmlMarshal == null) {
            return;
        }
        if (exchange.hasOut() && exchange.getOut().getBody() == null || !exchange.hasOut() && exchange.getIn().getBody() == null) {
            return;
        }
        contentType = exchange.getIn().getHeader("Content-Type", String.class);
        contentType = contentType.toLowerCase(Locale.US);
        try {
            if (isJson && this.jsonMarshal != null) {
                if (contentType.contains(STATE_JSON)) {
                    this.jsonMarshal.process(exchange);
                    this.setOutputDataType(exchange, new DataType(STATE_JSON));
                }
            } else if (isXml && this.xmlMarshal != null) {
                if (contentType.contains(STATE_XML)) {
                    this.xmlMarshal.process(exchange);
                    this.setOutputDataType(exchange, new DataType(STATE_XML));
                }
            } else if (!this.bindingMode.equals("auto")) {
                if (this.bindingMode.contains(STATE_XML)) {
                    exchange.setException(new BindingException("Cannot bind to xml as message body is not xml compatible", exchange));
                } else {
                    exchange.setException(new BindingException("Cannot bind to json as message body is not json compatible", exchange));
                }
            }
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
    }

    private void setOutputDataType(Exchange exchange, DataType type) {
        Message target;
        Message message = target = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
        if (target instanceof DataTypeAware) {
            ((DataTypeAware)((Object)target)).setDataType(type);
        }
    }

    private void ensureHeaderContentType(String contentType, boolean isXml, boolean isJson, Exchange exchange) {
        String type;
        if (contentType != null && (type = ExchangeHelper.getContentType(exchange)) == null) {
            exchange.getIn().setHeader("Content-Type", contentType);
        }
        if (isJson) {
            type = ExchangeHelper.getContentType(exchange);
            if (type == null) {
                exchange.getIn().setHeader("Content-Type", "application/json");
            }
        } else if (isXml && (type = ExchangeHelper.getContentType(exchange)) == null) {
            exchange.getIn().setHeader("Content-Type", "application/xml");
        }
    }

    private void setCORSHeaders(Exchange exchange, Map<String, Object> state) {
        String maxAge;
        String allowHeaders;
        String allowMethods;
        String allowOrigin;
        Message msg = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
        String string = allowOrigin = this.corsHeaders != null ? this.corsHeaders.get("Access-Control-Allow-Origin") : null;
        if (allowOrigin == null) {
            allowOrigin = "*";
        }
        String string2 = allowMethods = this.corsHeaders != null ? this.corsHeaders.get("Access-Control-Allow-Methods") : null;
        if (allowMethods == null) {
            allowMethods = "GET, HEAD, POST, PUT, DELETE, TRACE, OPTIONS, CONNECT, PATCH";
        }
        String string3 = allowHeaders = this.corsHeaders != null ? this.corsHeaders.get("Access-Control-Allow-Headers") : null;
        if (allowHeaders == null) {
            allowHeaders = "Origin, Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers";
        }
        String string4 = maxAge = this.corsHeaders != null ? this.corsHeaders.get("Access-Control-Max-Age") : null;
        if (maxAge == null) {
            maxAge = "3600";
        }
        String allowCredentials = this.corsHeaders != null ? this.corsHeaders.get("Access-Control-Allow-Credentials") : null;
        String origin = exchange.getIn().getHeader("Origin", String.class);
        if ("true".equalsIgnoreCase(allowCredentials) && "*".equals(allowOrigin) && origin != null) {
            allowOrigin = origin;
        }
        msg.setHeader("Access-Control-Allow-Origin", allowOrigin);
        msg.setHeader("Access-Control-Allow-Methods", allowMethods);
        msg.setHeader("Access-Control-Allow-Headers", allowHeaders);
        msg.setHeader("Access-Control-Max-Age", maxAge);
        if (allowCredentials != null) {
            msg.setHeader("Access-Control-Allow-Credentials", allowCredentials);
        }
    }
}

