/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.lists.actions;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.actions.Action;
import org.apache.unomi.api.actions.ActionExecutor;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.api.services.ProfileService;

public class AddToListsAction
implements ActionExecutor {
    ProfileService profileService;
    EventService eventService;

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public int execute(Action action, Event event) {
        List newListIdentifiers = (List)action.getParameterValues().get("listIdentifiers");
        if (newListIdentifiers == null || newListIdentifiers.size() == 0) {
            return 0;
        }
        Profile profile = event.getProfile();
        ArrayList<String> existingListIdentifiers = (ArrayList<String>)profile.getSystemProperties().get("lists");
        if (existingListIdentifiers == null) {
            existingListIdentifiers = new ArrayList<String>();
        }
        boolean listsChanged = false;
        for (String newListIdentifier : newListIdentifiers) {
            if (existingListIdentifiers.contains(newListIdentifier)) continue;
            existingListIdentifiers.add(newListIdentifier);
            listsChanged = true;
        }
        if (listsChanged) {
            profile.getSystemProperties().put("lists", existingListIdentifiers);
            Event profileUpdated = new Event("profileUpdated", null, profile, event.getScope(), null, (Item)profile, new Date());
            profileUpdated.setPersistent(false);
            this.eventService.send(profileUpdated);
            return 4;
        }
        return 0;
    }
}

