/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.commands;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.persistence.spi.CustomObjectMapper;

@Command(scope="unomi", name="session-view", description="This command will dump a session as a JSON string")
@Service
public class SessionView
implements Action {
    @Reference
    ProfileService profileService;
    @Argument(index=0, name="session", description="The identifier for the session", required=true, multiValued=false)
    String sessionIdentifier;

    public Object execute() throws Exception {
        Session session = this.profileService.loadSession(this.sessionIdentifier, null);
        if (session == null) {
            System.out.println("Couldn't find a session with id=" + this.sessionIdentifier);
            return null;
        }
        String jsonSession = CustomObjectMapper.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)session);
        System.out.println(jsonSession);
        return null;
    }
}

