/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientFailoverConfigBuilder;
import com.hazelcast.client.config.XmlClientFailoverConfigLocator;
import com.hazelcast.client.config.YamlClientFailoverConfigBuilder;
import com.hazelcast.client.config.YamlClientFailoverConfigLocator;
import com.hazelcast.core.HazelcastException;
import java.util.LinkedList;
import java.util.List;

public class ClientFailoverConfig {
    private int tryCount = Integer.MAX_VALUE;
    private List<ClientConfig> clientConfigs = new LinkedList<ClientConfig>();

    public static ClientFailoverConfig load() {
        XmlClientFailoverConfigLocator xmlConfigLocator = new XmlClientFailoverConfigLocator();
        YamlClientFailoverConfigLocator yamlConfigLocator = new YamlClientFailoverConfigLocator();
        if (yamlConfigLocator.locateFromSystemProperty()) {
            return new YamlClientFailoverConfigBuilder(yamlConfigLocator).build();
        }
        if (xmlConfigLocator.locateFromSystemProperty()) {
            return new XmlClientFailoverConfigBuilder(xmlConfigLocator).build();
        }
        if (xmlConfigLocator.locateInWorkDirOrOnClasspath()) {
            return new XmlClientFailoverConfigBuilder(xmlConfigLocator).build();
        }
        if (yamlConfigLocator.locateInWorkDirOrOnClasspath()) {
            return new YamlClientFailoverConfigBuilder(yamlConfigLocator).build();
        }
        throw new HazelcastException("Failed to load ClientFailoverConfig");
    }

    public ClientFailoverConfig addClientConfig(ClientConfig clientConfig) {
        this.clientConfigs.add(clientConfig);
        return this;
    }

    public ClientFailoverConfig setTryCount(int tryCount) {
        this.tryCount = tryCount;
        return this;
    }

    public List<ClientConfig> getClientConfigs() {
        return this.clientConfigs;
    }

    public ClientFailoverConfig setClientConfigs(List<ClientConfig> clientConfigs) {
        this.clientConfigs = clientConfigs;
        return this;
    }

    public int getTryCount() {
        return this.tryCount;
    }
}

