/*
 * Decompiled with CFR 0.152.
 */
package javax.money;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.CurrencyQuery;
import javax.money.CurrencyUnit;
import javax.money.spi.Bootstrap;
import javax.money.spi.CurrencyProviderSpi;
import javax.money.spi.MonetaryCurrenciesSingletonSpi;

final class DefaultMonetaryCurrenciesSingletonSpi
implements MonetaryCurrenciesSingletonSpi {
    DefaultMonetaryCurrenciesSingletonSpi() {
    }

    @Override
    public Set<CurrencyUnit> getCurrencies(CurrencyQuery query) {
        HashSet<CurrencyUnit> result = new HashSet<CurrencyUnit>();
        for (CurrencyProviderSpi spi : Bootstrap.getServices(CurrencyProviderSpi.class)) {
            try {
                result.addAll(spi.getCurrencies(query));
            }
            catch (Exception e) {
                Logger.getLogger(DefaultMonetaryCurrenciesSingletonSpi.class.getName()).log(Level.SEVERE, "Error loading currency provider names for " + spi.getClass().getName(), e);
            }
        }
        return result;
    }

    @Override
    public List<String> getDefaultProviderChain() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.getProviderNames());
        Collections.sort(list);
        return list;
    }

    @Override
    public Set<String> getProviderNames() {
        HashSet<String> result = new HashSet<String>();
        for (CurrencyProviderSpi spi : Bootstrap.getServices(CurrencyProviderSpi.class)) {
            try {
                result.add(spi.getProviderName());
            }
            catch (Exception e) {
                Logger.getLogger(DefaultMonetaryCurrenciesSingletonSpi.class.getName()).log(Level.SEVERE, "Error loading currency provider names for " + spi.getClass().getName(), e);
            }
        }
        return result;
    }
}

