/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.services.impl.definitions;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.PluginType;
import org.apache.unomi.api.PropertyMergeStrategyType;
import org.apache.unomi.api.ValueType;
import org.apache.unomi.api.actions.ActionType;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.conditions.ConditionType;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.api.services.SchedulerService;
import org.apache.unomi.persistence.spi.CustomObjectMapper;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.apache.unomi.services.impl.ParserHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefinitionsServiceImpl
implements DefinitionsService,
SynchronousBundleListener {
    private static final Logger logger = LoggerFactory.getLogger((String)DefinitionsServiceImpl.class.getName());
    private PersistenceService persistenceService;
    private SchedulerService schedulerService;
    private Map<String, ConditionType> conditionTypeById = new ConcurrentHashMap<String, ConditionType>();
    private Map<String, ActionType> actionTypeById = new ConcurrentHashMap<String, ActionType>();
    private Map<String, ValueType> valueTypeById = new HashMap<String, ValueType>();
    private Map<String, Set<ValueType>> valueTypeByTag = new HashMap<String, Set<ValueType>>();
    private Map<Long, List<PluginType>> pluginTypes = new HashMap<Long, List<PluginType>>();
    private Map<String, PropertyMergeStrategyType> propertyMergeStrategyTypeById = new HashMap<String, PropertyMergeStrategyType>();
    private long definitionsRefreshInterval = 10000L;
    private BundleContext bundleContext;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public void setDefinitionsRefreshInterval(long definitionsRefreshInterval) {
        this.definitionsRefreshInterval = definitionsRefreshInterval;
    }

    public void postConstruct() {
        logger.debug("postConstruct {" + this.bundleContext.getBundle() + "}");
        this.processBundleStartup(this.bundleContext);
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (bundle.getBundleContext() == null || bundle.getBundleId() == this.bundleContext.getBundle().getBundleId()) continue;
            this.processBundleStartup(bundle.getBundleContext());
        }
        this.bundleContext.addBundleListener((BundleListener)this);
        this.scheduleTypeReloads();
        logger.info("Definitions service initialized.");
    }

    private void scheduleTypeReloads() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                DefinitionsServiceImpl.this.reloadTypes(false);
            }
        };
        this.schedulerService.getScheduleExecutorService().scheduleAtFixedRate(task, 10000L, this.definitionsRefreshInterval, TimeUnit.MILLISECONDS);
        logger.info("Scheduled task for condition type loading each 10s");
    }

    public void reloadTypes(boolean refresh) {
        try {
            if (refresh) {
                this.persistenceService.refresh();
            }
            this.loadConditionTypesFromPersistence();
            this.loadActionTypesFromPersistence();
        }
        catch (Throwable t) {
            logger.error("Error loading definitions from persistence back-end", t);
        }
    }

    private void loadConditionTypesFromPersistence() {
        try {
            ConcurrentHashMap<String, ConditionType> newConditionTypesById = new ConcurrentHashMap<String, ConditionType>();
            for (ConditionType conditionType : this.getAllConditionTypes()) {
                newConditionTypesById.put(conditionType.getItemId(), conditionType);
            }
            this.conditionTypeById = newConditionTypesById;
        }
        catch (Exception e) {
            logger.error("Error loading condition types from persistence service", (Throwable)e);
        }
    }

    private void loadActionTypesFromPersistence() {
        try {
            ConcurrentHashMap<String, ActionType> newActionTypesById = new ConcurrentHashMap<String, ActionType>();
            for (ActionType actionType : this.getAllActionTypes()) {
                newActionTypesById.put(actionType.getItemId(), actionType);
            }
            this.actionTypeById = newActionTypesById;
        }
        catch (Exception e) {
            logger.error("Error loading action types from persistence service", (Throwable)e);
        }
    }

    private void processBundleStartup(BundleContext bundleContext) {
        if (bundleContext == null) {
            return;
        }
        this.pluginTypes.put(bundleContext.getBundle().getBundleId(), new ArrayList());
        this.loadPredefinedConditionTypes(bundleContext);
        this.loadPredefinedActionTypes(bundleContext);
        this.loadPredefinedValueTypes(bundleContext);
        this.loadPredefinedPropertyMergeStrategies(bundleContext);
    }

    private void processBundleStop(BundleContext bundleContext) {
        if (bundleContext == null) {
            return;
        }
        List<PluginType> types = this.pluginTypes.get(bundleContext.getBundle().getBundleId());
        if (types != null) {
            for (PluginType type : types) {
                if (!(type instanceof ValueType)) continue;
                ValueType valueType = (ValueType)type;
                this.valueTypeById.remove(valueType.getId());
                for (String tag : valueType.getTags()) {
                    if (!this.valueTypeByTag.containsKey(tag)) continue;
                    this.valueTypeByTag.get(tag).remove(valueType);
                }
            }
        }
    }

    public void preDestroy() {
        this.bundleContext.removeBundleListener((BundleListener)this);
        logger.info("Definitions service shutdown.");
    }

    private void loadPredefinedConditionTypes(BundleContext bundleContext) {
        Enumeration predefinedConditionEntries = bundleContext.getBundle().findEntries("META-INF/cxs/conditions", "*.json", true);
        if (predefinedConditionEntries == null) {
            return;
        }
        while (predefinedConditionEntries.hasMoreElements()) {
            URL predefinedConditionURL = (URL)predefinedConditionEntries.nextElement();
            logger.debug("Found predefined condition at " + predefinedConditionURL + ", loading... ");
            try {
                ConditionType conditionType = (ConditionType)CustomObjectMapper.getObjectMapper().readValue(predefinedConditionURL, ConditionType.class);
                if (this.getConditionType(conditionType.getMetadata().getId()) == null) {
                    this.setConditionType(conditionType);
                    logger.info("Predefined condition type with id {} registered", (Object)conditionType.getMetadata().getId());
                    continue;
                }
                logger.info("The predefined condition type with id {} is already registered, this condition type will be skipped", (Object)conditionType.getMetadata().getId());
            }
            catch (IOException e) {
                logger.error("Error while loading condition definition " + predefinedConditionURL, (Throwable)e);
            }
        }
    }

    private void loadPredefinedActionTypes(BundleContext bundleContext) {
        Enumeration predefinedActionsEntries = bundleContext.getBundle().findEntries("META-INF/cxs/actions", "*.json", true);
        if (predefinedActionsEntries == null) {
            return;
        }
        ArrayList pluginTypeArrayList = (ArrayList)this.pluginTypes.get(bundleContext.getBundle().getBundleId());
        while (predefinedActionsEntries.hasMoreElements()) {
            URL predefinedActionURL = (URL)predefinedActionsEntries.nextElement();
            logger.debug("Found predefined action at " + predefinedActionURL + ", loading... ");
            try {
                ActionType actionType = (ActionType)CustomObjectMapper.getObjectMapper().readValue(predefinedActionURL, ActionType.class);
                if (this.getActionType(actionType.getMetadata().getId()) == null) {
                    this.setActionType(actionType);
                    logger.info("Predefined action type with id {} registered", (Object)actionType.getMetadata().getId());
                    continue;
                }
                logger.info("The predefined action type with id {} is already registered, this action type will be skipped", (Object)actionType.getMetadata().getId());
            }
            catch (Exception e) {
                logger.error("Error while loading action definition " + predefinedActionURL, (Throwable)e);
            }
        }
    }

    private void loadPredefinedValueTypes(BundleContext bundleContext) {
        Enumeration predefinedPropertiesEntries = bundleContext.getBundle().findEntries("META-INF/cxs/values", "*.json", true);
        if (predefinedPropertiesEntries == null) {
            return;
        }
        ArrayList pluginTypeArrayList = (ArrayList)this.pluginTypes.get(bundleContext.getBundle().getBundleId());
        while (predefinedPropertiesEntries.hasMoreElements()) {
            URL predefinedPropertyURL = (URL)predefinedPropertiesEntries.nextElement();
            logger.debug("Found predefined value type at " + predefinedPropertyURL + ", loading... ");
            try {
                ValueType valueType = (ValueType)CustomObjectMapper.getObjectMapper().readValue(predefinedPropertyURL, ValueType.class);
                valueType.setPluginId(bundleContext.getBundle().getBundleId());
                this.valueTypeById.put(valueType.getId(), valueType);
                pluginTypeArrayList.add(valueType);
                for (String tag : valueType.getTags()) {
                    if (tag != null) {
                        valueType.getTags().add(tag);
                        Set<ValueType> valueTypes = this.valueTypeByTag.get(tag);
                        if (valueTypes == null) {
                            valueTypes = new LinkedHashSet<ValueType>();
                        }
                        valueTypes.add(valueType);
                        this.valueTypeByTag.put(tag, valueTypes);
                        continue;
                    }
                    logger.warn("Unknown tag {} used in property type definition {}", (Object)tag, (Object)predefinedPropertyURL);
                }
            }
            catch (Exception e) {
                logger.error("Error while loading property type definition " + predefinedPropertyURL, (Throwable)e);
            }
        }
    }

    public Map<Long, List<PluginType>> getTypesByPlugin() {
        return this.pluginTypes;
    }

    public Collection<ConditionType> getAllConditionTypes() {
        List all = this.persistenceService.getAllItems(ConditionType.class);
        for (ConditionType type : all) {
            if (type == null || type.getParentCondition() == null) continue;
            ParserHelper.resolveConditionType(this, type.getParentCondition(), "condition type " + type.getItemId());
        }
        return all;
    }

    public Set<ConditionType> getConditionTypesByTag(String tag) {
        return this.getConditionTypesBy("metadata.tags", tag);
    }

    public Set<ConditionType> getConditionTypesBySystemTag(String tag) {
        return this.getConditionTypesBy("metadata.systemTags", tag);
    }

    private Set<ConditionType> getConditionTypesBy(String fieldName, String fieldValue) {
        LinkedHashSet<ConditionType> conditionTypes = new LinkedHashSet<ConditionType>();
        List directConditionTypes = this.persistenceService.query(fieldName, fieldValue, null, ConditionType.class);
        for (ConditionType type : directConditionTypes) {
            if (type.getParentCondition() == null) continue;
            ParserHelper.resolveConditionType(this, type.getParentCondition(), "condition type " + type.getItemId());
        }
        conditionTypes.addAll(directConditionTypes);
        return conditionTypes;
    }

    public ConditionType getConditionType(String id) {
        if (id == null) {
            return null;
        }
        ConditionType type = this.conditionTypeById.get(id);
        if ((type == null || type.getVersion() == null) && (type = (ConditionType)this.persistenceService.load(id, ConditionType.class)) != null) {
            this.conditionTypeById.put(id, type);
        }
        if (type != null && type.getParentCondition() != null) {
            ParserHelper.resolveConditionType(this, type.getParentCondition(), "condition type " + type.getItemId());
        }
        return type;
    }

    public void removeConditionType(String id) {
        this.persistenceService.remove(id, ConditionType.class);
        this.conditionTypeById.remove(id);
    }

    public void setConditionType(ConditionType conditionType) {
        this.conditionTypeById.put(conditionType.getMetadata().getId(), conditionType);
        this.persistenceService.save((Item)conditionType);
    }

    public Collection<ActionType> getAllActionTypes() {
        return this.persistenceService.getAllItems(ActionType.class);
    }

    public Set<ActionType> getActionTypeByTag(String tag) {
        return this.getActionTypesBy("metadata.tags", tag);
    }

    public Set<ActionType> getActionTypeBySystemTag(String tag) {
        return this.getActionTypesBy("metadata.systemTags", tag);
    }

    private Set<ActionType> getActionTypesBy(String fieldName, String fieldValue) {
        LinkedHashSet<ActionType> actionTypes = new LinkedHashSet<ActionType>();
        List directActionTypes = this.persistenceService.query(fieldName, fieldValue, null, ActionType.class);
        actionTypes.addAll(directActionTypes);
        return actionTypes;
    }

    public ActionType getActionType(String id) {
        ActionType type = this.actionTypeById.get(id);
        if ((type == null || type.getVersion() == null) && (type = (ActionType)this.persistenceService.load(id, ActionType.class)) != null) {
            this.actionTypeById.put(id, type);
        }
        return type;
    }

    public void removeActionType(String id) {
        this.persistenceService.remove(id, ActionType.class);
        this.actionTypeById.remove(id);
    }

    public void setActionType(ActionType actionType) {
        this.actionTypeById.put(actionType.getMetadata().getId(), actionType);
        this.persistenceService.save((Item)actionType);
    }

    public Collection<ValueType> getAllValueTypes() {
        return this.valueTypeById.values();
    }

    public Set<ValueType> getValueTypeByTag(String tag) {
        LinkedHashSet<ValueType> valueTypes = new LinkedHashSet<ValueType>();
        if (this.valueTypeByTag.containsKey(tag)) {
            valueTypes.addAll((Collection<ValueType>)this.valueTypeByTag.get(tag));
        }
        return valueTypes;
    }

    public ValueType getValueType(String id) {
        return this.valueTypeById.get(id);
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: {
                this.processBundleStartup(event.getBundle().getBundleContext());
                break;
            }
            case 256: {
                this.processBundleStop(event.getBundle().getBundleContext());
            }
        }
    }

    private void loadPredefinedPropertyMergeStrategies(BundleContext bundleContext) {
        Enumeration predefinedPropertyMergeStrategyEntries = bundleContext.getBundle().findEntries("META-INF/cxs/mergers", "*.json", true);
        if (predefinedPropertyMergeStrategyEntries == null) {
            return;
        }
        ArrayList pluginTypeArrayList = (ArrayList)this.pluginTypes.get(bundleContext.getBundle().getBundleId());
        while (predefinedPropertyMergeStrategyEntries.hasMoreElements()) {
            URL predefinedPropertyMergeStrategyURL = (URL)predefinedPropertyMergeStrategyEntries.nextElement();
            logger.debug("Found predefined property merge strategy type at " + predefinedPropertyMergeStrategyURL + ", loading... ");
            try {
                PropertyMergeStrategyType propertyMergeStrategyType = (PropertyMergeStrategyType)CustomObjectMapper.getObjectMapper().readValue(predefinedPropertyMergeStrategyURL, PropertyMergeStrategyType.class);
                propertyMergeStrategyType.setPluginId(bundleContext.getBundle().getBundleId());
                this.propertyMergeStrategyTypeById.put(propertyMergeStrategyType.getId(), propertyMergeStrategyType);
                pluginTypeArrayList.add(propertyMergeStrategyType);
            }
            catch (Exception e) {
                logger.error("Error while loading property type definition " + predefinedPropertyMergeStrategyURL, (Throwable)e);
            }
        }
    }

    public PropertyMergeStrategyType getPropertyMergeStrategyType(String id) {
        return this.propertyMergeStrategyTypeById.get(id);
    }

    public Set<Condition> extractConditionsByType(Condition rootCondition, String typeId) {
        if (rootCondition.containsParameter("subConditions")) {
            List subConditions = (List)rootCondition.getParameter("subConditions");
            HashSet<Condition> matchingConditions = new HashSet<Condition>();
            for (Condition condition : subConditions) {
                matchingConditions.addAll(this.extractConditionsByType(condition, typeId));
            }
            return matchingConditions;
        }
        if (rootCondition.getConditionTypeId() != null && rootCondition.getConditionTypeId().equals(typeId)) {
            return Collections.singleton(rootCondition);
        }
        return Collections.emptySet();
    }

    @Deprecated
    public Condition extractConditionByTag(Condition rootCondition, String tag) {
        if (rootCondition.containsParameter("subConditions")) {
            List subConditions = (List)rootCondition.getParameter("subConditions");
            ArrayList<Condition> matchingConditions = new ArrayList<Condition>();
            for (Condition condition : subConditions) {
                Condition c = this.extractConditionByTag(condition, tag);
                if (c == null) continue;
                matchingConditions.add(c);
            }
            if (matchingConditions.size() == 0) {
                return null;
            }
            if (matchingConditions.equals(subConditions)) {
                return rootCondition;
            }
            if (rootCondition.getConditionTypeId().equals("booleanCondition") && "and".equals(rootCondition.getParameter("operator"))) {
                if (matchingConditions.size() == 1) {
                    return (Condition)matchingConditions.get(0);
                }
                Condition res = new Condition();
                res.setConditionType(this.getConditionType("booleanCondition"));
                res.setParameter("operator", (Object)"and");
                res.setParameter("subConditions", matchingConditions);
                return res;
            }
            throw new IllegalArgumentException();
        }
        if (rootCondition.getConditionType() != null && rootCondition.getConditionType().getMetadata().getTags().contains(tag)) {
            return rootCondition;
        }
        return null;
    }

    public Condition extractConditionBySystemTag(Condition rootCondition, String systemTag) {
        if (rootCondition.containsParameter("subConditions")) {
            List subConditions = (List)rootCondition.getParameter("subConditions");
            ArrayList<Condition> matchingConditions = new ArrayList<Condition>();
            for (Condition condition : subConditions) {
                Condition c = this.extractConditionBySystemTag(condition, systemTag);
                if (c == null) continue;
                matchingConditions.add(c);
            }
            if (matchingConditions.size() == 0) {
                return null;
            }
            if (matchingConditions.equals(subConditions)) {
                return rootCondition;
            }
            if (rootCondition.getConditionTypeId().equals("booleanCondition") && "and".equals(rootCondition.getParameter("operator"))) {
                if (matchingConditions.size() == 1) {
                    return (Condition)matchingConditions.get(0);
                }
                Condition res = new Condition();
                res.setConditionType(this.getConditionType("booleanCondition"));
                res.setParameter("operator", (Object)"and");
                res.setParameter("subConditions", matchingConditions);
                return res;
            }
            throw new IllegalArgumentException();
        }
        if (rootCondition.getConditionType() != null && rootCondition.getConditionType().getMetadata().getSystemTags().contains(systemTag)) {
            return rootCondition;
        }
        return null;
    }

    public boolean resolveConditionType(Condition rootCondition) {
        return ParserHelper.resolveConditionType(this, rootCondition, rootCondition != null ? "condition type " + rootCondition.getConditionTypeId() : "unknown");
    }

    public void refresh() {
        this.reloadTypes(true);
    }
}

