/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.io.IOException;
import java.nio.file.Path;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cluster.coordination.CoordinationMetaData;
import org.elasticsearch.cluster.coordination.ElasticsearchNodeCommand;
import org.elasticsearch.cluster.metadata.Manifest;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.env.Environment;

public class DetachClusterCommand
extends ElasticsearchNodeCommand {
    static final String NODE_DETACHED_MSG = "Node was successfully detached from the cluster";
    static final String CONFIRMATION_MSG = "------------------------------------------------------------------------\n\nYou should only run this tool if you have permanently lost all of the\nmaster-eligible nodes in this cluster and you cannot restore the cluster\nfrom a snapshot, or you have already unsafely bootstrapped a new cluster\nby running `elasticsearch-node unsafe-bootstrap` on a master-eligible\nnode that belonged to the same cluster as this node. This tool can cause\narbitrary data loss and its use should be your last resort.\n\nDo you want to proceed?\n";

    public DetachClusterCommand() {
        super("Detaches this node from its cluster, allowing it to unsafely join a new cluster");
    }

    @Override
    protected void processNodePaths(Terminal terminal, Path[] dataPaths, Environment env) throws IOException {
        Tuple<Manifest, MetaData> manifestMetaDataTuple = this.loadMetaData(terminal, dataPaths);
        Manifest manifest = manifestMetaDataTuple.v1();
        MetaData metaData = manifestMetaDataTuple.v2();
        this.confirm(terminal, CONFIRMATION_MSG);
        this.writeNewMetaData(terminal, manifest, DetachClusterCommand.updateCurrentTerm(), metaData, DetachClusterCommand.updateMetaData(metaData), dataPaths);
        terminal.println(NODE_DETACHED_MSG);
    }

    static MetaData updateMetaData(MetaData oldMetaData) {
        CoordinationMetaData coordinationMetaData = CoordinationMetaData.builder().lastAcceptedConfiguration(CoordinationMetaData.VotingConfiguration.MUST_JOIN_ELECTED_MASTER).lastCommittedConfiguration(CoordinationMetaData.VotingConfiguration.MUST_JOIN_ELECTED_MASTER).term(0L).build();
        return MetaData.builder(oldMetaData).coordinationMetaData(coordinationMetaData).clusterUUIDCommitted(false).build();
    }

    static long updateCurrentTerm() {
        return 0L;
    }
}

