/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.rest.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.unomi.api.ContextRequest;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.services.PersonalizationService;
import org.apache.unomi.rest.exception.InvalidRequestException;
import org.apache.unomi.schema.api.SchemaService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextRequestDeserializer
extends StdDeserializer<ContextRequest> {
    private static final Logger logger = LoggerFactory.getLogger(ContextRequestDeserializer.class);
    private final SchemaService schemaService;

    public ContextRequestDeserializer(SchemaService schemaRegistry) {
        this(null, schemaRegistry);
    }

    public ContextRequestDeserializer(Class<ContextRequest> vc, SchemaService schemaRegistry) {
        super(vc);
        this.schemaService = schemaRegistry;
    }

    public ContextRequest deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        JsonNode personalizationsNode;
        JsonNode filtersNode;
        JsonNode eventsNode;
        JsonNode requiredSessionPropertiesNode;
        JsonNode requiredProfileProperties;
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        if (!this.schemaService.isValid(node.toString(), "https://unomi.apache.org/schemas/json/rest/requestIds/1-0-0")) {
            throw new InvalidRequestException("Invalid Context request object", "Invalid received data");
        }
        ContextRequest cr = new ContextRequest();
        if (node.get("source") != null) {
            cr.setSource((Item)jsonParser.getCodec().treeToValue((TreeNode)node.get("source"), Item.class));
        }
        if (node.get("requireSegments") != null) {
            cr.setRequireSegments(node.get("requireSegments").booleanValue());
        }
        if ((requiredProfileProperties = node.get("requiredProfileProperties")) instanceof ArrayNode) {
            ArrayList profileProperties = new ArrayList();
            requiredProfileProperties.elements().forEachRemaining(el -> profileProperties.add(el.textValue()));
            cr.setRequiredProfileProperties(profileProperties);
        }
        if ((requiredSessionPropertiesNode = node.get("requiredSessionProperties")) instanceof ArrayNode) {
            ArrayList requiredSessionProperties = new ArrayList();
            requiredSessionPropertiesNode.elements().forEachRemaining(el -> requiredSessionProperties.add(el.textValue()));
            cr.setRequiredSessionProperties(requiredSessionProperties);
        }
        if (node.get("requireScores") != null) {
            cr.setRequireScores(node.get("requireScores").booleanValue());
        }
        if ((eventsNode = node.get("events")) instanceof ArrayNode) {
            ArrayNode events = (ArrayNode)eventsNode;
            ArrayList<Event> filteredEvents = new ArrayList<Event>();
            for (JsonNode event : events) {
                if (this.schemaService.isEventValid(event.toString())) {
                    filteredEvents.add((Event)jsonParser.getCodec().treeToValue((TreeNode)event, Event.class));
                    continue;
                }
                logger.error("An event was rejected - switch to DEBUG log level for more information");
            }
            cr.setEvents(filteredEvents);
        }
        if ((filtersNode = node.get("filters")) instanceof ArrayNode) {
            ArrayNode filters = (ArrayNode)filtersNode;
            ArrayList f = new ArrayList();
            filters.elements().forEachRemaining(el -> {
                try {
                    f.add((PersonalizationService.PersonalizedContent)jsonParser.getCodec().treeToValue((TreeNode)el, PersonalizationService.PersonalizedContent.class));
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
            });
            cr.setFilters(f);
        }
        if ((personalizationsNode = node.get("personalizations")) instanceof ArrayNode) {
            ArrayNode personalizations = (ArrayNode)personalizationsNode;
            ArrayList p = new ArrayList();
            personalizations.elements().forEachRemaining(el -> {
                try {
                    p.add((PersonalizationService.PersonalizationRequest)jsonParser.getCodec().treeToValue((TreeNode)el, PersonalizationService.PersonalizationRequest.class));
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
            });
            cr.setPersonalizations(p);
        }
        if (node.get("profileOverrides") != null) {
            cr.setProfileOverrides((Profile)jsonParser.getCodec().treeToValue((TreeNode)node.get("profileOverrides"), Profile.class));
        }
        if (node.get("sessionPropertiesOverrides") != null) {
            cr.setSessionPropertiesOverrides((Map)jsonParser.getCodec().treeToValue((TreeNode)node.get("sessionPropertiesOverrides"), Map.class));
        }
        if (node.get("sessionId") != null) {
            cr.setSessionId(node.get("sessionId").textValue());
        }
        if (node.get("profileId") != null) {
            cr.setProfileId(node.get("profileId").textValue());
        }
        if (node.get("clientId") != null) {
            cr.setClientId(node.get("clientId").textValue());
        }
        return cr;
    }
}

