/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta;

import java.util.Locale;
import java.util.Objects;
import javax.money.CurrencyContext;
import javax.money.CurrencyContextBuilder;
import javax.money.CurrencyUnit;
import org.javamoney.moneta.BuildableCurrencyUnit;
import org.javamoney.moneta.internal.ConfigurableCurrencyUnitProvider;

public final class CurrencyUnitBuilder {
    String currencyCode;
    int numericCode = -1;
    int defaultFractionDigits = 2;
    CurrencyContext currencyContext;

    private CurrencyUnitBuilder() {
    }

    public static CurrencyUnitBuilder of(String currencyCode, CurrencyContext currencyContext) {
        return new CurrencyUnitBuilder(currencyCode, currencyContext);
    }

    public static CurrencyUnitBuilder of(String currencyCode, String providerName) {
        return new CurrencyUnitBuilder(currencyCode, CurrencyContextBuilder.of((String)providerName).build());
    }

    private CurrencyUnitBuilder(String currencyCode, CurrencyContext currencyContext) {
        Objects.requireNonNull(currencyCode, "currencyCode required");
        this.currencyCode = currencyCode;
        Objects.requireNonNull(currencyContext, "currencyContext required");
        this.currencyContext = currencyContext;
    }

    public CurrencyUnitBuilder setCurrencyCode(String currencyCode) {
        Objects.requireNonNull(currencyCode, "currencyCode required");
        this.currencyCode = currencyCode;
        this.currencyContext = CurrencyContextBuilder.of((String)this.getClass().getSimpleName()).build();
        return this;
    }

    public CurrencyUnitBuilder setNumericCode(int numericCode) {
        if (numericCode < -1) {
            throw new IllegalArgumentException("numericCode must be >= -1");
        }
        this.numericCode = numericCode;
        return this;
    }

    public CurrencyUnitBuilder setDefaultFractionDigits(int defaultFractionDigits) {
        if (defaultFractionDigits < 0) {
            throw new IllegalArgumentException("defaultFractionDigits must be >= 0");
        }
        this.defaultFractionDigits = defaultFractionDigits;
        return this;
    }

    public CurrencyUnit build() {
        return this.build(false);
    }

    public CurrencyUnit build(boolean register) {
        BuildableCurrencyUnit cu = new BuildableCurrencyUnit(this);
        if (register) {
            ConfigurableCurrencyUnitProvider.registerCurrencyUnit(cu);
        }
        return cu;
    }

    public CurrencyUnit build(boolean register, Locale locale) {
        BuildableCurrencyUnit cu = new BuildableCurrencyUnit(this);
        if (register) {
            ConfigurableCurrencyUnitProvider.registerCurrencyUnit(cu);
            ConfigurableCurrencyUnitProvider.registerCurrencyUnit(cu, locale);
        }
        return cu;
    }
}

