/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.services.impl.topics;

import org.apache.unomi.api.Item;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.Topic;
import org.apache.unomi.api.query.Query;
import org.apache.unomi.api.services.TopicService;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

public class TopicServiceImpl
implements TopicService,
SynchronousBundleListener {
    private PersistenceService persistenceService;
    private BundleContext bundleContext;

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public Topic load(String topicId) {
        return (Topic)this.persistenceService.load(topicId, Topic.class);
    }

    public Topic save(Topic topic) {
        if (this.persistenceService.save((Item)topic)) {
            this.persistenceService.refreshIndex(Topic.class, null);
            return topic;
        }
        return null;
    }

    public PartialList<Topic> search(Query query) {
        return this.persistenceService.query(query.getCondition(), query.getSortby(), Topic.class, query.getOffset(), query.getLimit());
    }

    public boolean delete(String topicId) {
        return this.persistenceService.remove(topicId, Topic.class);
    }

    public void bundleChanged(BundleEvent bundleEvent) {
    }

    public void postConstruct() {
        this.bundleContext.addBundleListener((BundleListener)this);
    }

    public void preDestroy() {
        this.bundleContext.removeBundleListener((BundleListener)this);
    }
}

