/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.persistence.spi;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.expression.DefaultResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)PropertyHelper.class.getName());
    private static DefaultResolver resolver = new DefaultResolver();

    public static boolean setProperty(Object target, String propertyName, Object propertyValue, String setPropertyStrategy) {
        try {
            List<Object> previousValueList;
            if (setPropertyStrategy != null && setPropertyStrategy.equals("remove")) {
                if (resolver.hasNested(propertyName)) {
                    String parentPropertyName = propertyName.substring(0, propertyName.lastIndexOf(46));
                    try {
                        Object parentPropertyValue = PropertyUtils.getNestedProperty((Object)target, (String)parentPropertyName);
                        if (parentPropertyValue instanceof HashMap) {
                            if (((HashMap)parentPropertyValue).keySet().contains(propertyName.substring(propertyName.lastIndexOf(46) + 1))) {
                                ((HashMap)parentPropertyValue).remove(propertyName.substring(propertyName.lastIndexOf(46) + 1));
                                PropertyUtils.setNestedProperty(target, (String)parentPropertyName, (Object)parentPropertyValue);
                                return true;
                            }
                            return false;
                        }
                    }
                    catch (NestedNullException ex) {
                        return false;
                    }
                }
                return false;
            }
            if (propertyValue == null) {
                return false;
            }
            while (resolver.hasNested(propertyName)) {
                LinkedHashMap v = PropertyUtils.getProperty((Object)target, (String)resolver.next(propertyName));
                if (v == null) {
                    v = new LinkedHashMap();
                    PropertyUtils.setProperty(target, (String)resolver.next(propertyName), v);
                }
                propertyName = resolver.remove(propertyName);
                target = v;
            }
            Object previousValue = PropertyUtils.getProperty((Object)target, (String)propertyName);
            if (setPropertyStrategy == null || setPropertyStrategy.equals("alwaysSet") || setPropertyStrategy.equals("setIfMissing") && previousValue == null) {
                if (!PropertyHelper.compareValues(propertyValue, previousValue)) {
                    BeanUtils.setProperty(target, (String)propertyName, (Object)propertyValue);
                    return true;
                }
            } else if (setPropertyStrategy.equals("addValue") || setPropertyStrategy.equals("addValues")) {
                List<Object> newValuesList = PropertyHelper.convertToList(propertyValue);
                List<Object> previousValueList2 = PropertyHelper.convertToList(previousValue);
                newValuesList.addAll(previousValueList2);
                HashSet<Object> newValuesSet = new HashSet<Object>(newValuesList);
                if (newValuesSet.size() != previousValueList2.size()) {
                    BeanUtils.setProperty(target, (String)propertyName, Arrays.asList(newValuesSet.toArray()));
                    return true;
                }
            } else if ((setPropertyStrategy.equals("removeValue") || setPropertyStrategy.equals("removeValues")) && (previousValueList = PropertyHelper.convertToList(previousValue)).removeAll(PropertyHelper.convertToList(propertyValue))) {
                BeanUtils.setProperty(target, (String)propertyName, previousValueList);
                return true;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error("Cannot set property", (Throwable)e);
        }
        return false;
    }

    public static List<Object> convertToList(Object value) {
        ArrayList<Object> convertedList = new ArrayList<Object>();
        if (value != null && value instanceof List) {
            convertedList.addAll((List)value);
        } else if (value != null) {
            convertedList.add(value);
        }
        return convertedList;
    }

    public static Integer getInteger(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Long getLong(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        try {
            return Long.parseLong(value.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Double getDouble(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        try {
            return Double.parseDouble(value.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Boolean getBooleanValue(Object setPropertyValueBoolean) {
        if (setPropertyValueBoolean instanceof Boolean) {
            return (Boolean)setPropertyValueBoolean;
        }
        if (setPropertyValueBoolean instanceof Number) {
            if (((Number)setPropertyValueBoolean).intValue() >= 1) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (((String)setPropertyValueBoolean).equalsIgnoreCase("true") || ((String)setPropertyValueBoolean).equalsIgnoreCase("on") || ((String)setPropertyValueBoolean).equalsIgnoreCase("yes") || ((String)setPropertyValueBoolean).equalsIgnoreCase("1")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Object getValueByTypeId(Object propertyValue, String valueTypeId) {
        if ("boolean".equals(valueTypeId)) {
            return PropertyHelper.getBooleanValue(propertyValue);
        }
        if ("integer".equals(valueTypeId)) {
            return PropertyHelper.getInteger(propertyValue);
        }
        return propertyValue;
    }

    public static boolean compareValues(Object propertyValue, Object beanPropertyValue) {
        if (propertyValue == null) {
            return true;
        }
        if (beanPropertyValue == null) {
            return false;
        }
        if (propertyValue instanceof Integer) {
            return propertyValue.equals(PropertyHelper.getInteger(beanPropertyValue));
        }
        if (propertyValue instanceof Long) {
            return propertyValue.equals(PropertyHelper.getLong(beanPropertyValue));
        }
        if (propertyValue instanceof Boolean) {
            return propertyValue.equals(PropertyHelper.getBooleanValue(beanPropertyValue));
        }
        return propertyValue.equals(beanPropertyValue);
    }

    public static Map<String, Object> flatten(Map<String, Object> in) {
        return in.entrySet().stream().filter(entry -> entry.getValue() != null).flatMap(entry -> PropertyHelper.flatten(entry).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Map<String, Object> flatten(Map.Entry<String, Object> in) {
        if (!Map.class.isInstance(in.getValue())) {
            return Collections.singletonMap(in.getKey(), in.getValue());
        }
        String prefix = in.getKey();
        Map values = (Map)in.getValue();
        HashMap<String, Object> flattenMap = new HashMap<String, Object>();
        values.keySet().forEach(key -> flattenMap.put(prefix + "." + key, values.get(key)));
        return PropertyHelper.flatten(flattenMap);
    }
}

