/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.DateDecayFunction;
import co.elastic.clients.elasticsearch._types.query_dsl.DecayFunctionVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.FunctionScore;
import co.elastic.clients.elasticsearch._types.query_dsl.FunctionScoreVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.GeoDecayFunction;
import co.elastic.clients.elasticsearch._types.query_dsl.NumericDecayFunction;
import co.elastic.clients.elasticsearch._types.query_dsl.UntypedDecayFunction;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.UnionDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class DecayFunction
implements TaggedUnion<Kind, DecayFunctionVariant>,
FunctionScoreVariant,
JsonpSerializable {
    private final Kind _kind;
    private final DecayFunctionVariant _value;
    public static final JsonpDeserializer<DecayFunction> _DESERIALIZER = JsonpDeserializer.lazy(DecayFunction::buildDecayFunctionDeserializer);

    @Override
    public FunctionScore.Kind _functionScoreKind() {
        return FunctionScore.Kind.Linear;
    }

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final DecayFunctionVariant _get() {
        return this._value;
    }

    public DecayFunction(DecayFunctionVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._decayFunctionKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private DecayFunction(Kind kind, DecayFunctionVariant value) {
        this._kind = kind;
        this._value = value;
    }

    private DecayFunction(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static DecayFunction of(Function<Builder, ObjectBuilder<DecayFunction>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isDate() {
        return this._kind == Kind.Date;
    }

    public DateDecayFunction date() {
        return (DateDecayFunction)TaggedUnionUtils.get(this, Kind.Date);
    }

    public boolean isGeo() {
        return this._kind == Kind.Geo;
    }

    public GeoDecayFunction geo() {
        return (GeoDecayFunction)TaggedUnionUtils.get(this, Kind.Geo);
    }

    public boolean isNumeric() {
        return this._kind == Kind.Numeric;
    }

    public NumericDecayFunction numeric() {
        return (NumericDecayFunction)TaggedUnionUtils.get(this, Kind.Numeric);
    }

    public boolean isUntyped() {
        return this._kind == Kind.Untyped;
    }

    public UntypedDecayFunction untyped() {
        return (UntypedDecayFunction)TaggedUnionUtils.get(this, Kind.Untyped);
    }

    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        mapper.serialize((Object)this._value, generator);
    }

    public String toString() {
        return JsonpUtils.toString((JsonpSerializable)this);
    }

    private static JsonpDeserializer<DecayFunction> buildDecayFunctionDeserializer() {
        return new UnionDeserializer.Builder(DecayFunction::new, false).addMember((Object)Kind.Untyped, UntypedDecayFunction._DESERIALIZER).build();
    }

    public static enum Kind implements JsonEnum
    {
        Date("date"),
        Geo("geo"),
        Numeric("numeric"),
        Untyped("untyped");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        public String jsonValue() {
            return this.jsonValue;
        }
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<DecayFunction> {
        private Kind _kind;
        private DecayFunctionVariant _value;

        public ObjectBuilder<DecayFunction> date(DateDecayFunction v) {
            this._kind = Kind.Date;
            this._value = v;
            return this;
        }

        public ObjectBuilder<DecayFunction> date(Function<DateDecayFunction.Builder, ObjectBuilder<DateDecayFunction>> fn) {
            return this.date(fn.apply(new DateDecayFunction.Builder()).build());
        }

        public ObjectBuilder<DecayFunction> geo(GeoDecayFunction v) {
            this._kind = Kind.Geo;
            this._value = v;
            return this;
        }

        public ObjectBuilder<DecayFunction> geo(Function<GeoDecayFunction.Builder, ObjectBuilder<GeoDecayFunction>> fn) {
            return this.geo(fn.apply(new GeoDecayFunction.Builder()).build());
        }

        public ObjectBuilder<DecayFunction> numeric(NumericDecayFunction v) {
            this._kind = Kind.Numeric;
            this._value = v;
            return this;
        }

        public ObjectBuilder<DecayFunction> numeric(Function<NumericDecayFunction.Builder, ObjectBuilder<NumericDecayFunction>> fn) {
            return this.numeric(fn.apply(new NumericDecayFunction.Builder()).build());
        }

        public ObjectBuilder<DecayFunction> untyped(UntypedDecayFunction v) {
            this._kind = Kind.Untyped;
            this._value = v;
            return this;
        }

        public ObjectBuilder<DecayFunction> untyped(Function<UntypedDecayFunction.Builder, ObjectBuilder<UntypedDecayFunction>> fn) {
            return this.untyped(fn.apply(new UntypedDecayFunction.Builder()).build());
        }

        @Override
        public DecayFunction build() {
            this._checkSingleUse();
            return new DecayFunction(this);
        }
    }
}

