/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IOnChangeListener;
import org.apache.wicket.markup.html.form.Radio;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public class RadioGroup<T>
extends FormComponent<T>
implements IOnChangeListener {
    private static final long serialVersionUID = 1L;

    public RadioGroup(String id) {
        super(id);
        this.setRenderBodyOnly(true);
    }

    public RadioGroup(String id, IModel<T> model) {
        super(id, model);
        this.setRenderBodyOnly(true);
    }

    protected boolean wantOnSelectionChangedNotifications() {
        return false;
    }

    @Override
    protected boolean getStatelessHint() {
        if (this.wantOnSelectionChangedNotifications()) {
            return false;
        }
        return super.getStatelessHint();
    }

    @Override
    protected String getModelValue() {
        String radioValue = (String)this.visitChildren(Radio.class, new IVisitor<Radio<T>, String>(){

            public void component(Radio<T> radio, IVisit<String> visit) {
                if (RadioGroup.this.getModelComparator().compare(RadioGroup.this, radio.getDefaultModelObject())) {
                    visit.stop((Object)radio.getValue());
                }
            }
        });
        return radioValue;
    }

    @Override
    protected T convertValue(String[] input) throws ConversionException {
        if (input != null && input.length > 0) {
            final String value = input[0];
            Radio choice = (Radio)this.visitChildren(Radio.class, new IVisitor<Radio<T>, Radio<T>>(){

                public void component(Radio<T> radio, IVisit<Radio<T>> visit) {
                    if (radio.getValue().equals(value)) {
                        visit.stop(radio);
                    }
                }
            });
            if (choice == null) {
                throw new WicketRuntimeException("submitted http post value [" + value + "] for RadioGroup component [" + this.getPath() + "] is illegal because it does not point to a Radio component. " + "Due to this the RadioGroup component cannot resolve the selected Radio component pointed to by the illegal value. A possible reason is that component hierarchy changed between rendering and form submission.");
            }
            return choice.getModelObject();
        }
        return null;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.remove("disabled");
        tag.remove("name");
    }

    @Override
    public final void onSelectionChanged() {
        this.convertInput();
        this.updateModel();
        this.onSelectionChanged(this.getModelObject());
    }

    protected void onSelectionChanged(T newSelection) {
    }
}

