/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.Cookie;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.IMetaDataBufferingWebResponse;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.response.filter.IResponseFilter;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.time.Time;

public class BufferedWebResponse
extends WebResponse
implements IMetaDataBufferingWebResponse {
    private final WebResponse originalResponse;
    private final List<Action> actions = new ArrayList<Action>();
    private WriteCharSequenceAction charSequenceAction;
    private WriteDataAction dataAction;

    public BufferedWebResponse(WebResponse originalResponse) {
        if (originalResponse instanceof IMetaDataBufferingWebResponse) {
            ((IMetaDataBufferingWebResponse)originalResponse).writeMetaData(this);
        }
        this.originalResponse = originalResponse;
    }

    @Override
    public void writeMetaData(WebResponse response) {
        for (Action action : this.actions) {
            if (!(action instanceof MetaDataAction)) continue;
            action.invoke(response);
        }
    }

    public String encodeURL(CharSequence url) {
        if (this.originalResponse != null) {
            return this.originalResponse.encodeURL(url);
        }
        return url != null ? url.toString() : null;
    }

    public String encodeRedirectURL(CharSequence url) {
        if (this.originalResponse != null) {
            return this.originalResponse.encodeRedirectURL(url);
        }
        return url != null ? url.toString() : null;
    }

    public void reset() {
        super.reset();
        this.actions.clear();
        this.charSequenceAction = null;
        this.dataAction = null;
    }

    public void addCookie(Cookie cookie) {
        this.actions.add(new AddCookieAction(cookie));
    }

    public void clearCookie(Cookie cookie) {
        this.actions.add(new ClearCookieAction(cookie));
    }

    public void setContentLength(long length) {
        this.actions.add(new SetContentLengthAction(length));
    }

    public void setContentType(String mimeType) {
        this.actions.add(new SetContentTypeAction(mimeType));
    }

    public void setDateHeader(String name, Time date) {
        this.actions.add(new SetDateHeaderAction(name, date));
    }

    public void setHeader(String name, String value) {
        this.actions.add(new SetHeaderAction(name, value));
    }

    public void addHeader(String name, String value) {
        this.actions.add(new AddHeaderAction(name, value));
    }

    public void disableCaching() {
        this.actions.add(new DisableCachingAction());
    }

    public void write(CharSequence sequence) {
        if (this.dataAction != null) {
            throw new IllegalStateException("Can't call write(CharSequence) after write(byte[]) has been called.");
        }
        if (this.charSequenceAction == null) {
            this.charSequenceAction = new WriteCharSequenceAction();
            this.actions.add(this.charSequenceAction);
        }
        this.charSequenceAction.append(sequence);
    }

    public CharSequence getText() {
        if (this.dataAction != null) {
            throw new IllegalStateException("write(byte[]) has already been called.");
        }
        if (this.charSequenceAction != null) {
            return this.charSequenceAction.builder;
        }
        return null;
    }

    public void setText(CharSequence text) {
        if (this.dataAction != null) {
            throw new IllegalStateException("write(byte[]) has already been called.");
        }
        if (this.charSequenceAction != null) {
            this.charSequenceAction.builder.setLength(0);
        }
        this.write(text);
    }

    public void write(byte[] array) {
        if (this.charSequenceAction != null) {
            throw new IllegalStateException("Can't call write(byte[]) after write(CharSequence) has been called.");
        }
        if (this.dataAction == null) {
            this.dataAction = new WriteDataAction();
            this.actions.add(this.dataAction);
        }
        this.dataAction.append(array);
    }

    public void write(byte[] array, int offset, int length) {
        if (this.charSequenceAction != null) {
            throw new IllegalStateException("Can't call write(byte[]) after write(CharSequence) has been called.");
        }
        if (this.dataAction == null) {
            this.dataAction = new WriteDataAction();
            this.actions.add(this.dataAction);
        }
        this.dataAction.append(array, offset, length);
    }

    public void sendRedirect(String url) {
        this.actions.add(new SendRedirectAction(url));
    }

    public void setStatus(int sc) {
        this.actions.add(new SetStatusAction(sc));
    }

    public void sendError(int sc, String msg) {
        this.actions.add(new SendErrorAction(sc, msg));
    }

    public void writeTo(WebResponse response) {
        Args.notNull((Object)response, (String)"response");
        Collections.sort(this.actions);
        for (Action action : this.actions) {
            action.invoke(response);
        }
    }

    public boolean isRedirect() {
        for (Action action : this.actions) {
            if (!(action instanceof SendRedirectAction)) continue;
            return true;
        }
        return false;
    }

    public void flush() {
        this.actions.add(new FlushAction());
    }

    private static void writeStream(final Response response, ByteArrayOutputStream stream) {
        final boolean[] copied = new boolean[]{false};
        try {
            stream.writeTo(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    if (off == 0 && len == b.length) {
                        response.write(b);
                        copied[0] = true;
                    }
                }
            });
        }
        catch (IOException e1) {
            throw new WicketRuntimeException(e1);
        }
        if (!copied[0]) {
            response.write(stream.toByteArray());
        }
    }

    public String toString() {
        String toString = this.charSequenceAction != null ? this.charSequenceAction.builder.toString() : super.toString();
        return toString;
    }

    public Object getContainerResponse() {
        return this.originalResponse.getContainerResponse();
    }

    private static class FlushAction
    extends Action {
        private FlushAction() {
        }

        @Override
        protected void invoke(WebResponse response) {
            response.flush();
        }
    }

    private static class SendRedirectAction
    extends Action {
        private final String url;

        public SendRedirectAction(String url) {
            this.url = url;
        }

        @Override
        protected void invoke(WebResponse response) {
            response.sendRedirect(this.url);
        }
    }

    private static class SendErrorAction
    extends Action {
        private final int sc;
        private final String msg;

        public SendErrorAction(int sc, String msg) {
            this.sc = sc;
            this.msg = msg;
        }

        @Override
        protected void invoke(WebResponse response) {
            response.sendError(this.sc, this.msg);
        }
    }

    private static class DisableCachingAction
    extends MetaDataAction {
        private DisableCachingAction() {
        }

        @Override
        protected void invoke(WebResponse response) {
            response.disableCaching();
        }
    }

    private static class SetStatusAction
    extends MetaDataAction {
        private final int sc;

        public SetStatusAction(int sc) {
            this.sc = sc;
        }

        @Override
        protected void invoke(WebResponse response) {
            response.setStatus(this.sc);
        }
    }

    private static class SetContentTypeAction
    extends MetaDataAction {
        private final String contentType;

        public SetContentTypeAction(String contentType) {
            this.contentType = contentType;
        }

        @Override
        protected void invoke(WebResponse response) {
            response.setContentType(this.contentType);
        }
    }

    private static class SetContentLengthAction
    extends MetaDataAction {
        private final long contentLength;

        public SetContentLengthAction(long contentLength) {
            this.contentLength = contentLength;
        }

        @Override
        protected void invoke(WebResponse response) {
            response.setContentLength(this.contentLength);
        }
    }

    private static class SetDateHeaderAction
    extends MetaDataAction {
        private final String name;
        private final Time value;

        public SetDateHeaderAction(String name, Time value) {
            this.name = name;
            this.value = (Time)Args.notNull((Object)value, (String)"value");
        }

        @Override
        protected void invoke(WebResponse response) {
            response.setDateHeader(this.name, this.value);
        }
    }

    private static class AddHeaderAction
    extends MetaDataAction {
        private final String name;
        private final String value;

        public AddHeaderAction(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        protected void invoke(WebResponse response) {
            response.addHeader(this.name, this.value);
        }
    }

    private static class SetHeaderAction
    extends MetaDataAction {
        private final String name;
        private final String value;

        public SetHeaderAction(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        protected void invoke(WebResponse response) {
            response.setHeader(this.name, this.value);
        }
    }

    private static class ClearCookieAction
    extends MetaDataAction {
        private final Cookie cookie;

        public ClearCookieAction(Cookie cookie) {
            this.cookie = cookie;
        }

        @Override
        protected void invoke(WebResponse response) {
            response.clearCookie(this.cookie);
        }
    }

    private static class AddCookieAction
    extends MetaDataAction {
        private final Cookie cookie;

        public AddCookieAction(Cookie cookie) {
            this.cookie = cookie;
        }

        @Override
        protected void invoke(WebResponse response) {
            response.addCookie(this.cookie);
        }
    }

    private static class CloseAction
    extends Action {
        private CloseAction() {
        }

        @Override
        protected void invoke(WebResponse response) {
            response.close();
        }
    }

    private static class WriteDataAction
    extends Action {
        private final ByteArrayOutputStream stream = new ByteArrayOutputStream();

        public void append(byte[] data) {
            try {
                this.stream.write(data);
            }
            catch (IOException e) {
                throw new WicketRuntimeException(e);
            }
        }

        public void append(byte[] data, int offset, int length) {
            try {
                this.stream.write(data, offset, length);
            }
            catch (Exception e) {
                throw new WicketRuntimeException(e);
            }
        }

        @Override
        protected void invoke(WebResponse response) {
            BufferedWebResponse.writeStream((Response)response, this.stream);
        }

        @Override
        protected ActionType getType() {
            return ActionType.DATA;
        }
    }

    private static class WriteCharSequenceAction
    extends Action {
        private final StringBuilder builder = new StringBuilder(4096);

        public void append(CharSequence sequence) {
            this.builder.append(sequence);
        }

        @Override
        protected void invoke(WebResponse response) {
            AppendingStringBuffer responseBuffer = new AppendingStringBuffer((CharSequence)this.builder);
            List<IResponseFilter> responseFilters = Application.get().getRequestCycleSettings().getResponseFilters();
            if (responseFilters != null) {
                for (IResponseFilter filter : responseFilters) {
                    responseBuffer = filter.filter(responseBuffer);
                }
            }
            response.write((CharSequence)responseBuffer);
        }

        @Override
        protected ActionType getType() {
            return ActionType.DATA;
        }
    }

    private static abstract class MetaDataAction
    extends Action {
        private MetaDataAction() {
        }

        @Override
        protected ActionType getType() {
            return ActionType.HEADER;
        }
    }

    private static abstract class Action
    implements Comparable<Action> {
        private Action() {
        }

        protected abstract void invoke(WebResponse var1);

        protected ActionType getType() {
            return ActionType.NORMAL;
        }

        @Override
        public final int compareTo(Action o) {
            return this.getType().ordinal() - o.getType().ordinal();
        }
    }

    private static enum ActionType {
        HEADER,
        NORMAL,
        DATA;

    }
}

