/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.blob;

import java.io.IOException;
import java.io.InputStream;
import org.apache.axiom.blob.MemoryBlobChunk;

final class MemoryBlobInputStream
extends InputStream {
    private MemoryBlobChunk chunk;
    private int index;
    private MemoryBlobChunk markChunk;
    private int markIndex;

    MemoryBlobInputStream(MemoryBlobChunk firstChunk) {
        this.chunk = firstChunk;
    }

    private void updateChunk() {
        while (this.chunk != null && this.index == this.chunk.size) {
            this.chunk = this.chunk.nextChunk;
            this.index = 0;
        }
    }

    public int read(byte[] buffer, int off, int len) throws IOException {
        int read = 0;
        while (len > 0) {
            this.updateChunk();
            if (this.chunk == null) {
                if (read != 0) break;
                return -1;
            }
            int c = Math.min(len, this.chunk.size - this.index);
            System.arraycopy(this.chunk.buffer, this.index, buffer, off, c);
            this.index += c;
            off += c;
            len -= c;
            read += c;
        }
        return read;
    }

    public int read() throws IOException {
        this.updateChunk();
        if (this.chunk == null) {
            return -1;
        }
        return this.chunk.buffer[this.index++] & 0xFF;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized void mark(int readlimit) {
        this.markChunk = this.chunk;
        this.markIndex = this.index;
    }

    public synchronized void reset() throws IOException {
        this.chunk = this.markChunk;
        this.index = this.markIndex;
    }

    public long skip(long n) throws IOException {
        long skipped = 0L;
        while (n > 0L) {
            this.updateChunk();
            if (this.chunk == null) break;
            int c = (int)Math.min(n, (long)(this.chunk.size - this.index));
            this.index += c;
            skipped += (long)c;
            n -= (long)c;
        }
        return skipped;
    }

    public int available() throws IOException {
        if (this.chunk == null) {
            return 0;
        }
        long available = this.chunk.size - this.index;
        MemoryBlobChunk chunk = this.chunk.nextChunk;
        while (chunk != null) {
            if ((available += (long)chunk.size) > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            chunk = chunk.nextChunk;
        }
        return (int)available;
    }

    public void close() throws IOException {
        this.chunk = null;
    }
}

