/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common.serializer.push.sax;

import java.util.Stack;
import org.apache.axiom.util.namespace.ScopedNamespaceContext;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class SAXHelper {
    private Stack elementNameStack = new Stack();
    private String elementURI;
    private String elementLocalName;
    private String elementQName;
    private final AttributesImpl attributes = new AttributesImpl();

    SAXHelper() {
    }

    private static String getQName(String prefix, String localName) {
        if (prefix.length() == 0) {
            return localName;
        }
        return String.valueOf(prefix) + ":" + localName;
    }

    void beginStartElement(String prefix, String namespaceURI, String localName) {
        this.elementURI = namespaceURI;
        this.elementLocalName = localName;
        this.elementQName = SAXHelper.getQName(prefix, localName);
    }

    void addAttribute(String prefix, String namespaceURI, String localName, String type, String value) {
        this.attributes.addAttribute(namespaceURI, localName, SAXHelper.getQName(prefix, localName), type, value);
    }

    void finishStartElement(ContentHandler contentHandler) throws SAXException {
        contentHandler.startElement(this.elementURI, this.elementLocalName, this.elementQName, this.attributes);
        this.elementNameStack.push(this.elementURI);
        this.elementNameStack.push(this.elementLocalName);
        this.elementNameStack.push(this.elementQName);
        this.elementURI = null;
        this.elementLocalName = null;
        this.elementQName = null;
        this.attributes.clear();
    }

    boolean isInStartElement() {
        return this.elementLocalName != null;
    }

    void writeEndElement(ContentHandler contentHandler, ScopedNamespaceContext nsContext) throws SAXException {
        String elementQName = (String)this.elementNameStack.pop();
        String elementLocalName = (String)this.elementNameStack.pop();
        String elementURI = (String)this.elementNameStack.pop();
        contentHandler.endElement(elementURI, elementLocalName, elementQName);
        if (nsContext != null) {
            int i = nsContext.getBindingsCount() - 1;
            while (i >= nsContext.getFirstBindingInCurrentScope()) {
                contentHandler.endPrefixMapping(nsContext.getPrefix(i));
                --i;
            }
            nsContext.endScope();
        }
    }
}

