/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.stream.stax.pull;

import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.core.stream.CharacterData;
import org.apache.axiom.core.stream.CharacterDataSink;
import org.apache.axiom.core.stream.stax.pull.InternalXMLStreamReader;
import org.apache.axiom.ext.stax.CharacterDataReader;
import org.apache.axiom.util.base64.AbstractBase64EncodingOutputStream;
import org.apache.axiom.util.base64.Base64EncodingWriterOutputStream;

final class CharacterDataReaderImpl
implements CharacterDataReader {
    private final InternalXMLStreamReader reader;

    CharacterDataReaderImpl(InternalXMLStreamReader reader) {
        this.reader = reader;
    }

    @Override
    public void writeTextTo(final Writer writer) throws XMLStreamException, IOException {
        switch (this.reader.getEventType()) {
            case 4: {
                Object data = this.reader.getCharacterData();
                if (data instanceof CharacterData) {
                    ((CharacterData)data).writeTo(new CharacterDataSink(){

                        @Override
                        public Writer getWriter() {
                            return writer;
                        }

                        @Override
                        public AbstractBase64EncodingOutputStream getBase64EncodingOutputStream() {
                            return new Base64EncodingWriterOutputStream(writer);
                        }
                    });
                    break;
                }
                writer.write(data.toString());
                break;
            }
            case 5: 
            case 6: 
            case 12: {
                writer.write(this.reader.getText());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }
}

