Apache Axiom 1.2.9 Release Note
================================

Note: Starting with release 1.2.9, Axiom requires Java 1.5. While the API is
still compatible with Java 1.4, Axiom relies on classes from the Java 1.5
runtime environment. Some of its dependencies also require Java 1.5.

Highlights in this release:

*   Improved interoperability with StAX implementations other than Woodstox. Axiom now
    detects the StAX implementation that is used and works around interoperability issues.
    In particular, version 1.2.9 solves the longstanding concurrency issue that occurs
    when using Axiom with SJSXP.

*   Better control over XMLInputFactory and XMLOutputFactory settings. It is now possible
    to use property files to define application wide default settings for the StAX factories
    used by `StAXUtils`. It is also possible to specify a particular configuration when
    requesting a StAX parser from `StAXUtils`.

*   Improved XOP/MTOM handling. Axiom 1.2.9 is able to stream binary/base64 data in several
    situations where this was not possible previously. The behavior of Axiom 1.2.9 is also
    more consistent with respect to XOP encoded data sent to the application, solving
    some issues where attachments were processed incorrectly.

*   Improved documentation. There is now more and better Javadoc. Also, a user guide
    is available in HTML and as PDF.

*   Better OSGi support.

*   Improved consistency of the core interfaces. E.g. `OMDocument` now has a `build`
    method.

Resolved JIRA issues:

*   WSCOMMONS-547 apache-release profile not working
*   WSCOMMONS-546 axiom unit test failure in axiom-parser-tests
*   WSCOMMONS-545 Legal issue related to inclusion of Jaxen source code in Axiom
*   WSCOMMONS-541 Create replacement for UUIDGenerator
*   WSCOMMONS-540 CustomBuilder interface is not well defined for optimized binary data
*   WSCOMMONS-536 OMStAXWrapper generated illegal event code of 0
*   WSCOMMONS-535 StreamingOMSerializer drops "xml" prefixes
*   WSCOMMONS-534 "prefix cannot be null or empty" with SJSXP
*   WSCOMMONS-530 AXIOM DOM implementation of SOAPFaultDetailImpl only serializes the first child node whereas the LLOM implementation serializes all children
*   WSCOMMONS-528 Unable to build axiom-api with IBM JDK
*   WSCOMMONS-526 SOAPEnvelope toString() behavior inconsistant dependent on content
*   WSCOMMONS-518 Some consumers of Axiom need direct access to the orignal parser/XMLStreamReader
*   WSCOMMONS-516 Axiom Bundles are "named" the same, appear to be running twice in ServiceMix/Karaf
*   WSCOMMONS-513 Behavior of insertSiblingAfter and insertSiblingBefore is not well defined for orphan nodes
*   WSCOMMONS-505 Build Error when creating source jar fie on modules that do not have source directory
*   WSCOMMONS-502 Backward imcompatibility with Apache Abdera in Axiom 1.2.9-SNAPSHOT
*   WSCOMMONS-489 StAXUtils incorrectly assumes that XMLInputFactory and XMLOutputFactory instances are thread safe
*   WSCOMMONS-488 The sequence of events produced by OMStAXWrapper with inlineMTOM=false is inconsistent
*   WSCOMMONS-487 DataHandler extension should support deferred loading/parsing
*   WSCOMMONS-485 The sequence of events produced by OMStAXWrapper for XOP:Include is inconsistent
*   WSCOMMONS-483 provide help how to find a datahandler when you see "Cannot get InputStream from DataHandler.javax.activation.UnsupportedDataTypeException: no object DCH for MIME type ..."
*   WSCOMMONS-481 Add a method to OMFactory to create an OMSourcedElement using a QName
*   WSCOMMONS-480 Some of the serialize/serializeAndConsume methods are declared on the wrong interface
*   WSCOMMONS-479 OMDocument should have a "build" method
*   WSCOMMONS-478 OMChildrenIterator based on local name has bug in isEqual() method
*   WSCOMMONS-477 Attachment order is not preserved in Axiom
*   WSCOMMONS-462 axiom-api 1.2.8 is missing OSGi Import-Package to javax.xml.stream.util under JDK 1.5
*   WSCOMMONS-461 Allow StAXUtils to apply properties to XMLInputFactory and XMLOutputFactory
*   WSCOMMONS-457 Build fails on JDK 1.6
*   WSCOMMONS-452 Merge org.apache.axis2.format.ElementHelper into org.apache.axiom.om.util.ElementHelper
*   WSCOMMONS-446 Serializing an MTOM SOAPEnvelope inlines the attachments
*   WSCOMMONS-437 Define a common superinterface for SOAPFaultCode and SOAPFaultSubCode
*   WSCOMMONS-435 org.apache.axiom.om.impl.dom.ParentNode.removeChild(Node) is broken
*   WSCOMMONS-433 When inlining a DataHandler as Base64, OMTextImpl doesn't stream the data
*   WSCOMMONS-432 Make OMAbstractFactory work correctly in an OSGi runtime environment
*   WSCOMMONS-417 Clarify the status of the JavaMail dependency
*   WSCOMMONS-414 Namespace issue in SOAP message generated
*   WSCOMMONS-111 Careless exception handling needs to be fixed

Changes in this release
-----------------------

### System properties used by OMAbstractFactory

Prior to Axiom 1.2.9, `OMAbstractFactory` used system properties as defined in the following table
to determine the factory implementations to use:

Object model | Method               | System property  | Default
------------ | -------------------- | ---------------- | ---------------------------------------------------------------
Plain XML    | `getOMFactory()`     | `om.factory`     | `org.apache.axiom.om.impl.llom.factory.OMLinkedListImplFactory`
SOAP 1.1     | `getSOAP11Factory()` | `soap11.factory` | `org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory`
SOAP 1.2     | `getSOAP12Factory()` | `soap12.factory` | `org.apache.axiom.soap.impl.llom.soap12.SOAP12Factory`

This in principle allowed to mix default factory implementations from different implementations of
the Axiom API (e.g. an `OMFactory` from the LLOM implementation and SOAP factories from DOOM). This
however doesn't make sense. The system properties as described above are no longer supported in
1.2.9 and the default Axiom implementation is chosen using the new
`org.apache.axiom.om.OMMetaFactory` system property. For LLOM, you should set:

    org.apache.axiom.om.OMMetaFactory=org.apache.axiom.om.impl.llom.factory.OMLinkedListMetaFactory

This is the default and is equivalent to the defaults in 1.2.8. For DOOM, you should set:

    org.apache.axiom.om.OMMetaFactory=org.apache.axiom.om.impl.dom.factory.OMDOMMetaFactory

### Factories returned by StAXUtils

In versions prior to 1.2.9, the `XMLInputFactory` and `XMLOutputFactory` instances returned by
`StAXUtils` were mutable, i.e. it was possible to change the properties of these factories. This is
obviously an issue since the factory instances are cached and can be shared among several thread. To
avoid programming errors, starting from 1.2.9, the factories are immutable and any attempt to change
their state will result in an `IllegalStateException`.

Note that the possibility to change the properties of these factories could be used to apply
application wide settings. Starting with 1.2.9, Axiom has a proper mechanism to allow this.
This feature is described in the [user guide][1].

### Changes in XOP/MTOM handling

In Axiom 1.2.8, `XMLStreamReader` instances provided by Axiom could belong to one of three different
categories:

1.  `XMLStreamReader` instances delivering plain XML.

2.  `XMLStreamReader` instances delivering plain XML and implementing a custom extension to retrieve
    optimized binary data.

3.  `XMLStreamReader` instances representing XOP encoded data.

As explained in [AXIOM-255][2] and [AXIOM-122][3], in Axiom 1.2.8, the type of stream reader
provided by the API was not always well defined. Sometimes the type of the stream reader even
depended on the state of the Axiom tree (i.e. whether some part of it has been accessed or not).

In release 1.2.9 the behavior of Axiom was changed such that it never delivers XOP encoded data
unless explicitly requested to do so. By default, any `XMLStreamReader` provided by Axiom now
represents plain XML data and optionally implements the `DataHandlerReader` extension to retrieve
optimized binary data. An XOP encoded stream can be requested from the `getXOPEncodedStream` method
in `XOPUtils`.

[1]: ../userguide/ch04.html#factory.properties
[2]: https://issues.apache.org/jira/browse/AXIOM-255
[3]: https://issues.apache.org/jira/browse/AXIOM-122
