/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.ds.custombuilder;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.ds.ByteArrayDataSource;
import org.apache.axiom.om.ds.custombuilder.CustomBuilder;

public class ByteArrayCustomBuilder
implements CustomBuilder {
    private String encoding = null;

    public ByteArrayCustomBuilder(String encoding) {
        this.encoding = encoding == null ? "utf-8" : encoding;
    }

    public OMDataSource create(OMElement element) throws OMException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            element.serializeAndConsume((OutputStream)baos);
            byte[] bytes = baos.toByteArray();
            return new ByteArrayDataSource(bytes, this.encoding);
        }
        catch (XMLStreamException e) {
            throw new OMException((Throwable)e);
        }
        catch (OMException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new OMException(t);
        }
    }
}

