
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  First use setAttribute to create two new attribute of the second and third strong element with different values.
 *  Invoke setIdAttribute on the new  attributes. Verify by calling isID on the new attributes and getElementById 
 *  with two different values on document. 
* @author IBM
* @author Jenny Hsu
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-ElSetIdAttr">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-ElSetIdAttr</a>
*/
public final class elementsetidattribute07 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public elementsetidattribute07(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      NodeList elemList;
      Element nameElem1;
      Element nameElem2;
      NamedNodeMap attributesMap;
      Attr attr;
      boolean id = false;
      Element elem;
      String elemName;
      doc = (Document) load("hc_staff", true);
      elemList = doc.getElementsByTagName("strong");
      nameElem1 = (Element) elemList.item(2);
      nameElem2 = (Element) elemList.item(3);
      nameElem1.setAttribute("hasMiddleName", "Antoine");
      nameElem1.setIdAttribute("hasMiddleName", true);
      nameElem2.setAttribute("hasMiddleName", "Neeya");
      nameElem2.setIdAttribute("hasMiddleName", true);
      attributesMap = nameElem1.getAttributes();
      attr = (Attr) attributesMap.getNamedItem("hasMiddleName");
      id = attr.isId();
      assertTrue("elementsetidattributeIsId1True07", id);
      attributesMap = nameElem2.getAttributes();
      attr = (Attr) attributesMap.getNamedItem("hasMiddleName");
      id = attr.isId();
      assertTrue("elementsetidattributeIsId2True07", id);
      elem = doc.getElementById("Antoine");
      elemName = elem.getTagName();
      assertEquals("elementsetidattribute1GetElementById07", "strong", elemName);
      elem = doc.getElementById("Neeya");
      elemName = elem.getTagName();
      assertEquals("elementsetidattribute2GetElementById07", "strong", elemName);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/elementsetidattribute07";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(elementsetidattribute07.class, args);
   }
}

