/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core.impl.builder;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.axiom.core.Builder;
import org.apache.axiom.core.CoreDocument;
import org.apache.axiom.core.CoreNSAwareElement;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.DeferredParsingException;
import org.apache.axiom.core.NodeFactory2;
import org.apache.axiom.core.impl.builder.BuildableContext;
import org.apache.axiom.core.impl.builder.BuilderListener;
import org.apache.axiom.core.impl.builder.Context;
import org.apache.axiom.core.impl.builder.DeferredAction;
import org.apache.axiom.core.impl.builder.Model;
import org.apache.axiom.core.impl.builder.UnwrappingContext;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;

final class BuilderHandler
implements XmlHandler {
    final NodeFactory2 nodeFactory;
    final Model model;
    final Builder builder;
    final Object namespaceHelper;
    private final Context rootContext;
    private Context context;
    private int activeContextCount;
    private boolean done;
    private CoreDocument document;
    public int depth;
    private ArrayList<BuilderListener> listeners;
    private Queue<DeferredAction> deferredActions;

    BuilderHandler(NodeFactory2 nodeFactory, Model model, CoreNSAwareElement root, Builder builder) {
        this.nodeFactory = nodeFactory;
        this.model = model;
        this.builder = builder;
        this.namespaceHelper = nodeFactory.createNamespaceHelper();
        this.context = this.rootContext = root == null ? new BuildableContext(this, null, 0) : new UnwrappingContext(this, root);
        this.activeContextCount = 1;
    }

    void addListener(BuilderListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    void nodeAdded(CoreNode node) {
        if (node instanceof CoreDocument) {
            this.document = (CoreDocument)node;
        }
        if (this.listeners != null) {
            int size = this.listeners.size();
            for (int i = 0; i < size; ++i) {
                DeferredAction action = this.listeners.get(i).nodeAdded(node, this.depth);
                if (action == null) continue;
                this.scheduleDeferredAction(action);
            }
        }
    }

    private void scheduleDeferredAction(DeferredAction action) {
        if (this.deferredActions == null) {
            this.deferredActions = new LinkedList<DeferredAction>();
        }
        this.deferredActions.add(action);
    }

    void executeDeferredActions() throws DeferredParsingException {
        if (this.deferredActions != null) {
            DeferredAction action;
            while ((action = this.deferredActions.poll()) != null) {
                action.run();
            }
        }
    }

    void incrementActiveContextCount() {
        ++this.activeContextCount;
    }

    void decrementActiveContextCount() {
        if (--this.activeContextCount == 0) {
            this.scheduleDeferredAction(() -> {
                while (!this.done) {
                    this.builder.next();
                }
            });
        }
    }

    boolean isCompleted() {
        return this.done;
    }

    CoreDocument getDocument() {
        if (this.rootContext instanceof UnwrappingContext) {
            throw new UnsupportedOperationException("There is no document linked to this builder");
        }
        return this.document;
    }

    @Override
    public void startDocument(String inputEncoding, String xmlVersion, String xmlEncoding, Boolean standalone) {
        this.context.startDocument(inputEncoding, xmlVersion, xmlEncoding, standalone);
    }

    @Override
    public void startFragment() throws StreamException {
        this.context.startFragment();
    }

    @Override
    public void processDocumentTypeDeclaration(String rootName, String publicId, String systemId, String internalSubset) throws StreamException {
        this.context.processDocumentTypeDeclaration(rootName, publicId, systemId, internalSubset);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String prefix) throws StreamException {
        ++this.depth;
        this.context = this.context.startElement(namespaceURI, localName, prefix);
    }

    @Override
    public void endElement() throws StreamException {
        this.context = this.context.endElement();
        --this.depth;
    }

    @Override
    public void processAttribute(String namespaceURI, String localName, String prefix, String value, String type, boolean specified) throws StreamException {
        this.context.processAttribute(namespaceURI, localName, prefix, value, type, specified);
    }

    @Override
    public void processAttribute(String name, String value, String type, boolean specified) throws StreamException {
        this.context.processAttribute(name, value, type, specified);
    }

    @Override
    public void processNamespaceDeclaration(String prefix, String namespaceURI) throws StreamException {
        this.context.processNamespaceDeclaration(prefix, namespaceURI);
    }

    @Override
    public void attributesCompleted() throws StreamException {
        this.context.attributesCompleted();
    }

    @Override
    public void processCharacterData(Object data, boolean ignorable) throws StreamException {
        this.context.processCharacterData(data, ignorable);
    }

    @Override
    public void startProcessingInstruction(String target) throws StreamException {
        this.context = this.context.startProcessingInstruction(target);
    }

    @Override
    public void endProcessingInstruction() throws StreamException {
        this.context = this.context.endProcessingInstruction();
    }

    @Override
    public void startComment() throws StreamException {
        this.context = this.context.startComment();
    }

    @Override
    public void endComment() throws StreamException {
        this.context = this.context.endComment();
    }

    @Override
    public void startCDATASection() throws StreamException {
        this.context = this.context.startCDATASection();
    }

    @Override
    public void endCDATASection() throws StreamException {
        this.context = this.context.endCDATASection();
    }

    @Override
    public void processEntityReference(String name, String replacementText) throws StreamException {
        this.context.processEntityReference(name, replacementText);
    }

    @Override
    public void completed() throws StreamException {
        if (this.depth != 0) {
            throw new IllegalStateException();
        }
        this.context.completed();
        this.context = null;
        this.done = true;
    }

    @Override
    public boolean drain() throws StreamException {
        return true;
    }
}

