/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.util.jaxb;

import jakarta.activation.DataHandler;
import jakarta.xml.bind.attachment.AttachmentUnmarshaller;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.om.OMAttachmentAccessor;
import org.apache.axiom.util.activation.DataHandlerUtils;

final class AttachmentUnmarshallerImpl
extends AttachmentUnmarshaller {
    private final OMAttachmentAccessor attachmentAccessor;

    AttachmentUnmarshallerImpl(OMAttachmentAccessor attachmentAccessor) {
        this.attachmentAccessor = attachmentAccessor;
    }

    private static String getContentIDFromURL(String url) {
        if (url.startsWith("cid:")) {
            try {
                return URLDecoder.decode(url.substring(4), "ascii");
            }
            catch (UnsupportedEncodingException ex) {
                throw new Error(ex);
            }
        }
        throw new IllegalArgumentException("The URL doesn't use the cid scheme");
    }

    public byte[] getAttachmentAsByteArray(String cid) {
        throw new UnsupportedOperationException();
    }

    public DataHandler getAttachmentAsDataHandler(String cid) {
        Blob blob = this.attachmentAccessor.getBlob(AttachmentUnmarshallerImpl.getContentIDFromURL(cid));
        if (blob == null) {
            throw new IllegalArgumentException("No MIME part found for content ID '" + cid + "'");
        }
        return DataHandlerUtils.toDataHandler((Blob)blob);
    }

    public boolean isXOPPackage() {
        return true;
    }
}

