/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.Main;
import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.technology.Layer;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class PolyMerge
implements GeometryHandler {
    private HashMap allLayers = new HashMap();

    public void add(Object key, Object value, boolean fasterAlgorithm) {
        Layer layer = (Layer)key;
        PolyBase poly = (PolyBase)value;
        this.addPolygon(layer, poly);
    }

    public void addPolygon(Layer layer, PolyBase poly) {
        Area area = (Area)this.allLayers.get(layer);
        if (area == null) {
            area = new Area();
            this.allLayers.put(layer, area);
        }
        Area additionalArea = new Area(poly);
        area.add(additionalArea);
    }

    public void subPolygon(Layer layer, PolyBase poly) {
        throw new Error("not implemented in PolyMerge.subPolygon()");
    }

    public void addAll(GeometryHandler subMerge, AffineTransform trans) {
        PolyMerge other = (PolyMerge)subMerge;
        this.addMerge(other, trans);
    }

    public void addMerge(PolyMerge other, AffineTransform trans) {
        Iterator it = other.allLayers.keySet().iterator();
        while (it.hasNext()) {
            Layer subLayer = (Layer)it.next();
            Area subArea = (Area)other.allLayers.get(subLayer);
            Area area = (Area)this.allLayers.get(subLayer);
            if (area == null) {
                area = new Area();
                this.allLayers.put(subLayer, area);
            }
            Area newArea = subArea.createTransformedArea(trans);
            area.add(newArea);
        }
    }

    public Iterator getKeyIterator() {
        return this.allLayers.keySet().iterator();
    }

    public Collection getObjects(Object layer, boolean modified, boolean simple) {
        return this.getMergedPoints((Layer)layer, simple);
    }

    public List getMergedPoints(Layer layer, boolean simple) {
        Area area = (Area)this.allLayers.get(layer);
        if (area == null) {
            return null;
        }
        ArrayList<PolyBase> polyList = new ArrayList<PolyBase>();
        double[] coords = new double[6];
        ArrayList<Point2D> pointList = new ArrayList<Point2D>();
        Point2D.Double lastMoveTo = null;
        boolean isSingular = area.isSingular();
        ArrayList<PolyBase> toDelete = new ArrayList<PolyBase>();
        PathIterator pIt = area.getPathIterator(null);
        while (!pIt.isDone()) {
            int type = pIt.currentSegment(coords);
            if (type == 4) {
                if (lastMoveTo != null) {
                    pointList.add(lastMoveTo);
                }
                Point2D[] points = new Point2D[pointList.size()];
                int i = 0;
                Iterator it = pointList.iterator();
                while (it.hasNext()) {
                    points[i++] = (Point2D)it.next();
                }
                PolyBase poly = new PolyBase(points);
                poly.setLayer(layer);
                poly.setStyle(Poly.Type.FILLED);
                lastMoveTo = null;
                toDelete.clear();
                if (!simple && !isSingular) {
                    Iterator it2 = polyList.iterator();
                    while (it2.hasNext()) {
                        PolyBase pn = (PolyBase)it2.next();
                        if (!pn.contains((Point2D)pointList.get(0)) && !poly.contains(pn.getPoints()[0])) continue;
                        points = pn.getPoints();
                        for (i = 0; i < points.length; ++i) {
                            pointList.add(points[i]);
                        }
                        Point2D[] newPoints = new Point2D[pointList.size()];
                        System.arraycopy(pointList.toArray(), 0, newPoints, 0, pointList.size());
                        poly = new PolyBase(newPoints);
                        toDelete.add(pn);
                    }
                }
                if (poly != null) {
                    polyList.add(poly);
                }
                polyList.removeAll(toDelete);
                pointList.clear();
            } else if (type == 0 || type == 1) {
                Point2D.Double pt = new Point2D.Double(coords[0], coords[1]);
                pointList.add(pt);
                if (type == 0) {
                    lastMoveTo = pt;
                }
            }
            pIt.next();
        }
        if (Main.LOCALDEBUGFLAG) {
            List newList = PolyBase.getPointsInArea(area, layer, simple);
            if (newList.size() != polyList.size()) {
                System.out.println("Error in getPointsInArea");
            } else {
                boolean foundError = false;
                Iterator it = polyList.iterator();
                while (it.hasNext()) {
                    PolyBase poly = (PolyBase)it.next();
                    boolean found = false;
                    Iterator iter = polyList.iterator();
                    while (iter.hasNext()) {
                        PolyBase poly1 = (PolyBase)iter.next();
                        if (!poly1.polySame(poly)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    foundError = true;
                    break;
                }
                if (foundError) {
                    System.out.println("Error in getPointsInArea");
                }
            }
        }
        return polyList;
    }
}

