/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.output.Topology;
import com.sun.electric.tool.user.User;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class EDIF
extends Topology {
    private static final EGraphic EGUNKNOWN = new EGraphic("UNKNOWN");
    private static final EGraphic EGART = new EGraphic("ARTWORK");
    private static final EGraphic EGTEXT = new EGraphic("TEXT");
    private static final EGraphic EGWIRE = new EGraphic("WIRE");
    private static final EGraphic EGBUS = new EGraphic("BUS");
    private EGraphic egraphic = EGUNKNOWN;
    private EGraphic egraphic_override = EGUNKNOWN;
    private static DecimalFormat decimalFormatScientific = null;
    private int blkstack_ptr;
    private String[] blkstack = new String[50];

    public static void writeEDIFFile(Cell cell, VarContext context, String filePath) {
        EDIF out = new EDIF();
        if (out.openTextOutputStream(filePath)) {
            return;
        }
        if (out.writeCell(cell, context)) {
            return;
        }
        if (out.closeTextOutputStream()) {
            return;
        }
        System.out.println(filePath + " written");
    }

    EDIF() {
    }

    protected void start() {
        double meters_to_lambda = TextUtils.convertDistance(1.0, Technology.getCurrent(), TextUtils.UnitScale.NONE);
        String name = this.makeToken(this.topCell.getName());
        if (this.topCell.getView() == View.LAYOUT) {
            int rgrid = 660;
            double route = rgrid / 100;
            System.out.println("Writing footprint for cell " + this.makeToken(this.topCell.getName()));
            this.printWriter.println("(footprint " + TextUtils.formatDouble(route) + "e-06");
            this.printWriter.println(" (unknownLayoutRep");
            Rectangle2D cellBounds = this.topCell.getBounds();
            double width = cellBounds.getWidth() / (double)rgrid;
            double height = cellBounds.getHeight() / (double)rgrid;
            this.printWriter.println("  (" + this.makeToken(this.topCell.getName()) + " standard (" + TextUtils.formatDouble(height) + " " + TextUtils.formatDouble(width) + ")");
            this.printWriter.println(")))");
            return;
        }
        String header = "Electric VLSI Design System";
        if (User.isIncludeDateAndVersionInOutput()) {
            header = header + ", version " + Version.getVersion();
        }
        this.writeHeader(this.topCell, header, "EDIF Writer", this.topCell.getLibrary().getName());
        HashMap useCount = new HashMap();
        if (this.searchHierarchy(this.topCell, useCount) != 0) {
            this.blockOpen("library");
            this.blockPutIdentifier("lib0");
            this.blockPut("edifLevel", "0");
            this.blockOpen("technology");
            this.blockOpen("numberDefinition");
            if (IOTool.isEDIFUseSchematicView()) {
                this.blockOpen("scale");
                this.blockPutInteger(1.0);
                this.blockPutDouble(meters_to_lambda);
                this.blockPut("unit", "DISTANCE");
                this.blockClose("scale");
            }
            this.blockClose("technology");
            Iterator it = Technology.getTechnologies();
            while (it.hasNext()) {
                Technology tech = (Technology)it.next();
                Iterator pIt = tech.getNodes();
                while (pIt.hasNext()) {
                    PrimitiveNode.Function fun;
                    NodeProto np = (NodeProto)pIt.next();
                    GenMath.MutableInteger mi = (GenMath.MutableInteger)useCount.get(np);
                    if (mi == null || (fun = np.getFunction()) == PrimitiveNode.Function.UNKNOWN || fun == PrimitiveNode.Function.PIN || fun == PrimitiveNode.Function.CONTACT || fun == PrimitiveNode.Function.NODE || fun == PrimitiveNode.Function.CONNECT || fun == PrimitiveNode.Function.ART) continue;
                    for (int i = 0; i < mi.intValue(); ++i) {
                        this.writePrimitive(np, i, fun);
                    }
                }
            }
            this.blockClose("library");
        }
        this.blockOpen("library");
        this.blockPutIdentifier(this.makeToken(this.topCell.getLibrary().getName()));
        this.blockPut("edifLevel", "0");
        this.blockOpen("technology");
        this.blockOpen("numberDefinition");
        if (IOTool.isEDIFUseSchematicView()) {
            this.blockOpen("scale");
            this.blockPutInteger(1.0);
            this.blockPutDouble(meters_to_lambda);
            this.blockPut("unit", "DISTANCE");
            this.blockClose("scale");
        }
        this.blockClose("technology");
    }

    protected void done() {
        this.blockClose("library");
        this.blockOpen("design");
        this.blockPutIdentifier(this.makeToken(this.topCell.getName()));
        this.blockOpen("cellRef");
        this.blockPutIdentifier(this.makeToken(this.topCell.getName()));
        this.blockPut("libraryRef", this.makeToken(this.topCell.getLibrary().getName()));
        this.blockFinish();
    }

    protected void writeCellTopology(Cell cell, Topology.CellNetInfo cni, VarContext context) {
        this.blockOpen("cell");
        this.blockPutIdentifier(this.makeToken(cell.getName()));
        this.blockPut("cellType", "generic");
        this.blockOpen("view");
        this.blockPutIdentifier("cell");
        this.blockPut("viewType", IOTool.isEDIFUseSchematicView() ? "SCHEMATIC" : "NETLIST");
        this.blockOpen("interface");
        Iterator it = cni.getCellSignals();
        while (it.hasNext()) {
            Topology.CellSignal cs = (Topology.CellSignal)it.next();
            if (!cs.isExported()) continue;
            Export e = cs.getExport();
            String direction = "INPUT";
            if (e.getCharacteristic() == PortCharacteristic.OUT || e.getCharacteristic() == PortCharacteristic.REFOUT) {
                direction = "OUTPUT";
            }
            if (e.getCharacteristic() == PortCharacteristic.BIDIR) {
                direction = "INOUT";
            }
            this.blockOpen("port");
            this.blockPutIdentifier(this.makeToken(cs.getName()));
            this.blockPut("direction", direction);
            this.blockClose("port");
        }
        if (IOTool.isEDIFUseSchematicView() && cell.isIcon()) {
            this.writeSymbol(cell);
        }
        this.blockClose("interface");
        Netlist netList = cni.getNetList();
        Iterator nIt = netList.getNodables();
        while (nIt.hasNext()) {
            NodeInst ni;
            PrimitiveNode.Function fun;
            Nodable no = (Nodable)nIt.next();
            if (no.getProto() instanceof PrimitiveNode && ((fun = ((NodeInst)no).getFunction()) == PrimitiveNode.Function.UNKNOWN || fun == PrimitiveNode.Function.PIN || fun == PrimitiveNode.Function.CONTACT || fun == PrimitiveNode.Function.NODE || fun == PrimitiveNode.Function.CONNECT || fun == PrimitiveNode.Function.ART)) continue;
            this.blockOpen("instance");
            String iname = this.makeComponentName(no);
            String oname = no.getName();
            if (!oname.equalsIgnoreCase(iname)) {
                this.blockOpen("rename");
                this.blockPutIdentifier(iname);
                this.blockPutString(oname);
                this.blockClose("rename");
            } else {
                this.blockPutIdentifier(iname);
            }
            if (no.getProto() instanceof PrimitiveNode) {
                ni = (NodeInst)no;
                PrimitiveNode.Function fun2 = ni.getFunction();
                this.blockOpen("viewRef");
                this.blockPutIdentifier("cell");
                this.blockOpen("cellRef");
                if (fun2 == PrimitiveNode.Function.GATEAND || fun2 == PrimitiveNode.Function.GATEOR || fun2 == PrimitiveNode.Function.GATEXOR) {
                    int i = 0;
                    Iterator pIt = ni.getConnections();
                    while (pIt.hasNext()) {
                        Connection con = (Connection)pIt.next();
                        if (!con.getPortInst().getPortProto().getName().equals("a")) continue;
                        ++i;
                    }
                    String name = this.makeToken(ni.getProto().getName()) + i;
                    this.blockPutIdentifier(name);
                } else {
                    this.blockPutIdentifier(this.describePrimitive(ni, fun2));
                }
                this.blockPut("libraryRef", "lib0");
                this.blockClose("viewRef");
            } else {
                this.blockOpen("viewRef");
                this.blockPutIdentifier("cell");
                this.blockOpen("cellRef");
                this.blockPutIdentifier(this.makeToken(no.getProto().getName()));
                this.blockPut("libraryRef", cell.getLibrary().getName());
                this.blockClose("viewRef");
            }
            if (IOTool.isEDIFUseSchematicView() && no instanceof NodeInst) {
                ni = (NodeInst)no;
                this.blockOpen("transform");
                this.blockPut("orientation", this.getOrientation(ni));
                this.blockOpen("origin");
                double cX = ni.getAnchorCenterX();
                double cY = ni.getAnchorCenterY();
                if (no.getProto() instanceof Cell) {
                    Rectangle2D cellBounds = ((Cell)no.getProto()).getBounds();
                    cX = ni.getTrueCenterX() - cellBounds.getCenterX();
                    cY = ni.getTrueCenterY() - cellBounds.getCenterY();
                }
                Point2D.Double pt = new Point2D.Double(cX, cY);
                AffineTransform trans = ni.rotateOut();
                trans.transform(pt, pt);
                this.writePoint(((Point2D)pt).getX(), ((Point2D)pt).getY());
                this.blockClose("transform");
            }
            if (IOTool.isEDIFUseSchematicView() && no instanceof NodeInst) {
                ni = (NodeInst)no;
                int num = ni.numDisplayableVariables(false);
                Poly[] varPolys = new Poly[num];
                ni.addDisplayableVariables(ni.getBounds(), varPolys, 0, null, false);
                for (int i = 0; i < num; ++i) {
                    Poly varPoly = varPolys[i];
                    String name = null;
                    Variable var = varPoly.getVariable();
                    if (var != null) {
                        name = var.getKey().getName();
                    } else if (varPoly.getName() != null) {
                        name = "NODE_name";
                    }
                    if (name == null) continue;
                    AffineTransform trans = ni.rotateOut();
                    varPoly.transform(trans);
                    this.blockOpen("property");
                    this.blockPutIdentifier(name);
                    this.blockOpen("string");
                    this.writeSymbolPoly(varPoly);
                    this.blockClose("property");
                }
            }
            this.blockClose("instance");
        }
        Iterator it2 = cni.getCellSignals();
        while (it2.hasNext()) {
            Topology.CellSignal cs = (Topology.CellSignal)it2.next();
            String netName = cs.getNetwork().describe();
            if (netName.length() == 0) continue;
            boolean globalport = false;
            this.blockOpen("net");
            netName = cs.getName();
            if (globalport) {
                this.blockOpen("rename");
                this.blockPutIdentifier(this.makeToken(netName));
                String name = this.makeToken(netName) + "!";
                this.blockPutIdentifier(name);
                this.blockClose("rename");
                this.blockPut("property", "GLOBAL");
            } else {
                String oname = this.makeToken(netName);
                if (!oname.equals(netName)) {
                    this.blockOpen("rename");
                    this.blockPutIdentifier(oname);
                    this.blockPutString(netName);
                    this.blockClose("rename");
                } else {
                    this.blockPutIdentifier(oname);
                }
            }
            this.blockOpen("joined");
            if (cs.isExported()) {
                Export e = cs.getExport();
                String pt = e.getName();
                this.blockPut("portRef", this.makeToken(pt));
            }
            Network net = cs.getNetwork();
            Iterator nIt2 = netList.getNodables();
            while (nIt2.hasNext()) {
                Nodable no = (Nodable)nIt2.next();
                NodeProto niProto = no.getProto();
                if (niProto instanceof Cell) {
                    String nodeName = this.parameterizedName(no, context);
                    Topology.CellNetInfo subCni = this.getCellNetInfo(nodeName);
                    Iterator sIt = subCni.getCellSignals();
                    while (sIt.hasNext()) {
                        Network subNet;
                        Topology.CellSignal subCs = (Topology.CellSignal)sIt.next();
                        Export subPp = subCs.getExport();
                        if (subPp == null || cs != cni.getCellSignal(subNet = netList.getNetwork(no, subPp, subCs.getExportIndex()))) continue;
                        this.blockOpen("portRef");
                        this.blockPutIdentifier(this.makeToken(subCs.getName()));
                        this.blockPut("instanceRef", this.makeComponentName(no));
                        this.blockClose("portRef");
                    }
                    continue;
                }
                NodeInst ni = (NodeInst)no;
                PrimitiveNode.Function fun = ni.getFunction();
                if (fun == PrimitiveNode.Function.UNKNOWN || fun == PrimitiveNode.Function.PIN || fun == PrimitiveNode.Function.CONTACT || fun == PrimitiveNode.Function.NODE || fun == PrimitiveNode.Function.CONNECT || fun == PrimitiveNode.Function.ART) continue;
                Iterator cIt = ni.getConnections();
                while (cIt.hasNext()) {
                    Connection con = (Connection)cIt.next();
                    ArcInst ai = con.getArc();
                    Network aNet = netList.getNetwork(ai, 0);
                    if (aNet != net) continue;
                    String pt = con.getPortInst().getPortProto().getName();
                    this.blockOpen("portRef");
                    this.blockPutIdentifier(this.makeToken(pt));
                    this.blockPut("instanceRef", this.makeComponentName(no));
                    this.blockClose("portRef");
                }
            }
            this.blockClose("joined");
            if (IOTool.isEDIFUseSchematicView()) {
                this.egraphic = EGUNKNOWN;
                this.egraphic_override = EGWIRE;
                Iterator aIt = cell.getArcs();
                while (aIt.hasNext()) {
                    Network aNet;
                    ArcInst ai = (ArcInst)aIt.next();
                    int aWidth = netList.getBusWidth(ai);
                    if (aWidth > 1 || (aNet = netList.getNetwork(ai, 0)) != net) continue;
                    this.writeSymbolArcInst(ai, GenMath.MATID);
                }
                this.setGraphic(EGUNKNOWN);
                this.egraphic_override = EGUNKNOWN;
            }
            if (globalport) {
                this.blockPut("userData", "global");
            }
            this.blockClose("net");
        }
        it2 = cni.getCellAggregateSignals();
        while (it2.hasNext()) {
            Topology.CellAggregateSignal cas = (Topology.CellAggregateSignal)it2.next();
            if (cas.getLowIndex() > cas.getHighIndex()) continue;
            this.blockOpen("netBundle");
            String busName = cas.getNameWithIndices();
            String oname = this.makeToken(busName);
            if (!oname.equals(busName)) {
                this.blockOpen("rename");
                this.blockPutIdentifier(oname);
                this.blockPutString(busName);
                this.blockClose("rename");
            } else {
                this.blockPutIdentifier(oname);
            }
            this.blockOpen("listOfNets");
            int numSignals = cas.getHighIndex() - cas.getLowIndex() + 1;
            for (int k = 0; k < numSignals; ++k) {
                this.blockOpen("net");
                Topology.CellSignal cs = cas.getSignal(k);
                String pt = cs.getName();
                oname = this.makeToken(pt);
                if (!oname.equals(pt)) {
                    this.blockOpen("rename");
                    this.blockPutIdentifier(oname);
                    this.blockPutString(pt);
                    this.blockClose("rename");
                } else {
                    this.blockPutIdentifier(oname);
                }
                this.blockClose("net");
            }
            if (IOTool.isEDIFUseSchematicView()) {
                this.egraphic = EGUNKNOWN;
                this.egraphic_override = EGBUS;
                Iterator aIt = cell.getArcs();
                while (aIt.hasNext()) {
                    String arcBusName;
                    ArcInst ai = (ArcInst)aIt.next();
                    if (ai.getProto() != Schematics.tech.bus_arc || !(arcBusName = netList.getBusName(ai).toString()).equals(busName)) continue;
                    this.writeSymbolArcInst(ai, GenMath.MATID);
                }
                this.setGraphic(EGUNKNOWN);
                this.egraphic_override = EGUNKNOWN;
            }
            this.blockClose("netBundle");
        }
        this.blockClose("cell");
    }

    private void writeHeader(Cell cell, String program, String comment, String origin) {
        this.blockOpen("edif");
        this.blockPutIdentifier(cell.getName());
        this.blockPut("edifVersion", "2 0 0");
        this.blockPut("edifLevel", "0");
        this.blockOpen("keywordMap");
        this.blockPut("keywordLevel", "0");
        this.blockClose("keywordMap");
        this.blockOpen("status");
        this.blockOpen("written");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy MM dd HH mm ss");
        this.blockPut("timeStamp", simpleDateFormat.format(new Date()));
        if (program != null) {
            this.blockPut("program", "\"" + program + "\"");
        }
        if (comment != null) {
            this.blockPut("comment", "\"" + comment + "\"");
        }
        if (origin != null) {
            this.blockPut("dataOrigin", "\"" + origin + "\"");
        }
        this.blockClose("status");
    }

    private void writePrimitive(NodeProto np, int i, PrimitiveNode.Function fun) {
        if (fun == PrimitiveNode.Function.GATEAND || fun == PrimitiveNode.Function.GATEOR || fun == PrimitiveNode.Function.GATEXOR) {
            this.blockOpen("cell");
            String name = this.makeToken(np.getName()) + i;
            this.blockPutIdentifier(name);
        } else {
            this.blockOpen("cell");
            this.blockPutIdentifier(this.makeToken(np.getName()));
        }
        this.blockPut("cellType", "GENERIC");
        this.blockOpen("view");
        this.blockPutIdentifier("cell");
        this.blockPut("viewType", IOTool.isEDIFUseSchematicView() ? "SCHEMATIC" : "NETLIST");
        this.blockOpen("interface");
        int firstPortIndex = 0;
        if (fun == PrimitiveNode.Function.GATEAND || fun == PrimitiveNode.Function.GATEOR || fun == PrimitiveNode.Function.GATEXOR) {
            for (int j = 0; j < i; ++j) {
                this.blockOpen("port");
                String name = "IN" + (j + 1);
                this.blockPutIdentifier(name);
                this.blockPut("direction", "INPUT");
                this.blockClose("port");
            }
            firstPortIndex = 1;
        }
        for (int k = firstPortIndex; k < np.getNumPorts(); ++k) {
            PortProto pp = np.getPort(k);
            String direction = "input";
            if (pp.getCharacteristic() == PortCharacteristic.OUT) {
                direction = "output";
            } else if (pp.getCharacteristic() == PortCharacteristic.BIDIR) {
                direction = "inout";
            }
            this.blockOpen("port");
            this.blockPutIdentifier(this.makeToken(pp.getName()));
            this.blockPut("direction", direction);
            this.blockClose("port");
        }
        this.blockClose("cell");
    }

    private int searchHierarchy(Cell cell, HashMap useMap) {
        if (cell.isIcon()) {
            return 0;
        }
        int primcount = 0;
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            GenMath.MutableInteger count;
            NodeInst ni = (NodeInst)it.next();
            NodeProto np = ni.getProto();
            if (np instanceof PrimitiveNode) {
                GenMath.MutableInteger count2;
                PrimitiveNode.Function fun = ni.getFunction();
                int i = 1;
                if (fun == PrimitiveNode.Function.GATEAND || fun == PrimitiveNode.Function.GATEOR || fun == PrimitiveNode.Function.GATEXOR) {
                    Iterator cIt = ni.getConnections();
                    while (cIt.hasNext()) {
                        Connection con = (Connection)cIt.next();
                        if (!con.getPortInst().getPortProto().getName().equals("a")) continue;
                        ++i;
                    }
                }
                if ((count2 = (GenMath.MutableInteger)useMap.get(np)) == null) {
                    count2 = new GenMath.MutableInteger(0);
                    useMap.put(np, count2);
                }
                count2.setValue(Math.max(count2.intValue(), i));
                if (fun == PrimitiveNode.Function.UNKNOWN || fun == PrimitiveNode.Function.PIN || fun == PrimitiveNode.Function.CONTACT || fun == PrimitiveNode.Function.NODE || fun == PrimitiveNode.Function.CONNECT || fun == PrimitiveNode.Function.METER || fun == PrimitiveNode.Function.CONPOWER || fun == PrimitiveNode.Function.CONGROUND || fun == PrimitiveNode.Function.SOURCE || fun == PrimitiveNode.Function.SUBSTRATE || fun == PrimitiveNode.Function.WELL || fun == PrimitiveNode.Function.ART) continue;
                ++primcount;
                continue;
            }
            if (ni.isIconOfParent()) continue;
            Cell oNp = ((Cell)np).contentsView();
            if (oNp == null) {
                oNp = (Cell)np;
            }
            if ((count = (GenMath.MutableInteger)useMap.get(oNp)) != null) continue;
            primcount += this.searchHierarchy(oNp, useMap);
        }
        GenMath.MutableInteger count = (GenMath.MutableInteger)useMap.get(cell);
        if (count == null) {
            count = new GenMath.MutableInteger(0);
            useMap.put(cell, count);
        }
        count.increment();
        return primcount;
    }

    private void writePoint(double x, double y) {
        this.blockOpen("pt");
        this.blockPutInteger(this.scaleValue(x));
        this.blockPutInteger(this.scaleValue(y));
        this.blockClose("pt");
    }

    private String getOrientation(NodeInst ni) {
        String orientation = "ERROR";
        switch (ni.getAngle()) {
            case 0: {
                orientation = "";
                break;
            }
            case 900: {
                orientation = "R90";
                break;
            }
            case 1800: {
                orientation = "R180";
                break;
            }
            case 2700: {
                orientation = "R270";
            }
        }
        if (ni.isMirroredAboutXAxis()) {
            orientation = "MX" + orientation;
        }
        if (ni.isMirroredAboutYAxis()) {
            orientation = "MY" + orientation;
        }
        if (orientation.length() == 0) {
            orientation = "R0";
        }
        return orientation;
    }

    private double scaleValue(double val) {
        return val;
    }

    private boolean isGlobalExport(Export e) {
        if (e.isBodyOnly()) {
            return true;
        }
        Cell parent = (Cell)e.getParent();
        Cell inp = parent.iconView();
        if (inp == null) {
            return false;
        }
        return e.getEquivalent() == null;
    }

    private String describePrimitive(NodeInst ni, PrimitiveNode.Function fun) {
        if (fun == PrimitiveNode.Function.RESIST) {
            return "Resistor";
        }
        if (fun == PrimitiveNode.Function.TRANPN) {
            return "npn";
        }
        if (fun == PrimitiveNode.Function.TRAPNP) {
            return "pnp";
        }
        if (fun == PrimitiveNode.Function.SUBSTRATE) {
            return "gtap";
        }
        return this.makeToken(ni.getProto().getName());
    }

    private String makeComponentName(Nodable no) {
        char chr;
        String okname = this.makeValidName(no.getName());
        if (okname.length() > 0 && (TextUtils.isDigit(chr = okname.charAt(0)) || chr == '_')) {
            okname = "&" + okname;
        }
        return okname;
    }

    private String makeValidName(String name) {
        StringBuffer iptr = new StringBuffer(name);
        int i = 0;
        if (iptr.charAt(i) == '&') {
            ++i;
        }
        while (i < iptr.length()) {
            if (!TextUtils.isLetterOrDigit(iptr.charAt(i)) && iptr.charAt(i) != '_') {
                iptr.setCharAt(i, '_');
            }
            ++i;
        }
        return iptr.toString();
    }

    private String makeToken(String str) {
        char chr;
        if (str.length() == 0) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        if (TextUtils.isDigit(str.charAt(0))) {
            sb.append('X');
        }
        for (int i = 0; i < str.length() && !Character.isWhitespace(chr = str.charAt(i)); ++i) {
            if (chr == '[') {
                chr = '_';
            }
            if (!TextUtils.isLetterOrDigit(chr) && chr != '&' && chr != 95) continue;
            sb.append(chr);
        }
        return sb.toString();
    }

    private void writeSymbol(Cell cell) {
        this.blockOpen("symbol");
        this.egraphic_override = EGWIRE;
        this.egraphic = EGUNKNOWN;
        Iterator it = cell.getPorts();
        while (it.hasNext()) {
            Export e = (Export)it.next();
            this.blockOpen("portImplementation");
            this.blockPutIdentifier(this.makeToken(e.getName()));
            this.blockOpen("connectLocation");
            Poly portPoly = e.getOriginalPort().getPoly();
            this.writeSymbolPoly(portPoly);
            this.setGraphic(EGUNKNOWN);
            this.blockClose("portImplementation");
        }
        this.egraphic_override = EGUNKNOWN;
        it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            this.writeSymbolCell(ni, GenMath.MATID);
        }
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            this.writeSymbolArcInst(ai, GenMath.MATID);
        }
        this.setGraphic(EGUNKNOWN);
        this.blockClose("symbol");
    }

    private void writeSymbolCell(NodeInst ni, AffineTransform prevtrans) {
        if (ni.getAngle() == 0 && !ni.isMirroredAboutXAxis() && !ni.isMirroredAboutYAxis()) {
            this.writeSymbolNodeInst(ni, prevtrans);
        } else {
            AffineTransform localtran = ni.rotateOut(prevtrans);
            this.writeSymbolNodeInst(ni, localtran);
        }
    }

    private void writeSymbolNodeInst(NodeInst ni, AffineTransform prevtrans) {
        NodeProto np = ni.getProto();
        if (np instanceof PrimitiveNode) {
            Technology tech = np.getTechnology();
            Poly[] polys = tech.getShapeOfNode(ni);
            int high = polys.length;
            int low = 0;
            if (np == Generic.tech.invisiblePinNode) {
                low = 1;
            }
            for (int j = low; j < high; ++j) {
                Poly poly = polys[j];
                poly.transform(prevtrans);
                boolean istext = false;
                if (poly.getStyle().isText()) {
                    istext = true;
                    this.setGraphic(EGUNKNOWN);
                    this.blockOpen("annotate");
                }
                this.writeSymbolPoly(poly);
                if (!istext) continue;
                this.blockClose("annotate");
            }
        } else {
            Cell subCell = (Cell)np;
            AffineTransform subrot = ni.translateOut(prevtrans);
            int num = ni.numDisplayableVariables(false);
            if (num != 0) {
                this.setGraphic(EGUNKNOWN);
            }
            Poly[] varPolys = new Poly[num];
            ni.addDisplayableVariables(ni.getBounds(), varPolys, 0, null, false);
            for (int i = 0; i < num; ++i) {
                Poly varPoly = varPolys[i];
                String name = null;
                Variable var = varPoly.getVariable();
                if (var != null) {
                    name = var.getKey().getName();
                } else if (varPoly.getName() != null) {
                    name = "NODE_name";
                }
                if (name == null) continue;
                AffineTransform trans = ni.rotateOut();
                varPoly.transform(prevtrans);
                this.blockOpen("property");
                this.blockPutIdentifier(name);
                this.blockOpen("string");
                this.writeSymbolPoly(varPoly);
                this.blockClose("property");
            }
            Iterator it = subCell.getNodes();
            while (it.hasNext()) {
                NodeInst sNi = (NodeInst)it.next();
                this.writeSymbolCell(sNi, subrot);
            }
            it = subCell.getArcs();
            while (it.hasNext()) {
                ArcInst sAi = (ArcInst)it.next();
                this.writeSymbolArcInst(sAi, subrot);
            }
        }
    }

    private void writeSymbolArcInst(ArcInst ai, AffineTransform trans) {
        Technology tech = ai.getProto().getTechnology();
        Poly[] polys = tech.getShapeOfArc(ai);
        Point2D[] points = new Point2D[]{ai.getTail().getLocation(), ai.getHead().getLocation()};
        Poly poly = new Poly(points);
        poly.setStyle(Poly.Type.OPENED);
        poly.transform(trans);
        this.writeSymbolPoly(poly);
        int num = ai.numDisplayableVariables(false);
        if (num != 0) {
            this.setGraphic(EGUNKNOWN);
        }
        Poly[] varPolys = new Poly[num];
        ai.addDisplayableVariables(ai.getBounds(), varPolys, 0, null, false);
        for (int i = 0; i < num; ++i) {
            Poly varPoly = varPolys[i];
            String name = null;
            Variable var = varPoly.getVariable();
            if (var != null) {
                name = var.getKey().getName();
            } else if (varPoly.getName() != null) {
                name = "ARC_name";
            }
            if (name == null) continue;
            poly.transform(trans);
            this.blockOpen("property");
            this.blockPutIdentifier(name);
            this.blockOpen("string");
            this.writeSymbolPoly(varPoly);
            this.blockClose("property");
        }
    }

    private void setGraphic(EGraphic type) {
        if (type == EGUNKNOWN) {
            if (this.egraphic != EGUNKNOWN) {
                this.blockClose("figure");
            }
            this.egraphic = EGUNKNOWN;
        } else if (this.egraphic_override == EGUNKNOWN) {
            if (type != this.egraphic) {
                if (this.egraphic != EGUNKNOWN) {
                    this.blockClose("figure");
                }
                this.egraphic = type;
                this.blockOpen("figure");
                this.blockPutIdentifier(this.egraphic.getText());
            }
        } else if (this.egraphic != this.egraphic_override) {
            if (this.egraphic != EGUNKNOWN) {
                this.blockClose("figure");
            }
            this.egraphic = this.egraphic_override;
            this.blockOpen("figure");
            this.blockPutIdentifier(this.egraphic.getText());
        }
    }

    private void writeSymbolPoly(Poly obj) {
        Poly.Type type = obj.getStyle();
        Point2D[] points = obj.getPoints();
        if (type == Poly.Type.CIRCLE || type == Poly.Type.DISC) {
            this.setGraphic(EGART);
            double i = points[0].distance(points[1]);
            this.blockOpen("circle");
            this.writePoint(points[0].getX() - i, points[0].getY());
            this.writePoint(points[0].getX() + i, points[0].getY());
            this.blockClose("circle");
            return;
        }
        if (type == Poly.Type.CIRCLEARC) {
            this.setGraphic(EGART);
            if (points.length == 0) {
                return;
            }
            if (points.length % 3 != 0) {
                return;
            }
            for (int i = 0; i < points.length; i += 3) {
                this.blockOpen("openShape");
                this.blockOpen("curve");
                this.blockOpen("arc");
                this.writePoint(points[i + 1].getX(), points[i + 1].getY());
                Point2D si = GenMath.computeArcCenter(points[i], points[i + 1], points[i + 2]);
                this.writePoint(si.getX(), si.getY());
                this.writePoint(points[i + 2].getX(), points[i + 2].getY());
                this.blockClose("openShape");
            }
            return;
        }
        if (type == Poly.Type.FILLED || type == Poly.Type.CLOSED) {
            Rectangle2D bounds = obj.getBox();
            if (bounds != null) {
                if (bounds.getWidth() == 0.0 && bounds.getHeight() == 0.0) {
                    if (this.egraphic_override == EGUNKNOWN) {
                        return;
                    }
                    this.setGraphic(EGART);
                    this.blockOpen("dot");
                    this.writePoint(bounds.getCenterX(), bounds.getCenterY());
                    this.blockClose("dot");
                } else {
                    this.setGraphic(EGART);
                    this.blockOpen("rectangle");
                    this.writePoint(bounds.getMinX(), bounds.getMinY());
                    this.writePoint(bounds.getMaxY(), bounds.getMaxY());
                    this.blockClose("rectangle");
                }
            } else {
                this.setGraphic(EGART);
                this.blockOpen("path");
                this.blockOpen("pointList");
                for (int i = 0; i < points.length; ++i) {
                    this.writePoint(points[i].getX(), points[i].getY());
                }
                if (points.length > 2) {
                    this.writePoint(points[0].getX(), points[0].getY());
                }
                this.blockClose("path");
            }
            return;
        }
        if (type.isText()) {
            Rectangle2D bounds = obj.getBounds2D();
            this.setGraphic(EGUNKNOWN);
            this.blockOpen("stringDisplay");
            this.blockPutString(obj.getString());
            this.blockOpen("display");
            TextDescriptor td = obj.getTextDescriptor();
            if (td.getSize().isAbsolute()) {
                this.blockOpen("figureGroupOverride");
                this.blockPutIdentifier(EGART.getText());
                this.blockOpen("textHeight");
                double height = td.getSize().getSize() * 10.0 / 36.0;
                this.blockPutInteger(this.scaleValue(height));
                this.blockClose("figureGroupOverride");
            } else {
                this.blockPutIdentifier(EGART.getText());
            }
            if (type == Poly.Type.TEXTCENT) {
                this.blockPut("justify", "CENTERCENTER");
            } else if (type == Poly.Type.TEXTTOP) {
                this.blockPut("justify", "LOWERCENTER");
            } else if (type == Poly.Type.TEXTBOT) {
                this.blockPut("justify", "UPPERCENTER");
            } else if (type == Poly.Type.TEXTLEFT) {
                this.blockPut("justify", "CENTERRIGHT");
            } else if (type == Poly.Type.TEXTRIGHT) {
                this.blockPut("justify", "CENTERLEFT");
            } else if (type == Poly.Type.TEXTTOPLEFT) {
                this.blockPut("justify", "LOWERRIGHT");
            } else if (type == Poly.Type.TEXTBOTLEFT) {
                this.blockPut("justify", "UPPERRIGHT");
            } else if (type == Poly.Type.TEXTTOPRIGHT) {
                this.blockPut("justify", "LOWERLEFT");
            } else if (type == Poly.Type.TEXTBOTRIGHT) {
                this.blockPut("justify", "UPPERLEFT");
            }
            this.blockPut("orientation", "R0");
            this.blockOpen("origin");
            this.writePoint(bounds.getMinX(), bounds.getMinY());
            this.blockClose("stringDisplay");
            return;
        }
        if (type == Poly.Type.OPENED || type == Poly.Type.OPENEDT1 || type == Poly.Type.OPENEDT2 || type == Poly.Type.OPENEDT3) {
            Rectangle2D bounds;
            if (points.length == 5 && points[4].getX() == points[0].getX() && points[4].getY() == points[0].getY() && (bounds = obj.getBox()) != null) {
                if (bounds.getWidth() == 0.0 && bounds.getHeight() == 0.0) {
                    if (this.egraphic_override == EGUNKNOWN) {
                        return;
                    }
                    this.setGraphic(EGART);
                    this.blockOpen("dot");
                    this.writePoint(bounds.getCenterX(), bounds.getCenterY());
                    this.blockClose("dot");
                } else {
                    this.setGraphic(EGART);
                    this.blockOpen("rectangle");
                    this.writePoint(bounds.getMinX(), bounds.getMinY());
                    this.writePoint(bounds.getMaxX(), bounds.getMaxY());
                    this.blockClose("rectangle");
                }
                return;
            }
            this.setGraphic(EGART);
            this.blockOpen("path");
            this.blockOpen("pointList");
            for (int i = 0; i < points.length; ++i) {
                this.writePoint(points[i].getX(), points[i].getY());
            }
            this.blockClose("path");
            return;
        }
        if (type == Poly.Type.VECTORS) {
            this.setGraphic(EGART);
            for (int i = 0; i < points.length; i += 2) {
                this.blockOpen("path");
                this.blockOpen("pointList");
                this.writePoint(points[i].getX(), points[i].getY());
                this.writePoint(points[i + 1].getX(), points[i + 1].getY());
                this.blockClose("path");
            }
            return;
        }
    }

    private void blockOpen(String keyword) {
        if (this.blkstack_ptr > 0) {
            this.printWriter.print("\n");
        }
        this.blkstack[this.blkstack_ptr++] = keyword;
        this.printWriter.print(this.getBlanks(this.blkstack_ptr - 1) + "( " + keyword);
    }

    private void blockPut(String keyword, String identifier) {
        if (this.blkstack_ptr != 0) {
            this.printWriter.print("\n");
        }
        this.printWriter.print(this.getBlanks(this.blkstack_ptr) + "( " + keyword + " " + identifier + " )");
    }

    private void blockPutIdentifier(String str) {
        this.printWriter.print(" " + str);
    }

    private void blockPutString(String str) {
        this.printWriter.print(" \"" + str + "\"");
    }

    private void blockPutInteger(double val) {
        this.printWriter.print(" " + TextUtils.formatDouble(val));
    }

    private void blockPutDouble(double val) {
        if (decimalFormatScientific == null) {
            decimalFormatScientific = new DecimalFormat("0.#####E0");
            decimalFormatScientific.setGroupingUsed(false);
        }
        String ret = decimalFormatScientific.format(val).replace('E', ' ');
        this.printWriter.print(" ( e " + ret + " )");
    }

    private void blockClose(String keyword) {
        if (this.blkstack_ptr == 0) {
            return;
        }
        int depth = 1;
        if (keyword != null) {
            for (depth = 1; depth <= this.blkstack_ptr && !this.blkstack[this.blkstack_ptr - depth].equals(keyword); ++depth) {
            }
            if (depth > this.blkstack_ptr) {
                System.out.println("EDIF output: could not match keyword <" + keyword + ">");
                return;
            }
        }
        do {
            --this.blkstack_ptr;
            this.printWriter.print(" )");
        } while (--depth > 0);
    }

    private void blockFinish() {
        if (this.blkstack_ptr > 0) {
            this.blockClose(this.blkstack[0]);
        }
        this.printWriter.print("\n");
    }

    private String getBlanks(int num) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < num; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    protected String getSafeCellName(String name) {
        return name;
    }

    protected String getPowerName(Network net) {
        return "VDD";
    }

    protected String getGroundName(Network net) {
        return "GND";
    }

    protected String getGlobalName(Global glob) {
        return glob.getName();
    }

    protected boolean isNetworksUseExportedNames() {
        return true;
    }

    protected boolean isLibraryNameAlwaysAddedToCellName() {
        return false;
    }

    protected boolean isAggregateNamesSupported() {
        return true;
    }

    protected String getSafeNetName(String name) {
        return name;
    }

    protected Netlist getNetlistForCell(Cell cell) {
        boolean shortResistors = false;
        Netlist netList = cell.getNetlist(shortResistors);
        return netList;
    }

    protected boolean canParameterizeNames() {
        return true;
    }

    private static class EGraphic {
        private String text;

        EGraphic(String text) {
            this.text = text;
        }

        String getText() {
            return this.text;
        }
    }
}

