/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.io.output.Output;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PAL
extends Output {
    private Cell topCell;
    private List equations;
    private Set internalSymbols;
    private Set externalSymbols;

    public static void writePALFile(Cell cell, VarContext context, String filePath) {
        PAL out = new PAL();
        if (out.openTextOutputStream(filePath)) {
            return;
        }
        out.initialize(cell);
        PALNetlister netlister = new PALNetlister(out);
        Netlist netlist = cell.getNetlist(true);
        HierarchyEnumerator.enumerateCell(cell, context, netlist, netlister);
        out.terminate(cell);
        if (out.closeTextOutputStream()) {
            return;
        }
        System.out.println(filePath + " written");
    }

    PAL() {
    }

    private void initialize(Cell cell) {
        this.topCell = cell;
        this.equations = new ArrayList();
        this.internalSymbols = new HashSet();
        this.externalSymbols = new HashSet();
    }

    private void terminate(Cell cell) {
        String symbol;
        this.printWriter.println("module " + cell.getName());
        this.printWriter.println("title 'generated by Electric'");
        int pinNumber = 1;
        Iterator it = this.externalSymbols.iterator();
        while (it.hasNext()) {
            symbol = (String)it.next();
            this.printWriter.println("    " + symbol + " pin " + pinNumber + ";");
            ++pinNumber;
        }
        it = this.internalSymbols.iterator();
        while (it.hasNext()) {
            symbol = (String)it.next();
            this.printWriter.println("    " + symbol + " = 0,1;");
        }
        this.printWriter.println("");
        this.printWriter.println("equations");
        it = this.equations.iterator();
        while (it.hasNext()) {
            String eq = (String)it.next();
            this.printWriter.println("    " + eq + ";");
        }
        this.printWriter.println("");
        this.printWriter.println("end " + cell.describe());
    }

    private static class PALNetlister
    extends HierarchyEnumerator.Visitor {
        private PAL pal;

        PALNetlister(PAL pal) {
            this.pal = pal;
        }

        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            return true;
        }

        public void exitCell(HierarchyEnumerator.CellInfo info) {
        }

        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            NodeProto np = no.getProto();
            if (!(np instanceof PrimitiveNode)) {
                return true;
            }
            NodeInst ni = (NodeInst)no;
            PrimitiveNode.Function fun = ni.getFunction();
            if (fun != PrimitiveNode.Function.GATEAND && fun != PrimitiveNode.Function.GATEOR && fun != PrimitiveNode.Function.GATEXOR && fun != PrimitiveNode.Function.BUFFER) {
                return false;
            }
            String funName = "";
            if (fun == PrimitiveNode.Function.GATEAND) {
                funName = "&";
            } else if (fun == PrimitiveNode.Function.GATEOR) {
                funName = "#";
            } else if (fun == PrimitiveNode.Function.GATEXOR) {
                funName = "$";
            }
            Connection outputCon = null;
            Iterator it = ni.getConnections();
            while (it.hasNext()) {
                Connection con = (Connection)it.next();
                PortInst pi = con.getPortInst();
                if (!pi.getPortProto().getName().equals("y")) continue;
                outputCon = con;
                break;
            }
            if (outputCon == null) {
                System.out.println("ERROR: output port is not connected on " + ni.describe() + " in cell " + ni.getParent().describe());
                return false;
            }
            Netlist netlist = info.getNetlist();
            StringBuffer sb = new StringBuffer();
            if (outputCon.isNegated()) {
                sb.append("!");
            }
            Network oNet = netlist.getNetwork(outputCon.getPortInst());
            sb.append(this.getNetName(oNet, info) + " =");
            int count = 0;
            Iterator it2 = ni.getConnections();
            while (it2.hasNext()) {
                Network net;
                Connection con = (Connection)it2.next();
                PortInst pi = con.getPortInst();
                if (!pi.getPortProto().getName().equals("a")) continue;
                if (count == 1) {
                    sb.append(" " + funName);
                }
                ++count;
                sb.append(" ");
                if (con.isNegated()) {
                    sb.append("!");
                }
                if ((net = netlist.getNetwork(con.getArc(), 0)) == null) continue;
                sb.append(this.getNetName(net, info));
            }
            this.pal.equations.add(sb.toString());
            return false;
        }

        private String getNetName(Network net, HierarchyEnumerator.CellInfo info) {
            Network higher;
            Network originalNet = net;
            HierarchyEnumerator.CellInfo originalInfo = info;
            while ((higher = info.getNetworkInParent(net)) != null) {
                net = higher;
                info = info.getParentInfo();
            }
            if (net.isExported() && info.getCell() == this.pal.topCell) {
                String exportName = net.describe();
                this.pal.externalSymbols.add(exportName);
                return exportName;
            }
            String internalName = info.getUniqueNetName(net, ".");
            this.pal.internalSymbols.add(internalName);
            return internalName;
        }
    }
}

