/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.logicaleffort;

import com.sun.electric.tool.logicaleffort.Instance;
import com.sun.electric.tool.logicaleffort.Net;
import java.util.ArrayList;

public class Pin {
    private Dir dir;
    private float le;
    private String name;
    private Instance instance;
    private Net net;
    private String netName;

    protected Pin(String name, Dir dir, float le, String netName) {
        this.name = name;
        this.dir = dir;
        this.le = le;
        this.netName = netName;
    }

    protected Dir getDir() {
        return this.dir;
    }

    protected String getName() {
        return this.name;
    }

    protected float getLE() {
        return this.le;
    }

    protected String getNetName() {
        return this.netName;
    }

    protected Instance getInstance() {
        return this.instance;
    }

    protected void setInstance(Instance instance) {
        this.instance = instance;
    }

    protected Net getNet() {
        return this.net;
    }

    protected void setNet(Net net) {
        this.net = net;
    }

    protected static ArrayList getPinListType(ArrayList pins, Dir dir) {
        ArrayList<Pin> typepins = new ArrayList<Pin>();
        for (int i = 0; i < pins.size(); ++i) {
            if (((Pin)pins.get(i)).getDir() != dir) continue;
            typepins.add((Pin)pins.get(i));
        }
        return typepins;
    }

    protected static ArrayList getInoutPins(ArrayList pins) {
        return Pin.getPinListType(pins, Dir.INOUT);
    }

    protected static ArrayList getInputPins(ArrayList pins) {
        return Pin.getPinListType(pins, Dir.INPUT);
    }

    protected static ArrayList getOutputPins(ArrayList pins) {
        return Pin.getPinListType(pins, Dir.OUTPUT);
    }

    protected static class Dir {
        private final String name;
        protected static final Dir INPUT = new Dir("input");
        protected static final Dir OUTPUT = new Dir("output");
        protected static final Dir INOUT = new Dir("inout");
        protected static final Dir NODIR = new Dir("nodir");

        private Dir(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

