/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.lib.LibFile;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.output.Spice;
import com.sun.electric.tool.io.output.Verilog;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ui.WaveformWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Simulation
extends Tool {
    public static Simulation tool = new Simulation();
    public static final Variable.Key RISE_DELAY_KEY = ElectricObject.newKey("SIM_rise_delay");
    public static final Variable.Key FALL_DELAY_KEY = ElectricObject.newKey("SIM_fall_delay");
    public static final Variable.Key WEAK_NODE_KEY = ElectricObject.newKey("SIM_weak_node");
    private static Pref cacheFastHenryUseSingleFrequency = Pref.makeBooleanPref("FastHenryUseSingleFrequency", Simulation.tool.prefs, false);
    private static Pref cacheFastHenryStartFrequency = Pref.makeDoublePref("FastHenryStartFrequency", Simulation.tool.prefs, 0.0);
    private static Pref cacheFastHenryEndFrequency = Pref.makeDoublePref("FastHenryEndFrequency", Simulation.tool.prefs, 0.0);
    private static Pref cacheFastHenryRunsPerDecade = Pref.makeIntPref("FastHenryRunsPerDecade", Simulation.tool.prefs, 1);
    private static Pref cacheFastHenryMultiPole = Pref.makeBooleanPref("FastHenryMultiPole", Simulation.tool.prefs, false);
    private static Pref cacheFastHenryNumPoles = Pref.makeIntPref("FastHenryNumPoles", Simulation.tool.prefs, 20);
    private static Pref cacheFastHenryDefThickness = Pref.makeDoublePref("FastHenryDefThickness", Simulation.tool.prefs, 2.0);
    private static Pref cacheFastHenryWidthSubdivisions = Pref.makeIntPref("FastHenryWidthSubdivisions", Simulation.tool.prefs, 1);
    private static Pref cacheFastHenryHeightSubdivisions = Pref.makeIntPref("FastHenryHeightSubdivisions", Simulation.tool.prefs, 1);
    private static Pref cacheFastHenryMaxSegLength = Pref.makeDoublePref("FastHenryMaxSegLength", Simulation.tool.prefs, 0.0);
    private static Pref cacheVerilogUseAssign = Pref.makeBooleanPref("VerilogUseAssign", Simulation.tool.prefs, false);
    private static Pref cacheVerilogUseTrireg;
    private static Pref cacheCDLLibName;
    private static Pref cacheCDLLibPath;
    private static Pref cacheCDLConvertBrackets;
    public static final int SPICE_ENGINE_2 = 0;
    public static final int SPICE_ENGINE_3 = 1;
    public static final int SPICE_ENGINE_H = 2;
    public static final int SPICE_ENGINE_P = 3;
    public static final int SPICE_ENGINE_G = 4;
    public static final int SPICE_ENGINE_S = 5;
    private static Pref cacheSpiceEngine;
    private static Pref cacheSpiceLevel;
    private static Pref cacheSpiceOutputFormat;
    public static final String spiceRunChoiceDontRun = "Don't Run";
    public static final String spiceRunChoiceRunIgnoreOutput = "Run, Ingore Output";
    public static final String spiceRunChoiceRunReportOutput = "Run, Report Output";
    private static final String[] spiceRunChoices;
    private static Pref cacheSpiceRunChoice;
    private static Pref cacheSpiceRunDir;
    private static Pref cacheSpiceUseRunDir;
    private static Pref cacheSpiceOutputOverwrite;
    private static Pref cacheSpiceRunProbe;
    private static Pref cacheSpiceRunProgram;
    private static Pref cacheSpiceRunProgramArgs;
    private static Pref cacheSpicePartsLibrary;
    private static Pref cacheSpiceHeaderCardInfo;
    private static Pref cacheSpiceTrailerCardInfo;
    private static Pref cacheSpiceUseParasitics;
    private static Pref cacheSpiceUseNodeNames;
    private static Pref cacheSpiceForceGlobalPwrGnd;
    private static Pref cacheSpiceUseCellParameters;
    private static Pref cacheSpiceWriteTransSizeInLambda;

    private Simulation() {
        super("simulation");
    }

    public void init() {
    }

    public static void setSpiceModel() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return;
        }
        NodeInst ni = (NodeInst)highlighter.getOneElectricObject(NodeInst.class);
        if (ni == null) {
            return;
        }
        SetSpiceModel job = new SetSpiceModel(ni);
    }

    public static void setVerilogWireCommand(int type) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return;
        }
        List list = highlighter.getHighlightedEObjs(false, true);
        if (list.size() == 0) {
            System.out.println("Must select arcs before setting their type");
            return;
        }
        SetWireType job = new SetWireType(list, type);
    }

    public static void setTransistorStrengthCommand(boolean weak) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return;
        }
        NodeInst ni = (NodeInst)highlighter.getOneElectricObject(NodeInst.class);
        if (ni == null) {
            return;
        }
        SetTransistorStrength job = new SetTransistorStrength(ni, weak);
    }

    public static void showSimulationData(SimData sd, WaveformWindow ww) {
        Variable var;
        if (ww != null) {
            ww.setSimData(sd);
            return;
        }
        Rectangle2D bounds = sd.getBounds();
        double lowTime = bounds.getMinX();
        double highTime = bounds.getMaxX();
        double lowValue = bounds.getMinY();
        double highValue = bounds.getMaxY();
        double timeRange = highTime - lowTime;
        WindowFrame wf = WindowFrame.createWaveformWindow(sd);
        ww = (WaveformWindow)wf.getContent();
        ww.setMainTimeCursor(timeRange * 0.2 + lowTime);
        ww.setExtensionTimeCursor(timeRange * 0.8 + lowTime);
        ww.setDefaultTimeRange(lowTime, highTime);
        if (sd.cell != null && (var = sd.cell.getVar(WaveformWindow.WINDOW_SIGNAL_ORDER)) != null && var.getObject() instanceof String[]) {
            String[] signalNames = (String[])var.getObject();
            boolean isAnalog = sd.isAnalog();
            boolean showedSomething = false;
            for (int i = 0; i < signalNames.length; ++i) {
                int tabPos;
                String signalName = signalNames[i];
                WaveformWindow.Panel wp = null;
                boolean firstSignal = true;
                int start = 0;
                block1: do {
                    tabPos = signalName.indexOf(9, start);
                    String sigName = null;
                    if (tabPos < 0) {
                        sigName = signalName.substring(start);
                    } else {
                        sigName = signalName.substring(start, tabPos);
                        start = tabPos + 1;
                    }
                    for (int j = 0; j < sd.signals.size(); ++j) {
                        SimSignal sSig = (SimSignal)sd.signals.get(j);
                        String aSigName = sSig.getSignalName();
                        if (sSig.getSignalContext() != null) {
                            aSigName = sSig.getSignalContext() + aSigName;
                        }
                        if (!sigName.equals(aSigName)) continue;
                        if (firstSignal) {
                            firstSignal = false;
                            wp = new WaveformWindow.Panel(ww, isAnalog);
                            if (isAnalog) {
                                wp.setValueRange(lowValue, highValue);
                            }
                            wp.makeSelectedPanel();
                            showedSomething = true;
                        }
                        new WaveformWindow.Signal(wp, sSig);
                        continue block1;
                    }
                } while (tabPos >= 0);
            }
            if (showedSomething) {
                return;
            }
        }
        if (sd.signals.size() > 0) {
            SimSignal sSig = (SimSignal)sd.signals.get(0);
            boolean isAnalog = false;
            if (sSig instanceof SimAnalogSignal) {
                isAnalog = true;
            }
            if (isAnalog) {
                WaveformWindow.Panel wp = new WaveformWindow.Panel(ww, isAnalog);
                wp.setValueRange(lowValue, highValue);
                wp.makeSelectedPanel();
            } else {
                for (int i = 0; i < sd.signals.size(); ++i) {
                    SimDigitalSignal sDSig = (SimDigitalSignal)sd.signals.get(i);
                    if (sDSig.getSignalContext() != null) continue;
                    WaveformWindow.Panel wp = new WaveformWindow.Panel(ww, false);
                    wp.makeSelectedPanel();
                    new WaveformWindow.Signal(wp, sDSig);
                }
            }
        }
        ww.getPanel().validate();
    }

    public static boolean isFastHenryUseSingleFrequency() {
        return cacheFastHenryUseSingleFrequency.getBoolean();
    }

    public static void setFastHenryUseSingleFrequency(boolean s) {
        cacheFastHenryUseSingleFrequency.setBoolean(s);
    }

    public static double getFastHenryStartFrequency() {
        return cacheFastHenryStartFrequency.getDouble();
    }

    public static void setFastHenryStartFrequency(double s) {
        cacheFastHenryStartFrequency.setDouble(s);
    }

    public static double getFastHenryEndFrequency() {
        return cacheFastHenryEndFrequency.getDouble();
    }

    public static void setFastHenryEndFrequency(double e) {
        cacheFastHenryEndFrequency.setDouble(e);
    }

    public static int getFastHenryRunsPerDecade() {
        return cacheFastHenryRunsPerDecade.getInt();
    }

    public static void setFastHenryRunsPerDecade(int r) {
        cacheFastHenryRunsPerDecade.setInt(r);
    }

    public static boolean isFastHenryMultiPole() {
        return cacheFastHenryMultiPole.getBoolean();
    }

    public static void setFastHenryMultiPole(boolean mp) {
        cacheFastHenryMultiPole.setBoolean(mp);
    }

    public static int getFastHenryNumPoles() {
        return cacheFastHenryNumPoles.getInt();
    }

    public static void setFastHenryNumPoles(int p) {
        cacheFastHenryNumPoles.setInt(p);
    }

    public static double getFastHenryDefThickness() {
        return cacheFastHenryDefThickness.getDouble();
    }

    public static void setFastHenryDefThickness(double t) {
        cacheFastHenryDefThickness.setDouble(t);
    }

    public static int getFastHenryWidthSubdivisions() {
        return cacheFastHenryWidthSubdivisions.getInt();
    }

    public static void setFastHenryWidthSubdivisions(int w) {
        cacheFastHenryWidthSubdivisions.setInt(w);
    }

    public static int getFastHenryHeightSubdivisions() {
        return cacheFastHenryHeightSubdivisions.getInt();
    }

    public static void setFastHenryHeightSubdivisions(int h) {
        cacheFastHenryHeightSubdivisions.setInt(h);
    }

    public static double getFastHenryMaxSegLength() {
        return cacheFastHenryMaxSegLength.getDouble();
    }

    public static void setFastHenryMaxSegLength(double s) {
        cacheFastHenryMaxSegLength.setDouble(s);
    }

    public static boolean getVerilogUseAssign() {
        return cacheVerilogUseAssign.getBoolean();
    }

    public static void setVerilogUseAssign(boolean use) {
        cacheVerilogUseAssign.setBoolean(use);
    }

    public static boolean getVerilogUseTrireg() {
        return cacheVerilogUseTrireg.getBoolean();
    }

    public static void setVerilogUseTrireg(boolean use) {
        cacheVerilogUseTrireg.setBoolean(use);
    }

    public static String getCDLLibName() {
        return cacheCDLLibName.getString();
    }

    public static void setCDLLibName(String libName) {
        cacheCDLLibName.setString(libName);
    }

    public static String getCDLLibPath() {
        return cacheCDLLibPath.getString();
    }

    public static void setCDLLibPath(String libName) {
        cacheCDLLibPath.setString(libName);
    }

    public static boolean isCDLConvertBrackets() {
        return cacheCDLConvertBrackets.getBoolean();
    }

    public static void setCDLConvertBrackets(boolean c) {
        cacheCDLConvertBrackets.setBoolean(c);
    }

    public static int getSpiceEngine() {
        return cacheSpiceEngine.getInt();
    }

    public static void setSpiceEngine(int engine) {
        cacheSpiceEngine.setInt(engine);
    }

    public static String getSpiceLevel() {
        return cacheSpiceLevel.getString();
    }

    public static void setSpiceLevel(String level) {
        cacheSpiceLevel.setString(level);
    }

    public static String getSpiceOutputFormat() {
        return cacheSpiceOutputFormat.getString();
    }

    public static void setSpiceOutputFormat(String format) {
        cacheSpiceOutputFormat.setString(format);
    }

    public static String[] getSpiceRunChoiceValues() {
        return spiceRunChoices;
    }

    public static String getSpiceRunChoice() {
        return spiceRunChoices[cacheSpiceRunChoice.getInt()];
    }

    public static void setSpiceRunChoice(String choice) {
        String[] values = Simulation.getSpiceRunChoiceValues();
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equals(choice)) continue;
            cacheSpiceRunChoice.setInt(i);
            return;
        }
    }

    public static String getSpiceRunDir() {
        return cacheSpiceRunDir.getString();
    }

    public static void setSpiceRunDir(String dir) {
        cacheSpiceRunDir.setString(dir);
    }

    public static boolean getSpiceUseRunDir() {
        return cacheSpiceUseRunDir.getBoolean();
    }

    public static void setSpiceUseRunDir(boolean b) {
        cacheSpiceUseRunDir.setBoolean(b);
    }

    public static boolean getSpiceOutputOverwrite() {
        return cacheSpiceOutputOverwrite.getBoolean();
    }

    public static void setSpiceOutputOverwrite(boolean b) {
        cacheSpiceOutputOverwrite.setBoolean(b);
    }

    public static boolean getSpiceRunProbe() {
        return cacheSpiceRunProbe.getBoolean();
    }

    public static void setSpiceRunProbe(boolean b) {
        cacheSpiceRunProbe.setBoolean(b);
    }

    public static String getSpiceRunProgram() {
        return cacheSpiceRunProgram.getString();
    }

    public static void setSpiceRunProgram(String c) {
        cacheSpiceRunProgram.setString(c);
    }

    public static String getSpiceRunProgramArgs() {
        return cacheSpiceRunProgramArgs.getString();
    }

    public static void setSpiceRunProgramArgs(String c) {
        cacheSpiceRunProgramArgs.setString(c);
    }

    public static String getSpicePartsLibrary() {
        if (cacheSpicePartsLibrary == null) {
            String[] libNames = LibFile.getSpicePartsLibraries();
            cacheSpicePartsLibrary = Pref.makeStringPref("SpicePartsLibrary", Simulation.tool.prefs, libNames[0]);
        }
        return cacheSpicePartsLibrary.getString();
    }

    public static void setSpicePartsLibrary(String parts) {
        if (cacheSpicePartsLibrary == null) {
            String[] libNames = LibFile.getSpicePartsLibraries();
            cacheSpicePartsLibrary = Pref.makeStringPref("SpicePartsLibrary", Simulation.tool.prefs, libNames[0]);
        }
        cacheSpicePartsLibrary.setString(parts);
    }

    public static String getSpiceHeaderCardInfo() {
        return cacheSpiceHeaderCardInfo.getString();
    }

    public static void setSpiceHeaderCardInfo(String spec) {
        cacheSpiceHeaderCardInfo.setString(spec);
    }

    public static String getSpiceTrailerCardInfo() {
        return cacheSpiceTrailerCardInfo.getString();
    }

    public static void setSpiceTrailerCardInfo(String spec) {
        cacheSpiceTrailerCardInfo.setString(spec);
    }

    public static boolean isSpiceUseParasitics() {
        return cacheSpiceUseParasitics.getBoolean();
    }

    public static void setSpiceUseParasitics(boolean p) {
        cacheSpiceUseParasitics.setBoolean(p);
    }

    public static boolean isSpiceUseNodeNames() {
        return cacheSpiceUseNodeNames.getBoolean();
    }

    public static void setSpiceUseNodeNames(boolean u) {
        cacheSpiceUseNodeNames.setBoolean(u);
    }

    public static boolean isSpiceForceGlobalPwrGnd() {
        return cacheSpiceForceGlobalPwrGnd.getBoolean();
    }

    public static void setSpiceForceGlobalPwrGnd(boolean g) {
        cacheSpiceForceGlobalPwrGnd.setBoolean(g);
    }

    public static boolean isSpiceUseCellParameters() {
        return cacheSpiceUseCellParameters.getBoolean();
    }

    public static void setSpiceUseCellParameters(boolean p) {
        cacheSpiceUseCellParameters.setBoolean(p);
    }

    public static boolean isSpiceWriteTransSizeInLambda() {
        return cacheSpiceWriteTransSizeInLambda.getBoolean();
    }

    public static void setSpiceWriteTransSizeInLambda(boolean l) {
        cacheSpiceWriteTransSizeInLambda.setBoolean(l);
    }

    static {
        cacheVerilogUseAssign.attachToObject(tool, "Tools/Verilog tab", "Verilog uses Assign construct");
        cacheVerilogUseTrireg = Pref.makeBooleanPref("VerilogUseTrireg", Simulation.tool.prefs, false);
        cacheVerilogUseTrireg.attachToObject(tool, "Tools/Verilog tab", "Verilog presumes wire is Trireg");
        cacheCDLLibName = Pref.makeStringPref("CDLLibName", Simulation.tool.prefs, "");
        cacheCDLLibPath = Pref.makeStringPref("CDLLibPath", Simulation.tool.prefs, "");
        cacheCDLConvertBrackets = Pref.makeBooleanPref("CDLConvertBrackets", Simulation.tool.prefs, false);
        cacheSpiceEngine = Pref.makeIntPref("SpiceEngine", Simulation.tool.prefs, 1);
        cacheSpiceLevel = Pref.makeStringPref("SpiceLevel", Simulation.tool.prefs, "1");
        cacheSpiceOutputFormat = Pref.makeStringPref("SpiceOutputFormat", Simulation.tool.prefs, "Standard");
        spiceRunChoices = new String[]{spiceRunChoiceDontRun, spiceRunChoiceRunIgnoreOutput, spiceRunChoiceRunReportOutput};
        cacheSpiceRunChoice = Pref.makeIntPref("SpiceRunChoice", Simulation.tool.prefs, 0);
        cacheSpiceRunDir = Pref.makeStringPref("SpiceRunDir", Simulation.tool.prefs, "");
        cacheSpiceUseRunDir = Pref.makeBooleanPref("SpiceUseRunDir", Simulation.tool.prefs, false);
        cacheSpiceOutputOverwrite = Pref.makeBooleanPref("SpiceOverwriteOutputFile", Simulation.tool.prefs, false);
        cacheSpiceRunProbe = Pref.makeBooleanPref("SpiceRunProbe", Simulation.tool.prefs, false);
        cacheSpiceRunProgram = Pref.makeStringPref("SpiceRunProgram", Simulation.tool.prefs, "");
        cacheSpiceRunProgramArgs = Pref.makeStringPref("SpiceRunProgramArgs", Simulation.tool.prefs, "");
        cacheSpicePartsLibrary = null;
        cacheSpiceHeaderCardInfo = Pref.makeStringPref("SpiceHeaderCardInfo", Simulation.tool.prefs, "");
        cacheSpiceTrailerCardInfo = Pref.makeStringPref("SpiceTrailerCardInfo", Simulation.tool.prefs, "");
        cacheSpiceUseParasitics = Pref.makeBooleanPref("SpiceUseParasitics", Simulation.tool.prefs, true);
        cacheSpiceUseNodeNames = Pref.makeBooleanPref("SpiceUseNodeNames", Simulation.tool.prefs, true);
        cacheSpiceForceGlobalPwrGnd = Pref.makeBooleanPref("SpiceForceGlobalPwrGnd", Simulation.tool.prefs, false);
        cacheSpiceUseCellParameters = Pref.makeBooleanPref("SpiceUseCellParameters", Simulation.tool.prefs, false);
        cacheSpiceWriteTransSizeInLambda = Pref.makeBooleanPref("SpiceWriteTransSizeInLambda", Simulation.tool.prefs, false);
    }

    private static class SetTransistorStrength
    extends Job {
        NodeInst ni;
        boolean weak;

        protected SetTransistorStrength(NodeInst ni, boolean weak) {
            super("Change Transistor Strength", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.weak = weak;
            this.startJob();
        }

        public boolean doIt() {
            if (this.weak) {
                Variable var = this.ni.newVar(WEAK_NODE_KEY, (Object)"Weak");
                var.setDisplay(true);
            } else if (this.ni.getVar(WEAK_NODE_KEY) != null) {
                this.ni.delVar(WEAK_NODE_KEY);
            }
            return true;
        }
    }

    private static class SetWireType
    extends Job {
        List list;
        int type;

        protected SetWireType(List list, int type) {
            super("Change Verilog Wire Types", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.list = list;
            this.type = type;
            this.startJob();
        }

        public boolean doIt() {
            Iterator it = this.list.iterator();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                switch (this.type) {
                    case 0: {
                        Variable var = ai.newVar(Verilog.WIRE_TYPE_KEY, (Object)"wire");
                        var.setDisplay(true);
                        break;
                    }
                    case 1: {
                        Variable var = ai.newVar(Verilog.WIRE_TYPE_KEY, (Object)"trireg");
                        var.setDisplay(true);
                        break;
                    }
                    case 2: {
                        if (ai.getVar(Verilog.WIRE_TYPE_KEY) == null) break;
                        ai.delVar(Verilog.WIRE_TYPE_KEY);
                    }
                }
            }
            return true;
        }
    }

    private static class SetSpiceModel
    extends Job {
        NodeInst ni;

        protected SetSpiceModel(NodeInst ni) {
            super("Set Spice Model", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.startJob();
        }

        public boolean doIt() {
            Variable var = this.ni.newVar(Spice.SPICE_MODEL_KEY, (Object)"SPICE-Model");
            var.setDisplay(true);
            return true;
        }
    }

    public static class SimDigitalSignal
    extends SimSignal {
        private int[] state;

        public SimDigitalSignal(SimData sd) {
            super(sd);
        }

        public void buildState(int numEvents) {
            this.state = new int[numEvents];
        }

        public void setState(int index, int st) {
            this.state[index] = st;
        }

        public int getState(int index) {
            return this.state[index];
        }

        public int[] getStateVector() {
            return this.state;
        }

        public void setStateVector(int[] state) {
            this.state = state;
        }

        public int getNumEvents() {
            return this.state.length;
        }
    }

    public static class SimAnalogSignal
    extends SimSignal {
        private static final int BASICSIGNAL = 0;
        private static final int SWEEPSIGNAL = 1;
        private static final int INTERVALSIGNAL = 2;
        private double[] values;
        private double[][] sweepValues;
        private double[] highIntervalValues;
        private int signalType;

        public SimAnalogSignal(SimData sd) {
            super(sd);
        }

        public void buildValues(int numEvents) {
            this.signalType = 0;
            this.values = new double[numEvents];
        }

        public void setNumSweeps(int numSweeps) {
            this.signalType = 1;
            this.sweepValues = new double[numSweeps][];
        }

        public void buildSweepValues(int sweep, int numEvents) {
            this.sweepValues[sweep] = new double[numEvents];
        }

        public void buildIntervalValues(int numEvents) {
            this.signalType = 2;
            this.values = new double[numEvents];
            this.highIntervalValues = new double[numEvents];
        }

        public void setValue(int index, double value) {
            if (this.signalType != 0) {
                System.out.println("Setting complex data into basic signal");
                return;
            }
            this.values[index] = value;
        }

        public void setSweepValue(int sweep, int index, double value) {
            if (this.signalType != 1) {
                System.out.println("Setting sweep data into non-sweep signal");
                return;
            }
            this.sweepValues[sweep][index] = value;
        }

        public void setIntervalValue(int index, double lowValue, double highValue) {
            if (this.signalType != 2) {
                System.out.println("Setting interval data into non-interval signal");
                return;
            }
            this.values[index] = lowValue;
            this.highIntervalValues[index] = highValue;
        }

        public double getValue(int index) {
            if (this.signalType != 0) {
                System.out.println("Getting basic data from non-basic signal");
                return 0.0;
            }
            return this.values[index];
        }

        public double getSweepValue(int sweep, int index) {
            if (this.signalType != 1) {
                System.out.println("Getting sweep data from non-sweep signal");
                return 0.0;
            }
            return this.sweepValues[sweep][index];
        }

        public double getIntervalLowValue(int index) {
            if (this.signalType != 2) {
                System.out.println("Getting interval data from non-interval signal");
                return 0.0;
            }
            return this.values[index];
        }

        public double getIntervalHighValue(int index) {
            if (this.signalType != 2) {
                System.out.println("Getting interval data from non-interval signal");
                return 0.0;
            }
            return this.highIntervalValues[index];
        }

        public int getNumEvents() {
            switch (this.signalType) {
                case 0: {
                    return this.values.length;
                }
                case 1: {
                    return this.sweepValues[0].length;
                }
                case 2: {
                    return this.values.length;
                }
            }
            return 0;
        }

        public int getNumEvents(int sweep) {
            if (this.signalType != 1) {
                return 0;
            }
            return this.sweepValues[sweep].length;
        }

        public int getNumSweeps() {
            if (this.signalType != 1) {
                return 0;
            }
            return this.sweepValues.length;
        }

        public boolean isBasic() {
            return this.signalType == 0;
        }

        public boolean isSweep() {
            return this.signalType == 1;
        }

        public boolean isInterval() {
            return this.signalType == 2;
        }

        public Point2D getRangeOfValues() {
            double lowValue = 0.0;
            double highValue = 0.0;
            switch (this.signalType) {
                case 0: {
                    for (int i = 0; i < this.getNumEvents(); ++i) {
                        double val = this.getValue(i);
                        if (i == 0) {
                            lowValue = highValue = val;
                            continue;
                        }
                        if (val < lowValue) {
                            lowValue = val;
                        }
                        if (!(val > highValue)) continue;
                        highValue = val;
                    }
                    break;
                }
                case 1: {
                    for (int s = 0; s < this.getNumSweeps(); ++s) {
                        for (int i = 0; i < this.getNumEvents(); ++i) {
                            double val = this.getSweepValue(s, i);
                            if (s == 0 && i == 0) {
                                lowValue = highValue = val;
                                continue;
                            }
                            if (val < lowValue) {
                                lowValue = val;
                            }
                            if (!(val > highValue)) continue;
                            highValue = val;
                        }
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < this.getNumEvents(); ++i) {
                        double lowVal = this.getIntervalLowValue(i);
                        double highVal = this.getIntervalHighValue(i);
                        if (i == 0) {
                            lowValue = lowVal;
                            highValue = highVal;
                            continue;
                        }
                        if (lowVal < lowValue) {
                            lowValue = lowVal;
                        }
                        if (!(highVal > highValue)) continue;
                        highValue = highVal;
                    }
                    break;
                }
            }
            return new Point2D.Double(lowValue, highValue);
        }
    }

    public static class SimSignal {
        private String signalName;
        private String signalContext;
        private SimData sd;
        private boolean useCommonTime;
        private double[] time;
        private List bussedSignals;
        public List tempList;

        private SimSignal(SimData sd) {
            this.sd = sd;
            this.useCommonTime = true;
            if (sd != null) {
                sd.signals.add(this);
            }
        }

        public void setSignalName(String signalName) {
            this.signalName = signalName;
        }

        public String getSignalName() {
            return this.signalName;
        }

        public void setSignalContext(String signalContext) {
            this.signalContext = signalContext;
        }

        public String getSignalContext() {
            return this.signalContext;
        }

        public String getFullName() {
            if (this.signalContext != null) {
                return this.signalContext + "." + this.signalName;
            }
            return this.signalName;
        }

        public int getNumEvents() {
            return 0;
        }

        public void buildBussedSignalList() {
            this.bussedSignals = new ArrayList();
        }

        public List getBussedSignals() {
            return this.bussedSignals;
        }

        public void addToBussedSignalList(SimSignal ws) {
            this.bussedSignals.add(ws);
        }

        public void buildTime(int numEvents) {
            this.useCommonTime = false;
            this.time = new double[numEvents];
        }

        public double getTime(int index) {
            if (this.useCommonTime) {
                return this.sd.commonTime[index];
            }
            return this.time[index];
        }

        public double getTime(int index, int sweep) {
            if (this.useCommonTime) {
                double[] sct = (double[])this.sd.sweepCommonTime.get(sweep);
                return sct[index];
            }
            return this.time[index];
        }

        public double[] getTimeVector() {
            return this.time;
        }

        public void setTimeVector(double[] time) {
            this.useCommonTime = false;
            this.time = time;
        }

        public void setTime(int entry, double t) {
            this.time[entry] = t;
        }

        public Rectangle2D getBounds() {
            double highValue;
            double lowValue;
            double highTime;
            double lowTime;
            block22: {
                SimDigitalSignal ds;
                boolean first;
                block20: {
                    SimAnalogSignal as;
                    block23: {
                        block21: {
                            lowTime = 0.0;
                            highTime = 0.0;
                            lowValue = 0.0;
                            highValue = 0.0;
                            first = true;
                            if (!(this instanceof SimAnalogSignal)) break block20;
                            as = (SimAnalogSignal)this;
                            if (!as.isBasic()) break block21;
                            for (int i = 0; i < as.values.length; ++i) {
                                double time = 0.0;
                                time = as.getTime(i);
                                if (first) {
                                    first = false;
                                    lowTime = highTime = time;
                                    lowValue = highValue = as.values[i];
                                    continue;
                                }
                                if (time < lowTime) {
                                    lowTime = time;
                                }
                                if (time > highTime) {
                                    highTime = time;
                                }
                                if (as.values[i] < lowValue) {
                                    lowValue = as.values[i];
                                }
                                if (!(as.values[i] > highValue)) continue;
                                highValue = as.values[i];
                            }
                            break block22;
                        }
                        if (!as.isSweep()) break block23;
                        for (int s = 0; s < as.sweepValues.length; ++s) {
                            for (int i = 0; i < as.sweepValues[s].length; ++i) {
                                double time = 0.0;
                                time = as.getTime(i, s);
                                double value = as.sweepValues[s][i];
                                if (first) {
                                    first = false;
                                    lowTime = highTime = time;
                                    lowValue = highValue = value;
                                    continue;
                                }
                                if (time < lowTime) {
                                    lowTime = time;
                                }
                                if (time > highTime) {
                                    highTime = time;
                                }
                                if (value < lowValue) {
                                    lowValue = value;
                                }
                                if (!(value > highValue)) continue;
                                highValue = value;
                            }
                        }
                        break block22;
                    }
                    if (!as.isInterval()) break block22;
                    for (int i = 0; i < as.values.length; ++i) {
                        double time = 0.0;
                        time = as.getTime(i);
                        double lowVal = as.values[i];
                        double highVal = as.values[i];
                        if (first) {
                            first = false;
                            lowTime = highTime = time;
                            lowValue = lowVal;
                            highValue = highVal;
                            continue;
                        }
                        if (time < lowTime) {
                            lowTime = time;
                        }
                        if (time > highTime) {
                            highTime = time;
                        }
                        if (lowVal < lowValue) {
                            lowValue = lowVal;
                        }
                        if (!(highVal > highValue)) continue;
                        highValue = highVal;
                    }
                    break block22;
                }
                if (this instanceof SimDigitalSignal && (ds = (SimDigitalSignal)this).state != null) {
                    for (int i = 0; i < ds.state.length; ++i) {
                        double time = 0.0;
                        time = ds.getTime(i);
                        if (first) {
                            first = false;
                            lowTime = highTime = time;
                            continue;
                        }
                        if (time < lowTime) {
                            lowTime = time;
                        }
                        if (!(time > highTime)) continue;
                        highTime = time;
                    }
                }
            }
            return new Rectangle2D.Double(lowTime, lowValue, highTime - lowTime, highValue - lowValue);
        }
    }

    public static class SimData {
        public static final int LOGIC = 3;
        public static final int LOGIC_LOW = 0;
        public static final int LOGIC_X = 1;
        public static final int LOGIC_HIGH = 2;
        public static final int LOGIC_Z = 3;
        public static final int STRENGTH = 12;
        public static final int OFF_STRENGTH = 0;
        public static final int NODE_STRENGTH = 4;
        public static final int GATE_STRENGTH = 8;
        public static final int VDD_STRENGTH = 12;
        private Cell cell;
        private FileType type;
        private URL fileURL;
        private List signals = new ArrayList();
        private List sweeps = new ArrayList();
        private double[] commonTime;
        private List sweepCommonTime = new ArrayList();

        public List getSignals() {
            return this.signals;
        }

        public void addSignal(SimSignal ws) {
            this.signals.add(ws);
        }

        public void buildCommonTime(int numEvents) {
            this.commonTime = new double[numEvents];
        }

        public void addCommonTime(int numEvents) {
            double[] sct = new double[numEvents];
            this.sweepCommonTime.add(sct);
        }

        public void setCommonTime(int index, double time) {
            this.commonTime[index] = time;
        }

        public void setCommonTime(int index, int sweep, double time) {
            double[] sct = (double[])this.sweepCommonTime.get(sweep);
            sct[index] = time;
        }

        public void addSweep(Object obj) {
            this.sweeps.add(obj);
        }

        public List getSweepList() {
            return this.sweeps;
        }

        public void setCell(Cell cell) {
            this.cell = cell;
        }

        public Cell getCell() {
            return this.cell;
        }

        public void setDataType(FileType type) {
            this.type = type;
        }

        public FileType getDataType() {
            return this.type;
        }

        public void setFileURL(URL fileURL) {
            this.fileURL = fileURL;
        }

        public URL getFileURL() {
            return this.fileURL;
        }

        public Rectangle2D getBounds() {
            Rectangle2D bounds = new Rectangle2D.Double();
            boolean first = true;
            Iterator it = this.signals.iterator();
            while (it.hasNext()) {
                SimSignal sig = (SimSignal)it.next();
                Rectangle2D sigBounds = sig.getBounds();
                if (first) {
                    bounds = sigBounds;
                    first = false;
                    continue;
                }
                Rectangle2D.union(bounds, sigBounds, bounds);
            }
            return bounds;
        }

        public boolean isAnalog() {
            SimSignal sSig;
            return this.getSignals().size() > 0 && (sSig = (SimSignal)this.getSignals().get(0)) instanceof SimAnalogSignal;
        }

        public SimSignal findSignalForNetwork(String netName) {
            Iterator it = this.getSignals().iterator();
            while (it.hasNext()) {
                SimSignal sSig = (SimSignal)it.next();
                String signalName = sSig.getFullName();
                if (netName.equalsIgnoreCase(signalName)) {
                    return sSig;
                }
                if (signalName.length() + 1 == netName.length() && netName.charAt(signalName.length()) == ']') {
                    signalName = signalName + "_";
                }
                if (signalName.length() != netName.length() || signalName.indexOf(95) < 0) continue;
                boolean matches = true;
                for (int i = 0; i < signalName.length(); ++i) {
                    char sigChar = signalName.charAt(i);
                    char netChar = netName.charAt(i);
                    if (TextUtils.isLetterOrDigit(sigChar) != TextUtils.isLetterOrDigit(netChar)) {
                        matches = false;
                        break;
                    }
                    if (!TextUtils.isLetterOrDigit(sigChar) || Character.toLowerCase(sigChar) == Character.toLowerCase(netChar)) continue;
                    matches = false;
                    break;
                }
                if (!matches) continue;
                return sSig;
            }
            return null;
        }
    }
}

