/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class GeneralTab
extends PreferencePanel {
    private boolean initialBeepAfterLongJobs;
    private boolean initialShowFileSelectionForNetlists;
    private boolean initialShowCursorCoordinates;
    private boolean initialIncludeDateAndVersion;
    private int initialPanningDistance;
    private int initialErrorLimit;
    private long initialMaxMem;
    private int initialMaxUndo;
    private String initialWorkingDirSetting;
    private JPanel general;
    private JCheckBox generalBeepAfterLongJobs;
    private JTextField generalErrorLimit;
    private JCheckBox generalIncludeDateAndVersion;
    private JTextField generalMaxMem;
    private JLabel generalMemoryUsage;
    private JComboBox generalPanningDistance;
    private JCheckBox generalShowCursorCoordinates;
    private JCheckBox generalShowFileDialog;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel46;
    private JLabel jLabel53;
    private JLabel jLabel60;
    private JLabel jLabel61;
    private JLabel jLabel62;
    private JPanel jPanel11;
    private JTextField maxUndoHistory;
    private JComboBox workingDirComboBox;

    public GeneralTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.general;
    }

    public String getName() {
        return "General";
    }

    public void init() {
        this.initialBeepAfterLongJobs = User.isBeepAfterLongJobs();
        this.generalBeepAfterLongJobs.setSelected(this.initialBeepAfterLongJobs);
        this.initialShowFileSelectionForNetlists = User.isShowFileSelectionForNetlists();
        this.generalShowFileDialog.setSelected(this.initialShowFileSelectionForNetlists);
        this.initialShowCursorCoordinates = User.isShowCursorCoordinatesInStatus();
        this.generalShowCursorCoordinates.setSelected(this.initialShowCursorCoordinates);
        this.initialIncludeDateAndVersion = User.isIncludeDateAndVersionInOutput();
        this.generalIncludeDateAndVersion.setSelected(this.initialIncludeDateAndVersion);
        this.initialWorkingDirSetting = User.getInitialWorkingDirectorySetting();
        Iterator it = User.getInitialWorkingDirectorySettings();
        while (it.hasNext()) {
            this.workingDirComboBox.addItem(it.next());
        }
        this.workingDirComboBox.setSelectedItem(this.initialWorkingDirSetting);
        this.generalPanningDistance.addItem("Small");
        this.generalPanningDistance.addItem("Medium");
        this.generalPanningDistance.addItem("Large");
        this.initialPanningDistance = User.getPanningDistance();
        this.generalPanningDistance.setSelectedIndex(this.initialPanningDistance);
        this.initialErrorLimit = User.getErrorLimit();
        this.generalErrorLimit.setText(Integer.toString(this.initialErrorLimit));
        this.initialMaxUndo = User.getMaxUndoHistory();
        this.maxUndoHistory.setText(Integer.toString(this.initialMaxUndo));
        Runtime runtime = Runtime.getRuntime();
        long maxMemLimit = runtime.maxMemory() / 1024L / 1024L;
        this.generalMemoryUsage.setText("Current memory usage: " + Long.toString(maxMemLimit) + " megabytes");
        this.initialMaxMem = User.getMemorySize();
        this.generalMaxMem.setText(Long.toString(this.initialMaxMem));
    }

    public void term() {
        int currentMaxUndo;
        int currentMaxMem;
        int curentErrorLimit;
        int currentPanningDistance;
        String currentInitialWorkingDirSetting;
        boolean curentIncludeDateAndVersion;
        boolean currentShowCursorCoordinates;
        boolean curentShowFileSelectionForNetlists;
        boolean curentBeepAfterLongJobs = this.generalBeepAfterLongJobs.isSelected();
        if (curentBeepAfterLongJobs != this.initialBeepAfterLongJobs) {
            User.setBeepAfterLongJobs(curentBeepAfterLongJobs);
        }
        if ((curentShowFileSelectionForNetlists = this.generalShowFileDialog.isSelected()) != this.initialShowFileSelectionForNetlists) {
            User.setShowFileSelectionForNetlists(curentShowFileSelectionForNetlists);
        }
        if ((currentShowCursorCoordinates = this.generalShowCursorCoordinates.isSelected()) != this.initialShowCursorCoordinates) {
            User.setShowCursorCoordinatesInStatus(currentShowCursorCoordinates);
        }
        if ((curentIncludeDateAndVersion = this.generalIncludeDateAndVersion.isSelected()) != this.initialIncludeDateAndVersion) {
            User.setIncludeDateAndVersionInOutput(curentIncludeDateAndVersion);
        }
        if (!(currentInitialWorkingDirSetting = (String)this.workingDirComboBox.getSelectedItem()).equals(this.initialWorkingDirSetting)) {
            User.setInitialWorkingDirectorySetting(currentInitialWorkingDirSetting);
        }
        if ((currentPanningDistance = this.generalPanningDistance.getSelectedIndex()) != this.initialPanningDistance) {
            User.setPanningDistance(currentPanningDistance);
        }
        if ((curentErrorLimit = TextUtils.atoi(this.generalErrorLimit.getText())) != this.initialErrorLimit) {
            User.setErrorLimit(curentErrorLimit);
        }
        if ((long)(currentMaxMem = TextUtils.atoi(this.generalMaxMem.getText())) != this.initialMaxMem) {
            User.setMemorySize(currentMaxMem);
        }
        if ((currentMaxUndo = TextUtils.atoi(this.maxUndoHistory.getText())) != this.initialMaxUndo) {
            User.setMaxUndoHistory(currentMaxUndo);
            Undo.setHistoryListSize(currentMaxUndo);
        }
    }

    private void initComponents() {
        this.general = new JPanel();
        this.generalBeepAfterLongJobs = new JCheckBox();
        this.generalIncludeDateAndVersion = new JCheckBox();
        this.generalShowFileDialog = new JCheckBox();
        this.jLabel46 = new JLabel();
        this.generalErrorLimit = new JTextField();
        this.jLabel53 = new JLabel();
        this.jPanel11 = new JPanel();
        this.jLabel60 = new JLabel();
        this.generalMaxMem = new JTextField();
        this.jLabel61 = new JLabel();
        this.generalMemoryUsage = new JLabel();
        this.jLabel62 = new JLabel();
        this.generalShowCursorCoordinates = new JCheckBox();
        this.generalPanningDistance = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.maxUndoHistory = new JTextField();
        this.jLabel3 = new JLabel();
        this.workingDirComboBox = new JComboBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GeneralTab.this.closeDialog(evt);
            }
        });
        this.general.setLayout(new GridBagLayout());
        this.generalBeepAfterLongJobs.setText("Beep after long jobs");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.general.add((Component)this.generalBeepAfterLongJobs, gridBagConstraints);
        this.generalIncludeDateAndVersion.setText("Include date and version in output files");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.general.add((Component)this.generalIncludeDateAndVersion, gridBagConstraints);
        this.generalShowFileDialog.setText("Show file-selection dialog before writing netlists");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.general.add((Component)this.generalShowFileDialog, gridBagConstraints);
        this.jLabel46.setText("Maximum errors to report:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 17;
        this.general.add((Component)this.jLabel46, gridBagConstraints);
        this.generalErrorLimit.setColumns(6);
        this.generalErrorLimit.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.general.add((Component)this.generalErrorLimit, gridBagConstraints);
        this.jLabel53.setText("(0 for infinite)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.general.add((Component)this.jLabel53, gridBagConstraints);
        this.jPanel11.setLayout(new GridBagLayout());
        this.jPanel11.setBorder(new TitledBorder("Memory"));
        this.jLabel60.setText("Maximum memory:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel11.add((Component)this.jLabel60, gridBagConstraints);
        this.generalMaxMem.setColumns(6);
        this.generalMaxMem.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel11.add((Component)this.generalMaxMem, gridBagConstraints);
        this.jLabel61.setText("megabytes");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel11.add((Component)this.jLabel61, gridBagConstraints);
        this.generalMemoryUsage.setText("Current memory usage:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel11.add((Component)this.generalMemoryUsage, gridBagConstraints);
        this.jLabel62.setText("Changes to memory take effect when Electric is next run");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel11.add((Component)this.jLabel62, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.general.add((Component)this.jPanel11, gridBagConstraints);
        this.generalShowCursorCoordinates.setText("Show cursor coordinates in status bar");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.general.add((Component)this.generalShowCursorCoordinates, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.general.add((Component)this.generalPanningDistance, gridBagConstraints);
        this.jLabel1.setText("Panning distance:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 17;
        this.general.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Maximum undo history");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 17;
        this.general.add((Component)this.jLabel2, gridBagConstraints);
        this.maxUndoHistory.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.general.add((Component)this.maxUndoHistory, gridBagConstraints);
        this.jLabel3.setText("Working directory:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 17;
        this.general.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.general.add((Component)this.workingDirComboBox, gridBagConstraints);
        this.getContentPane().add((Component)this.general, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

