/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.result.equivalence;

import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.result.equivalence.InstancePathToNccContext;
import com.sun.electric.tool.ncc.result.equivalence.NccContext;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;

class NodeEquivalence
implements Serializable {
    static final long serialVersionUID = 0L;
    private final HierarchyEnumerator.NodableNameProxy[][] equivNodes;
    private final int numDesigns;
    private final int numNodes;
    private InstancePathToNccContext[] instToNccCtxt;
    private int lastDesignHit;

    private void pr(String s) {
        System.out.print(s);
    }

    private void prln(String s) {
        System.out.println(s);
    }

    private void buildNameTree() {
        if (this.instToNccCtxt != null) {
            return;
        }
        this.instToNccCtxt = new InstancePathToNccContext[this.numDesigns];
        for (int i = 0; i < this.numDesigns; ++i) {
            LayoutLib.error(this.equivNodes[i].length != this.numNodes, "designs don't have same numbers of nodables?");
            this.instToNccCtxt[i] = new InstancePathToNccContext(this.equivNodes[i]);
        }
    }

    public NodeEquivalence(HierarchyEnumerator.NodableNameProxy[][] equivNodes) {
        this.equivNodes = equivNodes;
        this.numDesigns = equivNodes.length;
        this.numNodes = equivNodes[0].length;
    }

    private HierarchyEnumerator.NodableNameProxy findEquivalent(VarContext vc, Nodable node, int designIndex) {
        LayoutLib.error(designIndex != 0 && designIndex != 1, "designIndex must be 0 or 1");
        this.buildNameTree();
        InstancePathToNccContext nameIndex = this.instToNccCtxt[designIndex];
        NccContext nc = nameIndex.findNccContext(vc);
        if (nc == null) {
            return null;
        }
        if (nc.getCell() != node.getParent()) {
            return null;
        }
        if (!nc.getContext().equals(vc)) {
            return null;
        }
        Iterator<Integer> it = nc.getIndices();
        while (it.hasNext()) {
            int index = it.next();
            HierarchyEnumerator.NodableNameProxy prox = this.equivNodes[designIndex][index];
            if (!prox.leafName().equals(node.getName())) continue;
            int equivDesign = designIndex == 0 ? 1 : 0;
            return this.equivNodes[equivDesign][index];
        }
        return null;
    }

    private int countUnique() {
        HashSet<Nodable> nodes = new HashSet<Nodable>();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < this.numNodes; ++j) {
                nodes.add(this.equivNodes[i][j].getNodable());
            }
        }
        return nodes.size();
    }

    public HierarchyEnumerator.NodableNameProxy findEquivalent(VarContext vc, Nodable node) {
        HierarchyEnumerator.NodableNameProxy nnp = this.findEquivalent(vc, node, this.lastDesignHit);
        if (nnp != null) {
            return nnp;
        }
        int otherDesign = this.lastDesignHit == 0 ? 1 : 0;
        nnp = this.findEquivalent(vc, node, otherDesign);
        if (nnp != null) {
            this.lastDesignHit = otherDesign;
            return nnp;
        }
        return null;
    }

    void clearCache() {
        this.instToNccCtxt = null;
    }

    public int regressionTest() {
        LayoutLib.error(this.numDesigns != 2, "we must have exactly two designs");
        int numErrors = 0;
        for (int desNdx = 0; desNdx < this.numDesigns; ++desNdx) {
            int otherDesign = desNdx == 0 ? 1 : 0;
            for (int nodeNdx = 0; nodeNdx < this.numNodes; ++nodeNdx) {
                Nodable fromNode;
                HierarchyEnumerator.NodableNameProxy from = this.equivNodes[desNdx][nodeNdx];
                VarContext fromVc = from.getContext();
                HierarchyEnumerator.NodableNameProxy to = this.findEquivalent(fromVc, fromNode = from.getNodable());
                if (to == this.equivNodes[otherDesign][nodeNdx]) continue;
                ++numErrors;
                this.prln("      From: " + from.toString());
                this.prln("      To: " + (to == null ? "null" : to.toString()));
                this.prln("      Equiv: " + this.equivNodes[otherDesign][nodeNdx]);
            }
        }
        this.pr("    Node equivalence regression " + (numErrors == 0 ? "passed. " : "failed. "));
        this.pr(" Equiv table size=" + this.numNodes + ". ");
        this.pr(" Num unique Nodables=" + this.countUnique() + ". ");
        if (numErrors != 0) {
            System.out.print(numErrors + " errors.");
        }
        this.pr("\n");
        return numErrors;
    }
}

